/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLUtil {
    private static String KEY_STORE_TYPE = "JKS";
    private static String TRUST_STORE_TYPE = "JKS";
    private static String KEY_MANAGER_TYPE = "SunX509";
    private static String TRUST_MANAGER_TYPE = "SunX509";
    private static String PROTOCOL = "TLS";
    private static SSLContext serverSSLCtx = null;
    private static SSLContext clientSSLCtx = null;
    private static final Log LOGGER = LogFactory.getLog(SSLUtil.class);

    public static SSLContext createServerSSLContext(String keyStoreLocation, String keyStorePwd) {
        try {
            if (serverSSLCtx == null) {
                KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
                keyStore.load(new FileInputStream(keyStoreLocation), keyStorePwd.toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEY_MANAGER_TYPE);
                keyManagerFactory.init(keyStore, keyStorePwd.toCharArray());
                serverSSLCtx = SSLContext.getInstance(PROTOCOL);
                serverSSLCtx.init(keyManagerFactory.getKeyManagers(), null, null);
            }
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception was thrown while building the server SSL Context", (Throwable)e);
        }
        return serverSSLCtx;
    }

    public static SSLContext createClientSSLContext(String trustStoreLocation, String trustStorePwd) {
        try {
            if (clientSSLCtx == null) {
                KeyStore trustStore = KeyStore.getInstance(TRUST_STORE_TYPE);
                trustStore.load(new FileInputStream(trustStoreLocation), trustStorePwd.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_TYPE);
                trustManagerFactory.init(trustStore);
                clientSSLCtx = SSLContext.getInstance(PROTOCOL);
                clientSSLCtx.init(null, trustManagerFactory.getTrustManagers(), null);
            }
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        return clientSSLCtx;
    }

    public static TrustManagerFactory createTrustmanager(String trustStoreLocation, String trustStorePwd) {
        TrustManagerFactory trustManagerFactory = null;
        try {
            if (clientSSLCtx == null) {
                KeyStore trustStore = KeyStore.getInstance(TRUST_STORE_TYPE);
                trustStore.load(new FileInputStream(trustStoreLocation), trustStorePwd.toCharArray());
                trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_TYPE);
                trustManagerFactory.init(trustStore);
            }
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception was thrown while building the client SSL Context", (Throwable)e);
        }
        return trustManagerFactory;
    }
}

