/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.websocket.transport.service.SecureWebsocketTransportService;
import org.wso2.carbon.websocket.transport.service.ServiceReferenceHolder;
import org.wso2.carbon.websocket.transport.service.WebsocketTransportService;

@Component(name="ws.transport.services", immediate=true)
public class WebsocketTransportServiceComponent {
    private static Log log = LogFactory.getLog(WebsocketTransportServiceComponent.class);
    private ConfigurationContextService contextService;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Websocket Transport bundle is activated");
        }
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.websocket.transport bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            new TransportPersistenceManager(configContext.getAxisConfiguration()).saveTransportConfiguration("ws", ctxt.getBundleContext().getBundle().getResource("websocket-transports.xml"));
            new TransportPersistenceManager(configContext.getAxisConfiguration()).saveTransportConfiguration("wss", ctxt.getBundleContext().getBundle().getResource("secure-websocket-transports.xml"));
            WebsocketTransportService WebsocketTransport = new WebsocketTransportService();
            SecureWebsocketTransportService SecureWebsocketTransport = new SecureWebsocketTransportService();
            ctxt.getBundleContext().registerService(TransportService.class.getName(), (Object)WebsocketTransport, null);
            ctxt.getBundleContext().registerService(TransportService.class.getName(), (Object)SecureWebsocketTransport, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the ws(s) transport service");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating Websocket transport management bundle", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Websocket Transport bundle is deactivated ");
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
        ServiceReferenceHolder.getInstance().setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
        ServiceReferenceHolder.getInstance().setConfigurationContextService(null);
    }
}

