/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundResponseSender;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.wso2.carbon.websocket.transport.WebSocketClientHandler;
import org.wso2.carbon.websocket.transport.WebsocketConnectionFactory;
import org.wso2.carbon.websocket.transport.utils.LogUtil;

public class WebsocketTransportSender
extends AbstractTransportSender {
    private WebsocketConnectionFactory connectionFactory;
    private static final Log log = LogFactory.getLog(WebsocketTransportSender.class);

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing WS Connection Factory.");
        }
        super.init(cfgCtx, transportOut);
        this.connectionFactory = new WebsocketConnectionFactory(transportOut);
    }

    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo trpOut) throws AxisFault {
        String sourceIdentier = null;
        boolean handshakePresent = false;
        String responceDispatchSequence = null;
        String responceErrorSequence = null;
        String messageType = null;
        String wsSubProtocol = null;
        HashMap<String, Object> customHeaders = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint url: " + targetEPR));
        }
        InboundResponseSender responseSender = null;
        if (msgCtx.getProperty("inbound-response-worker") != null) {
            responseSender = (InboundResponseSender)msgCtx.getProperty("inbound-response-worker");
            sourceIdentier = ((ChannelHandlerContext)msgCtx.getProperty("websocket.source.handler.context")).channel().toString();
        } else {
            sourceIdentier = "universal.source.identifier";
        }
        if (msgCtx.getProperty("websocket.source.handshake.present") != null && msgCtx.getProperty("websocket.source.handshake.present").equals(true)) {
            handshakePresent = true;
        }
        if (msgCtx.getProperty("ws.outflow.dispatch.sequence") != null) {
            responceDispatchSequence = (String)msgCtx.getProperty("ws.outflow.dispatch.sequence");
        }
        if (msgCtx.getProperty("ws.outflow.dispatch.fault.sequence") != null) {
            responceErrorSequence = (String)msgCtx.getProperty("ws.outflow.dispatch.fault.sequence");
        }
        if (msgCtx.getProperty("websocket.accept.contenType") != null) {
            messageType = (String)msgCtx.getProperty("websocket.accept.contenType");
        }
        if (msgCtx.getProperty("websocket.subprotocol") != null) {
            wsSubProtocol = (String)msgCtx.getProperty("websocket.subprotocol");
        }
        Iterator propertyNames = msgCtx.getPropertyNames();
        Parameter wsCustomHeaderParam = msgCtx.getTransportOut().getParameter("ws.custom.header");
        String webSocketCustomHeaderPrefix = wsCustomHeaderParam == null || wsCustomHeaderParam.getValue() == null || wsCustomHeaderParam.getValue().toString().isEmpty() ? "websocket.custom.header." : wsCustomHeaderParam.getValue().toString();
        while (propertyNames.hasNext()) {
            String propertyName = (String)propertyNames.next();
            if (!propertyName.startsWith(webSocketCustomHeaderPrefix)) continue;
            Object value = msgCtx.getProperty(propertyName);
            String[] headerSplits = propertyName.split(webSocketCustomHeaderPrefix);
            if (headerSplits.length > 1) {
                customHeaders.put(headerSplits[1], value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Adding Custom Header " + headerSplits[1] + ":" + value));
                continue;
            }
            log.warn((Object)"A header identified with having only the websocket custom-header prefix as the key (without a unique postfix). Hence dropping the header.");
        }
        try {
            BinaryWebSocketFrame frame;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fetching a Connection from the WS(WSS) Connection Factory.");
            }
            WebSocketClientHandler clientHandler = this.connectionFactory.getChannelHandler(new URI(targetEPR), sourceIdentier, handshakePresent, responceDispatchSequence, responceErrorSequence, messageType, wsSubProtocol, customHeaders);
            String tenantDomain = (String)msgCtx.getProperty("tenantDomain");
            if (tenantDomain != null) {
                clientHandler.setTenantDomain(tenantDomain);
            } else {
                clientHandler.setTenantDomain("carbon.super");
            }
            if (!sourceIdentier.equals("universal.source.identifier")) {
                clientHandler.registerWebsocketResponseSender(responseSender);
                clientHandler.setDispatchSequence(responceDispatchSequence);
                clientHandler.setDispatchErrorSequence(responceErrorSequence);
            }
            if (msgCtx.getProperty("websocket.binary.frame.present") != null && msgCtx.getProperty("websocket.binary.frame.present").equals(true)) {
                frame = (BinaryWebSocketFrame)msgCtx.getProperty("websocket.binary.frame");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending the binary frame to the WS server on context id : " + clientHandler.getChannelHandlerContext().channel().toString()));
                }
                if (clientHandler.getChannelHandlerContext().channel().isActive()) {
                    clientHandler.getChannelHandlerContext().channel().writeAndFlush((Object)frame.retain());
                    if (log.isDebugEnabled()) {
                        LogUtil.printWebSocketFrame(log, (WebSocketFrame)frame, clientHandler.getChannelHandlerContext(), false);
                    }
                }
            } else if (msgCtx.getProperty("websocket.text.frame.present") != null && msgCtx.getProperty("websocket.text.frame.present").equals(true)) {
                frame = (TextWebSocketFrame)msgCtx.getProperty("websocket.text.frame");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending the passthrough text frame to the WS server on context id : " + clientHandler.getChannelHandlerContext().channel().toString()));
                }
                if (clientHandler.getChannelHandlerContext().channel().isActive()) {
                    clientHandler.getChannelHandlerContext().channel().writeAndFlush((Object)frame.retain());
                    if (log.isDebugEnabled()) {
                        LogUtil.printWebSocketFrame(log, (WebSocketFrame)frame, clientHandler.getChannelHandlerContext(), false);
                    }
                }
            } else if (!handshakePresent) {
                RelayUtils.buildMessage((MessageContext)msgCtx, (boolean)false);
                OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgCtx);
                MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgCtx);
                StringWriter sw = new StringWriter();
                WriterOutputStream out = new WriterOutputStream((Writer)sw, format.getCharSetEncoding());
                messageFormatter.writeTo(msgCtx, format, (OutputStream)out, true);
                out.close();
                String msg = sw.toString();
                TextWebSocketFrame frame2 = new TextWebSocketFrame(msg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending the text frame to the WS server on context id : " + clientHandler.getChannelHandlerContext().channel().toString()));
                }
                if (clientHandler.getChannelHandlerContext().channel().isActive()) {
                    clientHandler.getChannelHandlerContext().channel().writeAndFlush((Object)frame2.retain());
                    if (log.isDebugEnabled()) {
                        LogUtil.printWebSocketFrame(log, (WebSocketFrame)frame2, clientHandler.getChannelHandlerContext(), false);
                    }
                }
            } else {
                clientHandler.acknowledgeHandshake();
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error parsing the WS endpoint url", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error writting to the websocket channel", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error writting to the websocket channel", (Throwable)e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error while building message", e);
        }
    }
}

