/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.websocket.transport.SubprotocolBuilderUtil;
import org.wso2.carbon.websocket.transport.WebSocketClientHandler;
import org.wso2.carbon.websocket.transport.utils.SSLUtil;

public class WebsocketConnectionFactory {
    private static final Log log = LogFactory.getLog(WebsocketConnectionFactory.class);
    private final TransportOutDescription transportOut;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, WebSocketClientHandler>> channelHandlerPool = new ConcurrentHashMap();

    public WebsocketConnectionFactory(TransportOutDescription transportOut) throws AxisFault {
        this.transportOut = transportOut;
        boolean sslEnabled = "wss".equalsIgnoreCase(transportOut.getName());
        if (sslEnabled) {
            Parameter trustParam = transportOut.getParameter("ws.trust.store");
            if (trustParam != null) {
                OMElement trustStoreLocationElem = trustParam.getParameterElement().getFirstChildWithName(new QName("ws.trust.store.location"));
                OMElement trustStorePasswordElem = trustParam.getParameterElement().getFirstChildWithName(new QName("ws.trust.store.Password"));
                if (trustStoreLocationElem == null || trustStorePasswordElem == null) {
                    WebsocketConnectionFactory.handleWssTrustStoreParameterError("Unable to read parameter(s) ws.trust.store.location and/or ws.trust.store.Password from Transport configurations");
                }
            } else {
                WebsocketConnectionFactory.handleWssTrustStoreParameterError("Unable to read parameter(s) ws.trust.store.location and/or ws.trust.store.Password from Transport configurations");
            }
        }
    }

    public WebSocketClientHandler getChannelHandler(URI uri, String sourceIdentifier, boolean handshakePresent, String dispatchSequence, String dispatchErrorSequence, String contentType, String wsSubprotocol, Map<String, Object> headers) throws InterruptedException {
        WebSocketClientHandler channelHandler;
        if (handshakePresent) {
            channelHandler = this.cacheNewConnection(uri, sourceIdentifier, dispatchSequence, dispatchErrorSequence, contentType, wsSubprotocol, headers);
        } else {
            channelHandler = this.getChannelHandlerFromPool(sourceIdentifier, this.getClientHandlerIdentifier(uri));
            if (channelHandler == null) {
                channelHandler = this.cacheNewConnection(uri, sourceIdentifier, dispatchSequence, dispatchErrorSequence, contentType, wsSubprotocol, headers);
            }
        }
        channelHandler.handshakeFuture().sync();
        return channelHandler;
    }

    public String getClientHandlerIdentifier(URI uri) {
        String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort();
        String subscriberPath = uri.getPath();
        return host.concat(String.valueOf(port)).concat(subscriberPath);
    }

    public WebSocketClientHandler cacheNewConnection(URI uri, String sourceIdentifier, String dispatchSequence, String dispatchErrorSequence, String contentType, String wsSubprotocol, Map<String, Object> headers) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a Connection for the specified WS endpoint.");
        }
        try {
            SslContext sslCtx;
            int port;
            String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
            final String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            switch (scheme) {
                case "ws": {
                    if (uri.getPort() < 0) {
                        port = 80;
                        break;
                    }
                    port = uri.getPort();
                    break;
                }
                case "wss": {
                    if (uri.getPort() < 0) {
                        port = 443;
                        break;
                    }
                    port = uri.getPort();
                    break;
                }
                default: {
                    return null;
                }
            }
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            if (ssl) {
                Parameter trustParam = this.transportOut.getParameter("ws.trust.store");
                if (trustParam != null) {
                    OMElement trustStoreLocationElem = trustParam.getParameterElement().getFirstChildWithName(new QName("ws.trust.store.location"));
                    OMElement oMElement = trustParam.getParameterElement().getFirstChildWithName(new QName("ws.trust.store.Password"));
                    String location = trustStoreLocationElem.getText();
                    String storePassword = oMElement.getText();
                    sslCtx = SslContextBuilder.forClient().trustManager(SSLUtil.createTrustmanager(location, storePassword)).build();
                } else {
                    sslCtx = null;
                }
            } else {
                sslCtx = null;
            }
            if (sourceIdentifier.equals("universal.source.identifier")) {
                Parameter errorParam;
                Parameter dispatchParam = this.transportOut.getParameter("ws.outflow.dispatch.sequence");
                if (dispatchParam != null) {
                    dispatchSequence = dispatchParam.getParameterElement().getText();
                }
                if ((errorParam = this.transportOut.getParameter("ws.outflow.dispatch.fault.sequence")) != null) {
                    dispatchErrorSequence = errorParam.getParameterElement().getText();
                }
            }
            DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders();
            if (headers.size() > 0) {
                for (Map.Entry entry : headers.entrySet()) {
                    defaultHttpHeaders.add((String)entry.getKey(), entry.getValue());
                }
            }
            NioEventLoopGroup group = new NioEventLoopGroup();
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.deriveSubprotocol(wsSubprotocol, contentType), (boolean)false, (HttpHeaders)defaultHttpHeaders));
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), new WebSocketFrameAggregator(Integer.MAX_VALUE), handler});
                }
            });
            Channel ch = bootstrap.connect(uri.getHost(), port).sync().channel();
            ch.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener((EventLoopGroup)group, sourceIdentifier, uri){
                final /* synthetic */ EventLoopGroup val$group;
                final /* synthetic */ String val$sourceIdentifier;
                final /* synthetic */ URI val$uri;
                {
                    this.val$group = eventLoopGroup;
                    this.val$sourceIdentifier = string;
                    this.val$uri = uRI;
                }

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    this.val$group.shutdownGracefully();
                    WebsocketConnectionFactory.this.removeChannelHandler(this.val$sourceIdentifier, WebsocketConnectionFactory.this.getClientHandlerIdentifier(this.val$uri));
                }
            });
            handler.setDispatchSequence(dispatchSequence);
            handler.setDispatchErrorSequence(dispatchErrorSequence);
            this.addChannelHandler(sourceIdentifier, this.getClientHandlerIdentifier(uri), handler);
            return handler;
        }
        catch (InterruptedException e) {
            log.error((Object)"Interruption occured while connecting to the remote WS endpoint", (Throwable)e);
        }
        catch (SSLException e) {
            log.error((Object)"Error occurred while building the SSL context fo WSS endpoint", (Throwable)e);
        }
        return null;
    }

    private String deriveSubprotocol(String wsSubprotocol, String contentType) {
        if (wsSubprotocol != null) {
            return wsSubprotocol;
        }
        return contentType != null ? SubprotocolBuilderUtil.contentTypeToSyanapeSubprotocol(contentType) : null;
    }

    private static void handleWssTrustStoreParameterError(String errorMsg) throws AxisFault {
        log.error((Object)errorMsg);
        throw new AxisFault(errorMsg);
    }

    public void addChannelHandler(String sourceIdentifier, String clientIdentifier, WebSocketClientHandler clientHandler) {
        ConcurrentHashMap<String, WebSocketClientHandler> handlerMap = this.channelHandlerPool.get(sourceIdentifier);
        if (handlerMap == null) {
            handlerMap = new ConcurrentHashMap();
            handlerMap.put(clientIdentifier, clientHandler);
            this.channelHandlerPool.put(sourceIdentifier, handlerMap);
        } else {
            handlerMap.put(clientIdentifier, clientHandler);
        }
    }

    public WebSocketClientHandler getChannelHandlerFromPool(String sourceIdentifier, String clientIdentifier) {
        ConcurrentHashMap<String, WebSocketClientHandler> handlerMap = this.channelHandlerPool.get(sourceIdentifier);
        if (handlerMap == null) {
            return null;
        }
        return handlerMap.get(clientIdentifier);
    }

    public void removeChannelHandler(String sourceIdentifier, String clientIdentifier) {
        ConcurrentHashMap<String, WebSocketClientHandler> handlerMap = this.channelHandlerPool.get(sourceIdentifier);
        handlerMap.remove(clientIdentifier);
    }
}

