/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.inbound.InboundResponseSender;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.websocket.transport.SubprotocolBuilderUtil;
import org.wso2.carbon.websocket.transport.service.ServiceReferenceHolder;
import org.wso2.carbon.websocket.transport.utils.LogUtil;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;
    private static final Log log = LogFactory.getLog(WebSocketClientHandler.class);
    private String dispatchSequence;
    private String dispatchErrorSequence;
    private ChannelHandlerContext ctx;
    private InboundResponseSender responseSender;
    private String tenantDomain;

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public void setDispatchSequence(String dispatchSequence) {
        this.dispatchSequence = dispatchSequence;
    }

    public void setDispatchErrorSequence(String dispatchErrorSequence) {
        this.dispatchErrorSequence = dispatchErrorSequence;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public void registerWebsocketResponseSender(InboundResponseSender responseSender) {
        this.responseSender = responseSender;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("WebSocket client disconnected on context id : " + ctx.channel().toString()));
        }
    }

    public void handleHandshake(ChannelHandlerContext ctx, FullHttpResponse msg) {
        if (!this.handshaker.isHandshakeComplete()) {
            if (log.isDebugEnabled()) {
                LogUtil.printHeaders(log, msg, ctx);
            }
            this.handshaker.finishHandshake(ctx.channel(), msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)("WebSocket client connected to remote WS endpoint on context id : " + ctx.channel().toString()));
            }
            this.handshakeFuture.setSuccess();
            return;
        }
    }

    public void acknowledgeHandshake() {
        try {
            if (this.handshaker.isHandshakeComplete() && this.responseSender != null) {
                org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
                synCtx.setProperty("websocket.target.handshake.present", (Object)true);
                synCtx.setProperty("websocket.target.handler.context", (Object)this.ctx);
                this.injectToSequence(synCtx, this.dispatchSequence, this.dispatchErrorSequence);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception occured while injecting websocket frames to the Synapse engine", (Throwable)e);
        }
    }

    public void handleTargetWebsocketChannelTermination(WebSocketFrame frame) throws AxisFault {
        this.handshaker.close(this.ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void handleWebsocketBinaryFrame(WebSocketFrame frame) throws AxisFault {
        org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
        synCtx.setProperty("websocket.binary.frame.present", (Object)true);
        synCtx.setProperty("websocket.binary.frame", (Object)frame);
        this.injectToSequence(synCtx, this.dispatchSequence, this.dispatchErrorSequence);
    }

    public void handlePassthroughTextFrame(WebSocketFrame frame) throws AxisFault {
        org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
        synCtx.setProperty("websocket.text.frame.present", (Object)true);
        synCtx.setProperty("websocket.text.frame", (Object)frame);
        this.injectToSequence(synCtx, this.dispatchSequence, this.dispatchErrorSequence);
    }

    public void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws AxisFault {
        block13: {
            try {
                if (log.isDebugEnabled()) {
                    LogUtil.printWebSocketFrame(log, frame, ctx, true);
                }
                if (this.handshaker.isHandshakeComplete()) {
                    if (frame instanceof CloseWebSocketFrame) {
                        this.handleTargetWebsocketChannelTermination(frame);
                        return;
                    }
                    if (frame instanceof BinaryWebSocketFrame && (this.handshaker.actualSubprotocol() == null || this.handshaker.actualSubprotocol() != null && !this.handshaker.actualSubprotocol().contains("synapse"))) {
                        this.handleWebsocketBinaryFrame(frame);
                        return;
                    }
                    if (frame instanceof TextWebSocketFrame && (this.handshaker.actualSubprotocol() == null || this.handshaker.actualSubprotocol() != null && !this.handshaker.actualSubprotocol().contains("synapse"))) {
                        this.handlePassthroughTextFrame(frame);
                        return;
                    }
                    if (!(frame instanceof TextWebSocketFrame) || this.handshaker.actualSubprotocol() == null || !this.handshaker.actualSubprotocol().contains("synapse")) break block13;
                    org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
                    String message = ((TextWebSocketFrame)frame).text();
                    String contentType = SubprotocolBuilderUtil.syanapeSubprotocolToContentType(this.handshaker.actualSubprotocol());
                    MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                    SOAPBuilder builder = null;
                    if (contentType == null) {
                        log.debug((Object)"No content type specified. Using SOAP builder.");
                        builder = new SOAPBuilder();
                    } else {
                        int index = contentType.indexOf(59);
                        String type = index > 0 ? contentType.substring(0, index) : contentType;
                        try {
                            builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                        }
                        catch (AxisFault axisFault) {
                            log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()));
                        }
                        if (builder == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                            }
                            builder = new SOAPBuilder();
                        }
                    }
                    OMElement documentElement = null;
                    AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(message.getBytes()));
                    documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
                    synCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                    this.injectToSequence(synCtx, this.dispatchSequence, this.dispatchErrorSequence);
                    break block13;
                }
                log.error((Object)"Handshake incomplete at target handler. Failed to inject websocket frames to Synapse engine");
            }
            catch (Exception e) {
                log.error((Object)"Exception occured while injecting websocket frames to the Synapse engine", (Throwable)e);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpResponse) {
            this.handleHandshake(ctx, (FullHttpResponse)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error((Object)"Error encountered while processing the response", cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }

    private org.apache.synapse.MessageContext getSynapseMessageContext(String tenantDomain) throws AxisFault {
        org.apache.synapse.MessageContext synCtx = WebSocketClientHandler.createSynapseMessageContext(tenantDomain);
        if (this.responseSender != null) {
            synCtx.setProperty("isInbound", (Object)true);
            synCtx.setProperty("inbound-response-worker", (Object)this.responseSender);
        }
        synCtx.setProperty("websocket.subscriber.path", (Object)this.handshaker.uri().toString());
        return synCtx;
    }

    private static org.apache.synapse.MessageContext createSynapseMessageContext(String tenantDomain) throws AxisFault {
        MessageContext axis2MsgCtx = WebSocketClientHandler.createAxis2MessageContext();
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MsgCtx.setServiceContext(svcCtx);
        axis2MsgCtx.setOperationContext(opCtx);
        if (!"carbon.super".equals(tenantDomain)) {
            ConfigurationContext tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)axis2MsgCtx.getConfigurationContext());
            axis2MsgCtx.setConfigurationContext(tenantConfigCtx);
            axis2MsgCtx.setProperty("tenantDomain", (Object)tenantDomain);
        } else {
            axis2MsgCtx.setProperty("tenantDomain", (Object)"carbon.super");
        }
        SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        axis2MsgCtx.setEnvelope(envelope);
        return MessageContextCreatorForAxis2.getSynapseMessageContext((MessageContext)axis2MsgCtx);
    }

    private static MessageContext createAxis2MessageContext() {
        MessageContext axis2MsgCtx = new MessageContext();
        axis2MsgCtx.setMessageID(UIDGenerator.generateURNString());
        axis2MsgCtx.setConfigurationContext(ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext());
        axis2MsgCtx.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        axis2MsgCtx.setServerSide(true);
        return axis2MsgCtx;
    }

    private void injectToSequence(org.apache.synapse.MessageContext synCtx, String dispatchSequence, String dispatchErrorSequence) {
        SequenceMediator injectingSequence = null;
        if (dispatchSequence != null) {
            injectingSequence = (SequenceMediator)synCtx.getSequence(dispatchSequence);
        }
        if (injectingSequence == null) {
            injectingSequence = (SequenceMediator)synCtx.getMainSequence();
        }
        SequenceMediator faultSequence = this.getFaultSequence(synCtx, dispatchErrorSequence);
        MediatorFaultHandler mediatorFaultHandler = new MediatorFaultHandler((Mediator)faultSequence);
        synCtx.pushFaultHandler((FaultHandler)mediatorFaultHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("injecting message to sequence : " + dispatchSequence));
        }
        synCtx.getEnvironment().injectMessage(synCtx, injectingSequence);
    }

    private SequenceMediator getFaultSequence(org.apache.synapse.MessageContext synCtx, String dispatchErrorSequence) {
        SequenceMediator faultSequence = null;
        if (dispatchErrorSequence != null) {
            faultSequence = (SequenceMediator)synCtx.getSequence(dispatchErrorSequence);
        }
        if (faultSequence == null) {
            faultSequence = (SequenceMediator)synCtx.getFaultSequence();
        }
        return faultSequence;
    }
}

