/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.websocket.transport;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubprotocolBuilderUtil {
    private static String SYNAPSE_SUBPROTOCOL_PREFIX = "synapse(";
    private static String SYNAPSE_SUBPROTOCOL_SUFFIX = ")";
    private static String SYNAPSE_CONTENT_TYPE = "contentType=";
    private static final Log log = LogFactory.getLog(SubprotocolBuilderUtil.class);

    public static String syanapeSubprotocolToContentType(String subprotocol) {
        Pattern pattern = Pattern.compile(SYNAPSE_SUBPROTOCOL_PREFIX + ".*" + SYNAPSE_SUBPROTOCOL_SUFFIX);
        if (pattern.matcher(subprotocol).matches()) {
            subprotocol = subprotocol.replace(SYNAPSE_SUBPROTOCOL_PREFIX + SYNAPSE_CONTENT_TYPE + "'", "").replace("'" + SYNAPSE_SUBPROTOCOL_SUFFIX, "");
            subprotocol = subprotocol.trim();
            return subprotocol;
        }
        return null;
    }

    public static String contentTypeToSyanapeSubprotocol(String contentType) {
        return SYNAPSE_SUBPROTOCOL_PREFIX + SYNAPSE_CONTENT_TYPE + "'" + contentType + "'" + SYNAPSE_SUBPROTOCOL_SUFFIX;
    }
}

