/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validations.oas;

import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.validation.GenericValidator;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validations.oas.RuleConfiguration;
import org.openapitools.codegen.validations.oas.SecuritySchemeWrapper;
import org.openapitools.codegen.validations.oas.ValidationConstants;

class OpenApiSecuritySchemeValidations
extends GenericValidator<SecuritySchemeWrapper> {
    OpenApiSecuritySchemeValidations(RuleConfiguration ruleConfiguration) {
        super(new ArrayList<ValidationRule>());
        if (ruleConfiguration.isEnableRecommendations() && ruleConfiguration.isEnableApacheNginxUnderscoreRecommendation()) {
            this.rules.add(ValidationRule.warn(ValidationConstants.ApacheNginxUnderscoreDescription, ValidationConstants.ApacheNginxUnderscoreFailureMessage, OpenApiSecuritySchemeValidations::apacheNginxHeaderCheck));
        }
    }

    private static ValidationRule.Result apacheNginxHeaderCheck(SecuritySchemeWrapper securitySchemeWrapper) {
        SecurityScheme securityScheme = securitySchemeWrapper.getSecurityScheme();
        if (securityScheme == null || securityScheme.getIn() != SecurityScheme.In.HEADER) {
            return ValidationRule.Pass.empty();
        }
        ValidationRule.Result result = ValidationRule.Pass.empty();
        String key = securityScheme.getName();
        if (StringUtils.contains((CharSequence)key, (int)95)) {
            result = new ValidationRule.Fail();
            result.setDetails(String.format(Locale.ROOT, "%s contains an underscore.", key));
        }
        return result;
    }
}

