/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openapitools.codegen.validation.Invalid;
import org.openapitools.codegen.validation.Severity;
import org.openapitools.codegen.validation.Valid;
import org.openapitools.codegen.validation.Validated;
import org.openapitools.codegen.validation.ValidationRule;

public final class ValidationResult {
    private final List<Validated> validations;

    private ValidationResult(List<Validated> validations) {
        this.validations = Collections.synchronizedList(validations);
    }

    public ValidationResult() {
        this(new ArrayList<Validated>());
    }

    public List<Validated> getAll() {
        return this.validations;
    }

    public List<Valid> getValid() {
        return this.validations.stream().filter(Validated::isValid).map(it -> (Valid)it).collect(Collectors.toList());
    }

    public List<Invalid> getErrors() {
        return this.validations.stream().filter(it -> !it.isValid()).map(it -> (Invalid)it).filter(it -> it.getSeverity().equals((Object)Severity.ERROR)).collect(Collectors.toList());
    }

    public List<Invalid> getWarnings() {
        return this.validations.stream().filter(it -> !it.isValid()).map(it -> (Invalid)it).filter(it -> it.getSeverity().equals((Object)Severity.WARNING)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(Validated validated) {
        List<Validated> list = this.validations;
        synchronized (list) {
            ValidationRule rule = validated.getRule();
            if (rule != null && !rule.equals(ValidationRule.empty()) && !this.validations.contains(validated)) {
                this.validations.add(validated);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult consume(ValidationResult other) {
        List<Validated> list = this.validations;
        synchronized (list) {
            this.validations.addAll(other.validations);
        }
        return this;
    }
}

