/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.meta;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.meta.features.annotations.AnnotationType;

public class FeatureSet {
    public static FeatureSet UNSPECIFIED = FeatureSet.newBuilder().build();
    private EnumSet<ClientModificationFeature> clientModificationFeatures;
    private EnumSet<DataTypeFeature> dataTypeFeatures;
    private EnumSet<DocumentationFeature> documentationFeatures;
    private EnumSet<GlobalFeature> globalFeatures;
    private EnumSet<SchemaSupportFeature> schemaSupportFeatures;
    private EnumSet<ParameterFeature> parameterFeatures;
    private EnumSet<SecurityFeature> securityFeatures;
    private EnumSet<WireFormatFeature> wireFormatFeatures;

    private FeatureSet(Builder builder) {
        if (builder != null) {
            this.clientModificationFeatures = builder.clientModificationFeatures;
            this.dataTypeFeatures = builder.dataTypeFeatures;
            this.documentationFeatures = builder.documentationFeatures;
            this.schemaSupportFeatures = builder.schemaSupportFeatures;
            this.globalFeatures = builder.globalFeatures;
            this.parameterFeatures = builder.parameterFeatures;
            this.securityFeatures = builder.securityFeatures;
            this.wireFormatFeatures = builder.wireFormatFeatures;
        }
    }

    public Builder modify() {
        return FeatureSet.newBuilder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(FeatureSet copy) {
        Builder builder = new Builder();
        if (copy != null) {
            builder.clientModificationFeatures = copy.getClientModificationFeatures();
            builder.dataTypeFeatures = copy.getDataTypeFeatures();
            builder.documentationFeatures = copy.getDocumentationFeatures();
            builder.schemaSupportFeatures = copy.getSchemaSupportFeatures();
            builder.globalFeatures = copy.getGlobalFeatures();
            builder.parameterFeatures = copy.getParameterFeatures();
            builder.securityFeatures = copy.getSecurityFeatures();
            builder.wireFormatFeatures = copy.getWireFormatFeatures();
        }
        return builder;
    }

    public EnumSet<ClientModificationFeature> getClientModificationFeatures() {
        if (this.clientModificationFeatures != null) {
            return EnumSet.copyOf(this.clientModificationFeatures);
        }
        return EnumSet.noneOf(ClientModificationFeature.class);
    }

    public EnumSet<DataTypeFeature> getDataTypeFeatures() {
        if (this.dataTypeFeatures != null) {
            return EnumSet.copyOf(this.dataTypeFeatures);
        }
        return EnumSet.noneOf(DataTypeFeature.class);
    }

    public EnumSet<DocumentationFeature> getDocumentationFeatures() {
        if (this.documentationFeatures != null) {
            return EnumSet.copyOf(this.documentationFeatures);
        }
        return EnumSet.noneOf(DocumentationFeature.class);
    }

    public EnumSet<SchemaSupportFeature> getSchemaSupportFeatures() {
        if (this.schemaSupportFeatures != null) {
            return EnumSet.copyOf(this.schemaSupportFeatures);
        }
        return EnumSet.noneOf(SchemaSupportFeature.class);
    }

    public EnumSet<GlobalFeature> getGlobalFeatures() {
        if (this.globalFeatures != null) {
            return EnumSet.copyOf(this.globalFeatures);
        }
        return EnumSet.noneOf(GlobalFeature.class);
    }

    public EnumSet<ParameterFeature> getParameterFeatures() {
        if (this.parameterFeatures != null) {
            return EnumSet.copyOf(this.parameterFeatures);
        }
        return EnumSet.noneOf(ParameterFeature.class);
    }

    public EnumSet<SecurityFeature> getSecurityFeatures() {
        if (this.securityFeatures != null) {
            return EnumSet.copyOf(this.securityFeatures);
        }
        return EnumSet.noneOf(SecurityFeature.class);
    }

    public EnumSet<WireFormatFeature> getWireFormatFeatures() {
        if (this.wireFormatFeatures != null) {
            return EnumSet.copyOf(this.wireFormatFeatures);
        }
        return EnumSet.noneOf(WireFormatFeature.class);
    }

    public List<FeatureSetFlattened> flatten() {
        ArrayList<FeatureSetFlattened> states = new ArrayList<FeatureSetFlattened>();
        EnumSet.allOf(ClientModificationFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = ClientModificationFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.clientModificationFeatures.contains(feat);
            try {
                for (Annotation an : ClientModificationFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(DataTypeFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = DataTypeFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.dataTypeFeatures.contains(feat);
            try {
                for (Annotation an : DataTypeFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(DocumentationFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = DocumentationFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.documentationFeatures.contains(feat);
            try {
                for (Annotation an : DocumentationFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(SchemaSupportFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = SchemaSupportFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.schemaSupportFeatures.contains(feat);
            try {
                for (Annotation an : SchemaSupportFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(GlobalFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = GlobalFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.globalFeatures.contains(feat);
            try {
                for (Annotation an : GlobalFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(ParameterFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = ParameterFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.parameterFeatures.contains(feat);
            try {
                for (Annotation an : ParameterFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(SecurityFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = SecurityFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.securityFeatures.contains(feat);
            try {
                for (Annotation an : SecurityFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        EnumSet.allOf(WireFormatFeature.class).forEach(feat -> {
            FeatureSetFlattened state = new FeatureSetFlattened();
            state.featureCategory = WireFormatFeature.class.getSimpleName();
            state.featureName = feat.name();
            state.isSupported = this.wireFormatFeatures.contains(feat);
            try {
                for (Annotation an : WireFormatFeature.class.getField(feat.name()).getAnnotations()) {
                    state.source.add(AnnotationType.fromAnnotation(an.annotationType()));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            states.add(state);
        });
        return states;
    }

    public static final class Builder {
        private EnumSet<ClientModificationFeature> clientModificationFeatures = EnumSet.noneOf(ClientModificationFeature.class);
        private EnumSet<DataTypeFeature> dataTypeFeatures = EnumSet.noneOf(DataTypeFeature.class);
        private EnumSet<DocumentationFeature> documentationFeatures = EnumSet.noneOf(DocumentationFeature.class);
        private EnumSet<SchemaSupportFeature> schemaSupportFeatures = EnumSet.noneOf(SchemaSupportFeature.class);
        private EnumSet<GlobalFeature> globalFeatures;
        private EnumSet<ParameterFeature> parameterFeatures = EnumSet.noneOf(ParameterFeature.class);
        private EnumSet<SecurityFeature> securityFeatures = EnumSet.noneOf(SecurityFeature.class);
        private EnumSet<WireFormatFeature> wireFormatFeatures;

        private Builder() {
            this.globalFeatures = EnumSet.noneOf(GlobalFeature.class);
            this.wireFormatFeatures = EnumSet.noneOf(WireFormatFeature.class);
        }

        public Builder clientModificationFeatures(EnumSet<ClientModificationFeature> clientModificationFeatures) {
            this.clientModificationFeatures = clientModificationFeatures != null ? clientModificationFeatures : EnumSet.noneOf(ClientModificationFeature.class);
            return this;
        }

        public Builder includeClientModificationFeatures(ClientModificationFeature ... clientModificationFeature) {
            this.clientModificationFeatures.addAll(Arrays.stream(clientModificationFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeClientModificationFeatures(ClientModificationFeature ... clientModificationFeature) {
            this.clientModificationFeatures.removeAll(Arrays.stream(clientModificationFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder dataTypeFeatures(EnumSet<DataTypeFeature> dataTypeFeatures) {
            this.dataTypeFeatures = dataTypeFeatures != null ? dataTypeFeatures : EnumSet.noneOf(DataTypeFeature.class);
            return this;
        }

        public Builder includeDataTypeFeatures(DataTypeFeature ... dataTypeFeature) {
            this.dataTypeFeatures.addAll(Arrays.stream(dataTypeFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeDataTypeFeatures(DataTypeFeature ... dataTypeFeature) {
            this.dataTypeFeatures.removeAll(Arrays.stream(dataTypeFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder documentationFeatures(EnumSet<DocumentationFeature> documentationFeatures) {
            this.documentationFeatures = documentationFeatures != null ? documentationFeatures : EnumSet.noneOf(DocumentationFeature.class);
            return this;
        }

        public Builder includeDocumentationFeatures(DocumentationFeature ... documentationFeature) {
            this.documentationFeatures.addAll(Arrays.stream(documentationFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeDocumentationFeatures(DocumentationFeature ... documentationFeature) {
            this.documentationFeatures.removeAll(Arrays.stream(documentationFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder schemaSupportFeatures(EnumSet<SchemaSupportFeature> schemaSupportFeatures) {
            this.schemaSupportFeatures = schemaSupportFeatures != null ? schemaSupportFeatures : EnumSet.noneOf(SchemaSupportFeature.class);
            return this;
        }

        public Builder includeSchemaSupportFeatures(SchemaSupportFeature ... schemaSupportFeature) {
            this.schemaSupportFeatures.addAll(Arrays.stream(schemaSupportFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeSchemaSupportFeatures(SchemaSupportFeature ... schemaSupportFeature) {
            this.schemaSupportFeatures.removeAll(Arrays.stream(schemaSupportFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder parameterFeatures(EnumSet<ParameterFeature> parameterFeatures) {
            this.parameterFeatures = parameterFeatures != null ? parameterFeatures : EnumSet.noneOf(ParameterFeature.class);
            return this;
        }

        public Builder includeParameterFeatures(ParameterFeature ... parameterFeature) {
            this.parameterFeatures.addAll(Arrays.stream(parameterFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeParameterFeatures(ParameterFeature ... parameterFeature) {
            this.parameterFeatures.removeAll(Arrays.stream(parameterFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder securityFeatures(EnumSet<SecurityFeature> securityFeatures) {
            this.securityFeatures = securityFeatures != null ? securityFeatures : EnumSet.noneOf(SecurityFeature.class);
            return this;
        }

        public Builder includeSecurityFeatures(SecurityFeature ... securityFeature) {
            this.securityFeatures.addAll(Arrays.stream(securityFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeSecurityFeatures(SecurityFeature ... securityFeature) {
            this.securityFeatures.removeAll(Arrays.stream(securityFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder globalFeatures(EnumSet<GlobalFeature> globalFeatures) {
            this.globalFeatures = globalFeatures != null ? globalFeatures : EnumSet.noneOf(GlobalFeature.class);
            return this;
        }

        public Builder includeGlobalFeatures(GlobalFeature ... globalFeature) {
            this.globalFeatures.addAll(Arrays.stream(globalFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeGlobalFeatures(GlobalFeature ... globalFeature) {
            this.globalFeatures.removeAll(Arrays.stream(globalFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder wireFormatFeatures(EnumSet<WireFormatFeature> wireFormatFeatures) {
            this.wireFormatFeatures = wireFormatFeatures != null ? wireFormatFeatures : EnumSet.noneOf(WireFormatFeature.class);
            return this;
        }

        public Builder includeWireFormatFeatures(WireFormatFeature ... wireFormatFeature) {
            this.wireFormatFeatures.addAll(Arrays.stream(wireFormatFeature).collect(Collectors.toList()));
            return this;
        }

        public Builder excludeWireFormatFeatures(WireFormatFeature ... wireFormatFeature) {
            this.wireFormatFeatures.removeAll(Arrays.stream(wireFormatFeature).collect(Collectors.toList()));
            return this;
        }

        public FeatureSet build() {
            return new FeatureSet(this);
        }
    }

    public static class FeatureSetFlattened {
        String featureCategory;
        String featureName;
        boolean isSupported;
        List<AnnotationType> source = new ArrayList<AnnotationType>(3);

        public String getFeatureCategory() {
            return this.featureCategory;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        public List<AnnotationType> getSource() {
            return ImmutableList.copyOf(this.source);
        }
    }
}

