/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;

public class ScalatraServerCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-server";
    protected String artifactVersion = "1.0.0";

    public ScalatraServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(DocumentationFeature.Readme).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).excludeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism).excludeParameterFeatures(ParameterFeature.Cookie));
        this.outputFolder = "generated-code/scalatra";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scalatra";
        this.embeddedTemplateDir = "scalatra";
        this.invokerPackage = "org.openapitools";
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Set", "Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("number", "Double");
        this.additionalProperties.put("appName", "OpenAPI Sample");
        this.additionalProperties.put("appDescription", "A sample openapi server");
        this.additionalProperties.put("infoUrl", "http://org.openapitools");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("web.xml", "/src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("logback.xml", "/src/main/resources", "logback.xml"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("JettyMain.mustache", this.sourceFolder, "JettyMain.scala"));
        this.supportingFiles.add(new SupportingFile("Bootstrap.mustache", this.sourceFolder, "ScalatraBootstrap.scala"));
        this.supportingFiles.add(new SupportingFile("ServletApp.mustache", this.sourceFolder, "ServletApp.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("sbt", "", "sbt"));
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.importMapping.put("LocalDateTime", "org.joda.time.LocalDateTime");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.importMapping.put("LocalTime", "org.joda.time.LocalTime");
        this.importMapping.put("ListBuffer", "scala.collection.mutable.ListBuffer");
        this.importMapping.put("Set", "scala.collection.immutable.Set");
        this.importMapping.put("ListSet", "scala.collection.immutable.ListSet");
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "HashMap");
        this.instantiationTypes.put("set", "Set");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scalatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application with Scalatra.";
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            String[] items = op.path.split("/", -1);
            String scalaPath = "";
            int pathParamIndex = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i].matches("^\\{(.*)\\}$")) {
                    scalaPath = scalaPath + ":" + items[i].replace("{", "").replace("}", "");
                    ++pathParamIndex;
                } else {
                    scalaPath = scalaPath + items[i];
                }
                if (i == items.length - 1) continue;
                scalaPath = scalaPath + "/";
            }
            op.vendorExtensions.put("x-scalatra-path", scalaPath);
        }
        return objs;
    }
}

