/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.List;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.ScalaAkkaClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;

public class ScalaSttpClientCodegen
extends ScalaAkkaClientCodegen
implements CodegenConfig {
    public ScalaSttpClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder(this.generatorMetadata).stability(Stability.BETA).build();
        this.templateDir = "scala-sttp";
        this.embeddedTemplateDir = "scala-sttp";
        this.outputFolder = "generated-code/scala-sttp";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("mainPackage")) {
            this.setMainPackage((String)this.additionalProperties.get("mainPackage"));
            this.additionalProperties.replace("configKeyPath", this.configKeyPath);
            this.apiPackage = this.mainPackage + ".api";
            this.modelPackage = this.mainPackage + ".model";
            this.invokerPackage = this.mainPackage + ".core";
            this.additionalProperties.put("apiPackage", this.apiPackage);
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        String invokerFolder = (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("requests.mustache", invokerFolder, "requests.scala"));
        this.supportingFiles.add(new SupportingFile("apiInvoker.mustache", invokerFolder, "ApiInvoker.scala"));
        String apiFolder = (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("enumsSerializers.mustache", apiFolder, "EnumsSerializers.scala"));
        this.supportingFiles.add(new SupportingFile("serializers.mustache", invokerFolder, "Serializers.scala"));
    }

    @Override
    public String getName() {
        return "scala-sttp";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala client library (beta) based on Sttp.";
    }

    @Override
    public String encodePath(String input) {
        String result = super.encodePath(input);
        return result.replace("{", "${");
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.encodePath(path);
        return op;
    }
}

