/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustClientCodegen.class);
    public static final String PACKAGE_NAME = "packageName";
    public static final String PACKAGE_VERSION = "packageVersion";
    public static final String HYPER_LIBRARY = "hyper";
    public static final String REQWEST_LIBRARY = "reqwest";
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiFolder = "src/apis";
    protected String modelFolder = "src/models";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "rust";
    }

    @Override
    public String getHelp() {
        return "Generates a Rust client library (beta).";
    }

    public RustClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(DocumentationFeature.Readme).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).excludeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism).excludeParameterFeatures(ParameterFeature.Cookie).includeClientModificationFeatures(ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent));
        this.outputFolder = "generated-code/rust";
        this.modelTemplateFiles.put("model.mustache", ".rs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.templateDir = "rust";
        this.embeddedTemplateDir = "rust";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "alignof", "as", "become", "box", "break", "const", "continue", "crate", "do", "else", "enum", "extern", "false", "final", "fn", "for", "if", "impl", "in", "let", "loop", "macro", "match", "mod", "move", "mut", "offsetof", "override", "priv", "proc", "pub", "pure", "ref", "return", "Self", "self", "sizeof", "static", "struct", "super", "trait", "true", "type", "typeof", "unsafe", "unsized", "use", "virtual", "where", "while", "yield", "async", "await", "dyn", "try"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("i8", "i16", "i32", "i64", "u8", "u16", "u32", "u64", "f32", "f64", "char", "bool", "String", "Vec<u8>", "File"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "i32");
        this.typeMapping.put("long", "i64");
        this.typeMapping.put("number", "f32");
        this.typeMapping.put("float", "f32");
        this.typeMapping.put("double", "f64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "String");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("file", "std::path::PathBuf");
        this.typeMapping.put("binary", "crate::models::File");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("object", "serde_json::Value");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(PACKAGE_NAME, "Rust package name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption(PACKAGE_VERSION, "Rust package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.supportedLibraries.put(HYPER_LIBRARY, "HTTP client: Hyper.");
        this.supportedLibraries.put(REQWEST_LIBRARY, "HTTP client: Reqwest.");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use.");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(HYPER_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(HYPER_LIBRARY);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        OnceLogger.once(LOGGER).warn("4.3.0 has deprecated the use of vendor extensions which don't follow lower-kebab casing standards with x- prefix.");
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.discriminator == null) continue;
                ArrayList discriminatorVars = new ArrayList();
                for (CodegenDiscriminator.MappedModel mappedModel : cm.discriminator.getMappedModels()) {
                    CodegenModel model = (CodegenModel)allModels.get(mappedModel.getModelName());
                    HashMap<String, Object> mas = new HashMap<String, Object>();
                    mas.put("modelName", StringUtils.camelize(mappedModel.getModelName()));
                    mas.put("mappingName", mappedModel.getMappingName());
                    List<CodegenProperty> vars = model.getVars();
                    vars.removeIf(p -> p.name.equals(cm.discriminator.getPropertyName()));
                    mas.put("vars", vars);
                    discriminatorVars.add(mas);
                }
                String vendorExtensionTagName = cm.discriminator.getPropertyName().replace("_", "");
                cm.vendorExtensions.put("tagName", vendorExtensionTagName);
                cm.vendorExtensions.put("x-tag-name", vendorExtensionTagName);
                cm.vendorExtensions.put("mappedModels", discriminatorVars);
                cm.vendorExtensions.put("x-mapped-models", discriminatorVars);
            }
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(PACKAGE_NAME)) {
            this.setPackageName((String)this.additionalProperties.get(PACKAGE_NAME));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey(PACKAGE_VERSION)) {
            this.setPackageVersion((String)this.additionalProperties.get(PACKAGE_VERSION));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put(PACKAGE_NAME, this.packageName);
        this.additionalProperties.put(PACKAGE_VERSION, this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (HYPER_LIBRARY.equals(this.getLibrary())) {
            this.additionalProperties.put(HYPER_LIBRARY, "true");
        } else if (REQWEST_LIBRARY.equals(this.getLibrary())) {
            this.additionalProperties.put(REQWEST_LIBRARY, "true");
        } else {
            LOGGER.error("Unknown library option (-l/--library): {}", (Object)this.getLibrary());
        }
        this.apiTemplateFiles.put(this.getLibrary() + "/api.mustache", ".rs");
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("model_mod.mustache", this.modelFolder, "mod.rs"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", "src", "lib.rs"));
        this.supportingFiles.add(new SupportingFile("Cargo.mustache", "", "Cargo.toml"));
        if (HYPER_LIBRARY.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("request.rs", this.apiFolder, "request.rs"));
        }
        this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/configuration.mustache", this.apiFolder, "configuration.rs"));
        this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/client.mustache", this.apiFolder, "client.rs"));
        this.supportingFiles.add(new SupportingFile(this.getLibrary() + "/api_mod.mustache", this.apiFolder, "mod.rs"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return '_' + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.apiFolder).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.modelFolder).replace("/", File.separator);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.underscore(name))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "var_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModelFilename(name));
    }

    @Override
    public String toModelFilename(String name) {
        if (!Strings.isNullOrEmpty((String)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!Strings.isNullOrEmpty((String)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                LOGGER.warn(ap.getName() + "(array property) does not have a proper inner type defined.Default to string");
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return "Vec<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            if (inner == null) {
                LOGGER.warn(p.getName() + "(map property) does not have a proper inner type defined. Default to string");
                inner = new StringSchema().description("TODO default missing map inner type to string");
            }
            return "::std::collections::HashMap<String, " + this.getTypeDeclaration(inner) + ">";
        }
        String schemaType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return "crate::models::" + this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return StringUtils.underscore(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            if (HYPER_LIBRARY.equals(this.getLibrary())) {
                operation.httpMethod = StringUtils.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
                continue;
            }
            if (!REQWEST_LIBRARY.equals(this.getLibrary())) continue;
            operation.httpMethod = operation.httpMethod.toLowerCase(Locale.ROOT);
        }
        return objs;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "Minus");
            varName = varName.replaceAll("\\+", "Plus");
            varName = varName.replaceAll("\\.", "Dot");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name);
        }
        String enumName = this.sanitizeName(StringUtils.camelize(name));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.camelize(this.toModelName(property.name));
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        return null;
    }
}

