/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuaClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuaClientCodegen.class);
    protected String specFolder = "spec";
    protected String packageName = "openapiclient";
    protected String packageVersion = "1.0.0-1";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String luaRocksFilename = "openapiclient-1.0.0-1.rockspec";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "lua";
    }

    @Override
    public String getHelp() {
        return "Generates a Lua client library (beta).";
    }

    public LuaClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(DocumentationFeature.Readme).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).includeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism).includeParameterFeatures(ParameterFeature.Cookie));
        this.outputFolder = "generated-code/lua";
        this.modelTemplateFiles.put("model.mustache", ".lua");
        this.apiTemplateFiles.put("api.mustache", ".lua");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "lua";
        this.embeddedTemplateDir = "lua";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("nil", "string", "boolean", "number", "userdata", "thread", "table", "and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("nil", "string", "boolean", "number"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
        this.importMapping = new HashMap();
        this.importMapping.put("time.Time", "time");
        this.importMapping.put("*os.File", "os");
        this.importMapping.put("os", "io/ioutil");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Lua package name (convention: single word).").defaultValue("openapiclient"));
        this.cliOptions.add(new CliOption("packageVersion", "Lua package version.").defaultValue("1.0.0-1"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.setLuaRocksFilename(this.packageName + "-" + this.packageVersion + ".rockspec");
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.apiTestTemplateFiles.put("api_test.mustache", ".lua");
        this.modelTestTemplateFiles.put("model_test.mustache", ".lua");
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("luarocks.mustache", "", this.luaRocksFilename));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return StringUtils.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "api" + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "model" + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.underscore(name))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "Var" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        return StringUtils.underscore(super.toApiName(name));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getTypeDeclaration(inner);
        }
        String schemaType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return StringUtils.underscore(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation op : operations) {
            String[] items = op.path.split("/", -1);
            String luaPath = "";
            int pathParamIndex = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i].matches("^\\{(.*)\\}$")) {
                    luaPath = luaPath + "/%s";
                    ++pathParamIndex;
                    continue;
                }
                if (items[i].length() == 0) continue;
                luaPath = luaPath + "/" + items[i];
            }
            op.vendorExtensions.put("x-codegen-path", luaPath);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setLuaRocksFilename(String luaRocksFilename) {
        this.luaRocksFilename = luaRocksFilename;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("]]", "] ]");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(this.toModelName(name))) {
            return this.toModelName(name);
        }
        return name;
    }
}

