/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.EnumSet;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinVertxServerCodegen
extends AbstractKotlinCodegen {
    protected String rootPackage = "org.openapitools.server.api";
    protected String apiVersion = "1.0.0-SNAPSHOT";
    public static final String ROOT_PACKAGE = "rootPackage";
    public static final String PROJECT_NAME = "projectName";
    static Logger LOGGER = LoggerFactory.getLogger(KotlinVertxServerCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "kotlin-vertx";
    }

    @Override
    public String getHelp() {
        return "Generates a kotlin-vertx server.";
    }

    public KotlinVertxServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(DocumentationFeature.Readme).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).excludeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism).includeParameterFeatures(ParameterFeature.Cookie));
        this.generatorMetadata = GeneratorMetadata.newBuilder(this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "kotlin-vertx";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.supportingFiles.clear();
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.apiTemplateFiles.put("apiProxy.mustache", "VertxProxyHandler.kt");
        this.apiTemplateFiles.put("api_verticle.mustache", "Verticle.kt");
        this.templateDir = "kotlin-vertx-server";
        this.embeddedTemplateDir = "kotlin-vertx-server";
        this.apiPackage = this.rootPackage + ".verticle";
        this.modelPackage = this.rootPackage + ".model";
        this.artifactId = "openapi-kotlin-vertx-server";
        this.artifactVersion = this.apiVersion;
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.additionalProperties.put(ROOT_PACKAGE, this.rootPackage);
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }
}

