/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.EnumSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.languages.AbstractGraphQLCodegen;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaCodegen
extends AbstractGraphQLCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLSchemaCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.CONFIG;
    }

    @Override
    public String getName() {
        return "graphql-schema";
    }

    @Override
    public String getHelp() {
        return "Generates GraphQL schema files (beta)";
    }

    public GraphQLSchemaCodegen() {
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).excludeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism));
        this.outputFolder = "generated-code/graphql-schema";
        this.modelTemplateFiles.put("model.mustache", ".graphql");
        this.apiTemplateFiles.put("api.mustache", ".graphql");
        this.templateDir = "graphql-schema";
        this.embeddedTemplateDir = "graphql-schema";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "GraphQL package name (convention: lowercase).").defaultValue("openapi2graphql"));
        this.cliOptions.add(new CliOption("packageVersion", "GraphQL package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
    }
}

