/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErlangServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErlangServerCodegen.class);
    protected String apiVersion = "1.0.0";
    protected String apiPath = "src";
    protected String packageName = "openapi";
    protected String openApiSpecName = "openapi";

    public ErlangServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(DocumentationFeature.Readme).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling).excludeSchemaSupportFeatures(SchemaSupportFeature.Polymorphism).excludeParameterFeatures(ParameterFeature.Cookie));
        this.outputFolder = "generated-code/erlang-server";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("handler.mustache", ".erl");
        this.templateDir = "erlang-server";
        this.embeddedTemplateDir = "erlang-server";
        this.setReservedWordsLowerCase(Arrays.asList("after", "and", "andalso", "band", "begin", "bnot", "bor", "bsl", "bsr", "bxor", "case", "catch", "cond", "div", "end", "fun", "if", "let", "not", "of", "or", "orelse", "receive", "rem", "try", "when", "xor"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("enum", "binary");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("datetime", "datetime");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "binary");
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("int", "integer");
        this.typeMapping.put("float", "integer");
        this.typeMapping.put("long", "integer");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("number", "integer");
        this.typeMapping.put("bigdecimal", "float");
        this.typeMapping.put("List", "list");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("binary", "binary");
        this.typeMapping.put("bytearray", "binary");
        this.typeMapping.put("byte", "binary");
        this.typeMapping.put("uuid", "binary");
        this.typeMapping.put("uri", "binary");
        this.typeMapping.put("password", "binary");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Erlang package name (convention: lowercase).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("openAPISpecName", "Openapi Spec Name.").defaultValue(this.openApiSpecName));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("openAPISpecName")) {
            this.setOpenApiSpecName((String)this.additionalProperties.get("openAPISpecName"));
        } else {
            this.additionalProperties.put("openAPISpecName", this.openApiSpecName);
        }
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.supportingFiles.add(new SupportingFile("rebar.config.mustache", "", "rebar.config"));
        this.supportingFiles.add(new SupportingFile("app.src.mustache", "", "src" + File.separator + this.packageName + ".app.src"));
        this.supportingFiles.add(new SupportingFile("router.mustache", "", this.toSourceFilePath("router", "erl")));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", this.toSourceFilePath("api", "erl")));
        this.supportingFiles.add(new SupportingFile("server.mustache", "", this.toSourceFilePath("server", "erl")));
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", this.toSourceFilePath("utils", "erl")));
        this.supportingFiles.add(new SupportingFile("auth.mustache", "", this.toSourceFilePath("auth", "erl")));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "", this.toPrivFilePath(this.openApiSpecName, "json")));
        this.supportingFiles.add(new SupportingFile("default_logic_handler.mustache", "", this.toSourceFilePath("default_logic_handler", "erl")));
        this.supportingFiles.add(new SupportingFile("logic_handler.mustache", "", this.toSourceFilePath("logic_handler", "erl")));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "erlang-server";
    }

    @Override
    public String getHelp() {
        return "Generates an Erlang server library (beta) using OpenAPI Generator (https://openapi-generator.tech). By default, it will also generate service classes, which can be disabled with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return this.packageName + "_default_handler";
        }
        return this.packageName + "_" + StringUtils.underscore(name) + "_handler";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModelFilename(name));
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(operationId);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toHandlerName(name);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            if (op.path == null) continue;
            op.path = op.path.replaceAll("\\{(.*?)\\}", ":$1");
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOpenApiSpecName(String openApiSpecName) {
        this.openApiSpecName = openApiSpecName;
    }

    protected String toHandlerName(String name) {
        return this.toModuleName(name) + "_handler";
    }

    protected String toModuleName(String name) {
        return this.packageName + "_" + StringUtils.underscore(name.replaceAll("-", "_"));
    }

    protected String toSourceFilePath(String name, String extension) {
        return "src" + File.separator + this.toModuleName(name) + "." + extension;
    }

    protected String toIncludeFilePath(String name, String extension) {
        return "include" + File.separator + this.toModuleName(name) + "." + extension;
    }

    protected String toPrivFilePath(String name, String extension) {
        return "priv" + File.separator + name + "." + extension;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("-ifdef", "- if def").replace("-endif", "- end if");
    }
}

