/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.api.TemplatingGenerator;

public interface TemplatingEngineAdapter {
    public String getIdentifier();

    public String compileTemplate(TemplatingGenerator var1, Map<String, Object> var2, String var3) throws IOException;

    public String[] getFileExtensions();

    default public boolean templateExists(TemplatingGenerator generator, String templateFile) {
        return Arrays.stream(this.getFileExtensions()).anyMatch(ext -> {
            int idx = templateFile.lastIndexOf(".");
            String baseName = idx > 0 && idx < templateFile.length() - 1 ? templateFile.substring(0, idx) : templateFile;
            Path path = generator.getFullTemplatePath(String.format(Locale.ROOT, "%s.%s", baseName, ext));
            InputStream is = null;
            try {
                String resourcePath = System.getProperty("os.name").startsWith("Windows") ? path.toString().replace("\\", "/") : path.toString();
                is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
                if (is == null) {
                    is = new FileInputStream(path.toFile());
                }
                boolean bl = is.available() > 0;
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return false;
        });
    }
}

