/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.kafka.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.kafka.KafkaEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.kafka.internal.ds.KafkaEventAdapterServiceHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="input.Kafka.EventAdaptorService.component", immediate=true)
public class KafkaEventAdapterServiceDS {
    private static final Log log = LogFactory.getLog(KafkaEventAdapterServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            KafkaEventAdapterFactory kafkaEventEventAdapterFactory = new KafkaEventAdapterFactory();
            context.getBundleContext().registerService(InputEventAdapterFactory.class.getName(), (Object)kafkaEventEventAdapterFactory, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the input Kafka adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the input Kafka adapter service ", (Throwable)e);
        }
    }

    @Reference(name="configurationcontext.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        KafkaEventAdapterServiceHolder.registerConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        KafkaEventAdapterServiceHolder.unregisterConfigurationContextService(configurationContextService);
    }
}

