/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.kafka.KafkaEventAdapter;

public class KafkaEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.kafka.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "kafka";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property webZKConnect = new Property("zookeeper.connect");
        webZKConnect.setDisplayName(this.resourceBundle.getString("zookeeper.connect"));
        webZKConnect.setHint(this.resourceBundle.getString("zookeeper.id.hint"));
        webZKConnect.setRequired(true);
        propertyList.add(webZKConnect);
        Property webGroupID = new Property("group.id");
        webGroupID.setDisplayName(this.resourceBundle.getString("group.id"));
        webGroupID.setHint(this.resourceBundle.getString("group.id.hint"));
        webGroupID.setRequired(true);
        propertyList.add(webGroupID);
        Property webThreads = new Property("threads");
        webThreads.setDisplayName(this.resourceBundle.getString("threads"));
        webThreads.setHint(this.resourceBundle.getString("threads.hint"));
        webThreads.setRequired(true);
        propertyList.add(webThreads);
        Property optionConfigProperties = new Property("optional.configuration");
        optionConfigProperties.setDisplayName(this.resourceBundle.getString("optional.configuration"));
        optionConfigProperties.setHint(this.resourceBundle.getString("optional.configuration.hint"));
        propertyList.add(optionConfigProperties);
        Property webTopic = new Property("topic");
        webTopic.setDisplayName(this.resourceBundle.getString("topic"));
        webTopic.setRequired(true);
        propertyList.add(webTopic);
        Property isDuplicatedInCluster = new Property("events.duplicated.in.cluster");
        isDuplicatedInCluster.setDisplayName(this.resourceBundle.getString("events.duplicated.in.cluster"));
        isDuplicatedInCluster.setRequired(false);
        isDuplicatedInCluster.setOptions(new String[]{"true", "false"});
        isDuplicatedInCluster.setDefaultValue("false");
        propertyList.add(isDuplicatedInCluster);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new KafkaEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

