/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.consumer.ConsumerConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.kafka.ConsumerKafkaAdaptor;

public final class KafkaEventAdapter
implements InputEventAdapter {
    private static final Log log = LogFactory.getLog(KafkaEventAdapter.class);
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdaptorListener;
    private final String id = UUID.randomUUID().toString();
    private int tenantId;
    private ConsumerKafkaAdaptor consumerKafkaAdaptor;

    public KafkaEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.validateInputEventAdapterConfigurations();
        this.eventAdaptorListener = eventAdaptorListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
        this.createKafkaAdaptorListener(this.eventAdaptorListener, this.eventAdapterConfiguration);
    }

    public void disconnect() {
        if (this.consumerKafkaAdaptor != null) {
            this.consumerKafkaAdaptor.shutdown();
            String topic = (String)this.eventAdapterConfiguration.getProperties().get("topic");
            log.debug((Object)("Adapter " + this.eventAdapterConfiguration.getName() + " disconnected " + topic));
        }
    }

    public void destroy() {
    }

    public InputEventAdapterListener getEventAdaptorListener() {
        return this.eventAdaptorListener;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static ConsumerConfig createConsumerConfig(String zookeeper, String groupId, String optionalConfigs) {
        try {
            String[] optionalProperties;
            Properties props = new Properties();
            props.put("zookeeper.connect", zookeeper);
            props.put("group.id", groupId);
            if (optionalConfigs != null && (optionalProperties = optionalConfigs.split(",")) != null) {
                for (String header : optionalProperties) {
                    String[] configPropertyWithValue = header.split(":", 2);
                    if (configPropertyWithValue.length == 2) {
                        props.put(configPropertyWithValue[0], configPropertyWithValue[1]);
                        continue;
                    }
                    log.warn((Object)("Optional configuration property not defined in the correct format.\nRequired - property_name1:property_value1,property_name2:property_value2\nFound - " + optionalConfigs));
                }
            }
            return new ConsumerConfig(props);
        }
        catch (NoClassDefFoundError e) {
            throw new InputEventAdapterRuntimeException("Cannot access kafka context due to missing jars", (Throwable)e);
        }
    }

    private void createKafkaAdaptorListener(InputEventAdapterListener inputEventAdapterListener, InputEventAdapterConfiguration inputEventAdapterConfiguration) {
        HashMap brokerProperties = new HashMap();
        brokerProperties.putAll(inputEventAdapterConfiguration.getProperties());
        String zkConnect = (String)brokerProperties.get("zookeeper.connect");
        String groupID = (String)brokerProperties.get("group.id");
        String threadsStr = (String)brokerProperties.get("threads");
        String optionalConfiguration = (String)brokerProperties.get("optional.configuration");
        int threads = Integer.parseInt(threadsStr);
        String topic = (String)inputEventAdapterConfiguration.getProperties().get("topic");
        this.consumerKafkaAdaptor = new ConsumerKafkaAdaptor(topic, this.tenantId, KafkaEventAdapter.createConsumerConfig(zkConnect, groupID, optionalConfiguration));
        this.consumerKafkaAdaptor.run(threads, inputEventAdapterListener);
    }

    public boolean isEventDuplicatedInCluster() {
        return Boolean.parseBoolean((String)this.eventAdapterConfiguration.getProperties().get("events.duplicated.in.cluster"));
    }

    public boolean isPolling() {
        return true;
    }

    private void validateInputEventAdapterConfigurations() throws InputEventAdapterException {
        String threadsProperty = (String)this.eventAdapterConfiguration.getProperties().get("threads");
        try {
            Integer.parseInt(threadsProperty);
        }
        catch (NumberFormatException e) {
            throw new InputEventAdapterException("Invalid value set for property 'Threads': " + threadsProperty, (Throwable)e);
        }
    }
}

