/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.kafka;

import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;

public class KafkaConsumer
implements Runnable {
    private KafkaStream stream;
    private InputEventAdapterListener brokerListener;
    private String event;
    private int tenantId;
    private Log log = LogFactory.getLog(KafkaConsumer.class);

    public KafkaConsumer(KafkaStream inStream, InputEventAdapterListener inBrokerListener, int inTenantId) {
        this.stream = inStream;
        this.brokerListener = inBrokerListener;
        this.tenantId = inTenantId;
    }

    @Override
    public void run() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            ConsumerIterator it = this.stream.iterator();
            while (it.hasNext()) {
                try {
                    this.event = new String((byte[])it.next().message());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Event received in Kafka Event Adaptor - " + this.event));
                    }
                    this.brokerListener.onEvent((Object)this.event);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Error while transforming the event : " + this.event), t);
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error while consuming event ", t);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

