/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.kafka;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.kafka.KafkaConsumer;

public class ConsumerKafkaAdaptor {
    private final ConsumerConnector consumer;
    private final String topic;
    private ExecutorService executor;
    private Log log = LogFactory.getLog(ConsumerKafkaAdaptor.class);
    private int tenantId;

    public ConsumerKafkaAdaptor(String inTopic, int tenantId, ConsumerConfig conf) {
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)conf);
        this.topic = inTopic;
        this.tenantId = tenantId;
    }

    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void run(int numThreads, InputEventAdapterListener brokerListener) {
        try {
            HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
            topicCountMap.put(this.topic, numThreads);
            Map consumerMap = this.consumer.createMessageStreams(topicCountMap);
            List streams = (List)consumerMap.get(this.topic);
            this.executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("Thread pool- component - ConsumerKafkaAdaptor.executor").build());
            for (KafkaStream stream : streams) {
                this.executor.submit(new KafkaConsumer(stream, brokerListener, this.tenantId));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error while creating KafkaConsumer ", t);
        }
    }
}

