/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.services;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.event.EventDistributionTask;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.bean.IdentityEventMessageContext;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.internal.IdentityEventServiceComponent;
import org.wso2.carbon.identity.event.services.IdentityEventService;

public class IdentityEventServiceImpl
implements IdentityEventService {
    private static final Log log = LogFactory.getLog(IdentityEventServiceImpl.class);
    private EventDistributionTask eventDistributionTask;

    public IdentityEventServiceImpl(List<AbstractEventHandler> handlerList, int threadPoolSize) {
        this.eventDistributionTask = new EventDistributionTask(handlerList, threadPoolSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting event distribution task from Notification Management component");
        }
        new Thread(this.eventDistributionTask).start();
    }

    @Override
    public void handleEvent(Event event) throws IdentityEventException {
        List<AbstractEventHandler> eventHandlerList = IdentityEventServiceComponent.eventHandlerList;
        IdentityEventMessageContext eventContext = new IdentityEventMessageContext(event);
        for (AbstractEventHandler handler : eventHandlerList) {
            if (!handler.canHandle(eventContext)) continue;
            if (handler.isAssociationAsync(event.getEventName())) {
                this.eventDistributionTask.addEventToQueue(event);
                continue;
            }
            handler.handleEvent(event);
        }
    }
}

