/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.handler.MessageHandlerComparator;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.event.IdentityEventConfigBuilder;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.internal.IdentityEventServiceDataHolder;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.event.services.IdentityEventServiceImpl;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.event.service", immediate=true)
public class IdentityEventServiceComponent {
    private static Log log = LogFactory.getLog(IdentityEventServiceComponent.class);
    private static RealmService realmService;
    private ServiceRegistration serviceRegistration = null;
    public static List<AbstractEventHandler> eventHandlerList;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            IdentityEventServiceDataHolder.getInstance().setEventMgtService(new IdentityEventServiceImpl(eventHandlerList, Integer.parseInt(IdentityEventConfigBuilder.getInstance().getThreadPoolSize())));
            context.getBundleContext().registerService(IdentityEventService.class.getName(), (Object)IdentityEventServiceDataHolder.getInstance().getEventMgtService(), null);
        }
        catch (IdentityEventException e) {
            log.error((Object)"Error while initiating IdentityMgtService.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management Listener is enabled");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management bundle is de-activated");
        }
    }

    @Reference(name="event.handler", service=AbstractEventHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterEventHandler")
    protected void registerEventHandler(AbstractEventHandler eventHandler) {
        String handlerName = eventHandler.getName();
        try {
            eventHandler.init(IdentityEventConfigBuilder.getInstance().getModuleConfigurations(handlerName));
        }
        catch (IdentityRuntimeException | IdentityEventException e) {
            log.warn((Object)("Properties for " + handlerName + " is not configured. This event handler will not be activated"));
        }
        eventHandlerList.add(eventHandler);
        MessageHandlerComparator messageHandlerComparator = new MessageHandlerComparator(null);
        Collections.sort(eventHandlerList, messageHandlerComparator);
    }

    protected void unRegisterEventHandler(AbstractEventHandler eventHandler) {
    }

    @Reference(name="listener.TenantMgtListener", service=TenantMgtListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterTenantMgtListener")
    protected void registerTenantMgtListener(TenantMgtListener tenantMgtListener) {
    }

    protected void unRegisterTenantMgtListener(TenantMgtListener tenantMgtListener) {
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        IdentityEventServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Realm Service");
        }
        IdentityEventServiceComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdpManager(IdpManager idpManager) {
        IdentityEventServiceDataHolder.getInstance().setIdpManager(null);
    }

    @Reference(name="IdentityProviderManager", service=IdpManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdpManager")
    protected void setIdpManager(IdpManager idpManager) {
        IdentityEventServiceDataHolder.getInstance().setIdpManager(idpManager);
    }

    static {
        eventHandlerList = new ArrayList<AbstractEventHandler>();
    }
}

