/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.bean.IdentityEventMessageContext;
import org.wso2.carbon.identity.event.bean.ModuleConfiguration;
import org.wso2.carbon.identity.event.bean.Subscription;
import org.wso2.carbon.identity.event.event.Event;

public abstract class AbstractEventHandler
extends AbstractIdentityMessageHandler {
    protected ModuleConfiguration configs;
    private static final Log log = LogFactory.getLog(AbstractEventHandler.class);

    public boolean canHandle(MessageContext messageContext) throws IdentityRuntimeException {
        Event event = ((IdentityEventMessageContext)messageContext).getEvent();
        String eventName = event.getEventName();
        List<Subscription> subscriptionList = null;
        if (this.configs == null) {
            return false;
        }
        subscriptionList = this.configs.getSubscriptions();
        if (subscriptionList != null) {
            for (Subscription subscription : subscriptionList) {
                if (!subscription.getSubscriptionName().equals(eventName)) continue;
                return true;
            }
        }
        return false;
    }

    public Properties getSubscriptionProperties(String eventName) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get the subscription properties for event : " + eventName));
        }
        Properties subscriptionProperties = new Properties();
        List<Subscription> subscriptions = this.configs.getSubscriptions();
        for (Subscription sub : subscriptions) {
            if (!sub.getSubscriptionName().equals(eventName)) continue;
            subscriptionProperties = sub.getSubscriptionProperties();
            break;
        }
        if (log.isDebugEnabled() && subscriptionProperties != null) {
            log.debug((Object)("List of subscription properties for event : " + eventName));
            for (Object key : subscriptionProperties.keySet()) {
                log.debug((Object)("Key : " + key + " Value : " + subscriptionProperties.getProperty((String)key)));
            }
        }
        return subscriptionProperties;
    }

    public String getSubscriptionProperty(String propertyName, String eventName) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get the subscription property value for property : " + propertyName + " for event : " + eventName));
        }
        return this.getSubscriptionProperties(eventName).getProperty(this.getName() + ".subscription." + eventName + "." + propertyName);
    }

    public boolean isAssociationAsync(String eventName) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validate the association is sync or not.");
        }
        return Boolean.parseBoolean(this.getSubscriptionProperty("operationAsync", eventName));
    }

    public abstract void handleEvent(Event var1) throws IdentityEventException;

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        if (!(configuration instanceof ModuleConfiguration)) {
            throw new IdentityRuntimeException("Initial configuration error");
        }
        this.configs = (ModuleConfiguration)configuration;
    }
}

