/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event;

import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.bean.IdentityEventMessageContext;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.internal.IdentityEventServiceDataHolder;

public class EventDistributionTask
implements Runnable {
    private static final Log log = LogFactory.getLog(EventDistributionTask.class);
    private BlockingDeque<Event> eventQueue;
    private List<AbstractEventHandler> notificationSendingModules;
    private volatile boolean running;

    public EventDistributionTask(List<AbstractEventHandler> notificationSendingModules, int threadPoolSize) {
        this.notificationSendingModules = notificationSendingModules;
        this.eventQueue = new LinkedBlockingDeque<Event>();
        IdentityEventServiceDataHolder.getInstance().setThreadPool(Executors.newFixedThreadPool(threadPoolSize));
    }

    public void addEventToQueue(Event publisherEvent) {
        this.eventQueue.add(publisherEvent);
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                final Event event = this.eventQueue.take();
                IdentityEventMessageContext eventContext = new IdentityEventMessageContext(event);
                for (final AbstractEventHandler module : this.notificationSendingModules) {
                    if (!module.isEnabled(eventContext)) continue;
                    Runnable msgSender = new Runnable(){

                        @Override
                        public void run() {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Executing " + module.getName() + " on event" + event.getEventName()));
                            }
                            try {
                                module.handleEvent(event);
                            }
                            catch (IdentityEventException e) {
                                log.error((Object)("Error while invoking notification sending module " + module.getName()), (Throwable)((Object)e));
                            }
                        }
                    };
                    IdentityEventServiceDataHolder.getInstance().getThreadPool().submit(msgSender);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while picking up event from event queue", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }
}

