/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.datasources;

import java.io.PrintWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class LocalXADataSource
implements XADataSource {
    private PrintWriter out;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private String validationQuery;
    private ThreadLocal<Connection> tlConn = new ThreadLocal();
    private ConnectionPool connectionPool;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.out = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Connection createConnection() throws SQLException {
        if (this.connectionPool == null) {
            Class<LocalXADataSource> clazz = LocalXADataSource.class;
            // MONITORENTER : org.wso2.carbon.ndatasource.datasources.LocalXADataSource.class
            if (this.connectionPool == null) {
                this.createConnectionPool();
            }
            // MONITOREXIT : clazz
        }
        Connection conn = this.connectionPool.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new LocalXAConnection();
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void createConnectionPool() throws SQLException {
        PoolProperties props = new PoolProperties();
        props.setUrl(this.getUrl());
        props.setUsername(this.getUsername());
        props.setPassword(this.getPassword());
        props.setDriverClassName(this.getDriverClassName());
        props.setValidationQuery(this.getValidationQuery());
        this.connectionPool = new ConnectionPool((PoolConfiguration)props);
    }

    public void initConn() throws SQLException {
        Connection conn = this.tlConn.get();
        if (conn == null || conn.isClosed()) {
            conn = this.createConnection();
            this.tlConn.set(conn);
        }
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public class LocalConnection
    implements Connection {
        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).isWrapperFor(iface);
        }

        @Override
        public Statement createStatement() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).commit();
        }

        @Override
        public void rollback() throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).rollback();
        }

        @Override
        public void close() throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).close();
        }

        @Override
        public boolean isClosed() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).rollback();
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            try {
                LocalXADataSource.this.initConn();
            }
            catch (SQLException e) {
                throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            }
            ((Connection)LocalXADataSource.this.tlConn.get()).setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            try {
                LocalXADataSource.this.initConn();
            }
            catch (SQLException e) {
                throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            }
            ((Connection)LocalXADataSource.this.tlConn.get()).setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            LocalXADataSource.this.initConn();
            ((Connection)LocalXADataSource.this.tlConn.get()).setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            LocalXADataSource.this.initConn();
            return ((Connection)LocalXADataSource.this.tlConn.get()).getNetworkTimeout();
        }
    }

    public class LocalXAResource
    implements XAResource {
        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            try {
                Connection conn = (Connection)LocalXADataSource.this.tlConn.get();
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new XAException(e.getMessage());
            }
            finally {
                LocalXADataSource.this.tlConn.set(null);
            }
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
        }

        @Override
        public void forget(Xid xid) throws XAException {
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        @Override
        public boolean isSameRM(XAResource xares) throws XAException {
            return false;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            try {
                Connection conn = (Connection)LocalXADataSource.this.tlConn.get();
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new XAException(e.getMessage());
            }
            finally {
                LocalXADataSource.this.tlConn.set(null);
            }
            return 0;
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            return new Xid[0];
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            try {
                Connection conn = (Connection)LocalXADataSource.this.tlConn.get();
                if (conn != null) {
                    conn.rollback();
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new XAException(e.getMessage());
            }
            finally {
                LocalXADataSource.this.tlConn.set(null);
            }
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            return true;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
        }
    }

    public class LocalXAConnection
    implements XAConnection {
        private List<ConnectionEventListener> ceListeners = new ArrayList<ConnectionEventListener>();

        @Override
        public Connection getConnection() throws SQLException {
            return new LocalConnection();
        }

        @Override
        public void close() throws SQLException {
            for (ConnectionEventListener listener : this.ceListeners) {
                listener.connectionClosed(new ConnectionEvent(null));
            }
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.ceListeners.add(listener);
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.ceListeners.remove(listener);
        }

        @Override
        public void addStatementEventListener(StatementEventListener listener) {
        }

        @Override
        public void removeStatementEventListener(StatementEventListener listener) {
        }

        @Override
        public XAResource getXAResource() throws SQLException {
            return new LocalXAResource();
        }
    }
}

