/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.deployer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.user.store.configuration.deployer.internal.UserStoreConfigComponent;
import org.wso2.carbon.user.core.UserStoreException;

public class UserStoreUtil {
    private static final Log log = LogFactory.getLog(UserStoreUtil.class);
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";

    public static Cipher getCipherOfSuperTenant() throws UserStoreException {
        Cipher cipher;
        try {
            String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
            cipher = cipherTransformation != null ? Cipher.getInstance(cipherTransformation, "BC") : Cipher.getInstance("RSA", "BC");
            cipher.init(1, UserStoreUtil.getCertificate().getPublicKey());
        }
        catch (InvalidKeyException e) {
            String errorMsg = "Invalid key is used to access keystore";
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        catch (KeyStoreException e) {
            String errorMsg = "Faulty keystore";
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            String errorMsg = "Some parameters assigned to access the keystore is invalid";
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        return cipher;
    }

    public static byte[] encrypt(Cipher cipher, byte[] plainTextBytes) throws BadPaddingException, IllegalBlockSizeException, UserStoreException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        byte[] cipherText = cipher.doFinal(plainTextBytes);
        if (System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY) != null) {
            cipherText = CryptoUtil.getDefaultCryptoUtil().createSelfContainedCiphertext(cipherText, System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY), UserStoreUtil.getCertificate());
        }
        return cipherText;
    }

    public static byte[] encrypt(byte[] plainTextBytes) throws CryptoException {
        boolean isInternalKeyStoreEncryptionEnabled = false;
        boolean isSymmetricKeyEncryptionEnabled = false;
        ServerConfigurationService config = UserStoreConfigComponent.getServerConfigurationService();
        if (config != null) {
            String cryptoProvider;
            String encryptionKeyStore = config.getFirstProperty("Security.UserStorePasswordEncryption");
            if ("InternalKeystore".equalsIgnoreCase(encryptionKeyStore)) {
                isInternalKeyStoreEncryptionEnabled = true;
            }
            if ("org.wso2.carbon.crypto.provider.SymmetricKeyInternalCryptoProvider".equalsIgnoreCase(cryptoProvider = config.getFirstProperty("CryptoService.InternalCryptoProviderClassName"))) {
                isSymmetricKeyEncryptionEnabled = true;
            }
        }
        if (isInternalKeyStoreEncryptionEnabled && isSymmetricKeyEncryptionEnabled) {
            throw new CryptoException(String.format("Userstore encryption can not be supported due to conflicting configurations: '%s' and '%s'. When using internal keystore, assymetric crypto provider should be used.", "InternalKeystore", "org.wso2.carbon.crypto.provider.SymmetricKeyInternalCryptoProvider"));
        }
        if (isInternalKeyStoreEncryptionEnabled || isSymmetricKeyEncryptionEnabled) {
            return CryptoUtil.getDefaultCryptoUtil().encrypt(plainTextBytes);
        }
        return UserStoreUtil.encryptWithPrimaryKeyStore(plainTextBytes);
    }

    private static byte[] encryptWithPrimaryKeyStore(byte[] plainTextBytes) throws CryptoException {
        Cipher cipher;
        Certificate certificate;
        String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
        try {
            certificate = UserStoreUtil.getCertificate();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException | UserStoreException e) {
            throw new CryptoException("Error occurred while retrieving the certificate.", e);
        }
        try {
            cipher = cipherTransformation != null ? Cipher.getInstance(cipherTransformation, "BC") : Cipher.getInstance("RSA", "BC");
            cipher.init(1, certificate.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CryptoException("Error occurred while creating the cipher.", (Throwable)e);
        }
        try {
            byte[] cipherText = cipher.doFinal(plainTextBytes);
            if (cipherTransformation != null) {
                cipherText = CryptoUtil.getDefaultCryptoUtil().createSelfContainedCiphertext(cipherText, cipherTransformation, certificate);
            }
            return cipherText;
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoException("Error occurred while encrypting.", (Throwable)e);
        }
    }

    private static Certificate getCertificate() throws UserStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        ServerConfigurationService config = UserStoreConfigComponent.getServerConfigurationService();
        if (config == null) {
            String errMsg = "ServerConfigurationService is null - this situation can't occur";
            throw new UserStoreException(errMsg);
        }
        String filePath = config.getFirstProperty("Security.KeyStore.Location");
        String keyStoreType = config.getFirstProperty("Security.KeyStore.Type");
        String password = config.getFirstProperty("Security.KeyStore.Password");
        String keyAlias = config.getFirstProperty("Security.KeyStore.KeyAlias");
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(filePath).getAbsolutePath());
            KeyStore store = KeyStore.getInstance(keyStoreType);
            store.load(inputStream, password.toCharArray());
            Certificate certificate = store.getCertificateChain(keyAlias)[0];
            return certificate;
        }
        catch (FileNotFoundException e) {
            String errorMsg = "Keystore File Not Found in configured location";
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        catch (IOException e) {
            String errorMsg = "Keystore File IO operation failed";
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Key store file closing failed");
                }
            }
        }
    }
}

