/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.deployer.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.user.store.org.wso2.carbon.identity.user.store.configuration.component", immediate=true)
public class UserStoreConfigComponent {
    private static final Log log = LogFactory.getLog(UserStoreConfigComponent.class);
    private static RealmService realmService = null;
    private static ServerConfigurationService serverConfigurationService = null;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        UserStoreConfigComponent.realmService = realmService;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    @Reference(name="server.configuration.service", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the serverConfigurationService");
        }
        UserStoreConfigComponent.serverConfigurationService = serverConfigurationService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity userstore bundle is activated.");
        }
        this.triggerDeployerForSuperTenantSecondaryUserStores();
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Userstore-Config bundle is deactivated");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        UserStoreConfigComponent.realmService = null;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the ConfigurationContextService");
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unset the ConfigurationContextService");
        }
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ServerConfigurationService");
        }
        UserStoreConfigComponent.serverConfigurationService = null;
    }

    private void triggerDeployerForSuperTenantSecondaryUserStores() {
        String superTenantUserStorePath;
        File folder;
        File[] listOfFiles;
        int repoLength;
        String repositoryPath = CarbonUtils.getCarbonRepository();
        String fSeperator = repositoryPath.substring((repoLength = repositoryPath.length()) - 1, repoLength);
        if (!fSeperator.equals(File.separator)) {
            repositoryPath = repositoryPath + File.separator;
        }
        if ((listOfFiles = (folder = new File(superTenantUserStorePath = repositoryPath + "userstores" + File.separator)).listFiles()) != null) {
            for (File file : listOfFiles) {
                String ext;
                if (file == null || !this.isValidExtension(ext = FilenameUtils.getExtension((String)file.getAbsolutePath()))) continue;
                try {
                    FileUtils.touch((File)new File(file.getAbsolutePath()));
                }
                catch (IOException e) {
                    String errMsg = "Error occurred while trying to touch " + file.getName() + ". Passwords will continue to remain in plaintext";
                    log.error((Object)errMsg, (Throwable)e);
                }
            }
        }
    }

    private boolean isValidExtension(String ext) {
        if (ext != null) {
            if ("xml".equalsIgnoreCase(ext)) {
                return true;
            }
            if ("enc".equalsIgnoreCase(ext)) {
                return true;
            }
        }
        return false;
    }
}

