/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.FileUtils;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.identity.user.store.configuration.deployer.exception.UserStoreConfigurationDeployerException;
import org.wso2.carbon.identity.user.store.configuration.deployer.internal.UserStoreConfigComponent;
import org.wso2.carbon.identity.user.store.configuration.deployer.util.UserStoreUtil;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.core.common.UserStoreDeploymentManager;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;

public class UserStoreConfigurationDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(UserStoreConfigurationDeployer.class);
    private AxisConfiguration axisConfig;

    private static boolean isEligibleTobeEncrypted(OMElement propElem) {
        String plainText;
        String secretPropName;
        String secAlias = propElem.getAttributeValue(new QName("http://org.wso2.securevault/configuration", ""));
        return secAlias == null && (secretPropName = propElem.getAttributeValue(new QName("encrypt"))) != null && secretPropName.equalsIgnoreCase("true") && (plainText = propElem.getText()) != null;
    }

    private static ArrayList<String> getEncryptPropertyList(String userStoreClass) {
        Property[] mandatoryProperties = UserStoreManagerRegistry.getUserStoreProperties((String)userStoreClass).getMandatoryProperties();
        ArrayList<String> propertyList = new ArrayList<String>();
        for (Property property : mandatoryProperties) {
            String propertyName;
            if (property == null || (propertyName = property.getName()) == null || !property.getDescription().contains("#encrypt")) continue;
            propertyList.add(propertyName);
        }
        return propertyList;
    }

    public void init(ConfigurationContext configurationContext) {
        log.info((Object)"User Store Configuration Deployer initiated.");
        this.axisConfig = configurationContext.getAxisConfiguration();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (deploymentFileData.getName().startsWith("FEDERATED")) {
            throw new DeploymentException("'FEDERATED' is a reserved user store domain prefix. Please start the file name with a different domain name.");
        }
        ServerConfigurationService config = UserStoreConfigComponent.getServerConfigurationService();
        if (config != null) {
            String absolutePath = deploymentFileData.getAbsolutePath();
            String ext = FilenameUtils.getExtension((String)absolutePath);
            if ("enc".equalsIgnoreCase(ext)) {
                FileOutputStream outputStream = null;
                try {
                    OMElement secondaryStoreDocument = this.initializeOMElement(absolutePath);
                    this.updateSecondaryUserStore(secondaryStoreDocument);
                    int index = absolutePath.lastIndexOf(".");
                    if (index != 1) {
                        String encFileName = absolutePath.substring(0, index + 1) + "xml";
                        outputStream = new FileOutputStream(encFileName);
                        secondaryStoreDocument.serialize((OutputStream)outputStream);
                        File file = new File(absolutePath);
                        if (file.exists()) {
                            FileUtils.delete((File)file);
                        }
                    }
                    return;
                }
                catch (UserStoreConfigurationDeployerException e) {
                    String errMsg = "Secondary user store processing failed while processing " + absolutePath;
                    throw new DeploymentException(errMsg, (Throwable)((Object)e));
                }
                catch (FileNotFoundException e) {
                    String errMsg = "Secondary user store File path " + absolutePath + " is invalid";
                    throw new DeploymentException(errMsg, (Throwable)e);
                }
                catch (XMLStreamException e) {
                    String errMsg = "Unexpected xml processing errors while trying to update file " + absolutePath;
                    throw new DeploymentException(errMsg, (Throwable)e);
                }
                finally {
                    IdentityIOStreamUtils.closeOutputStream(outputStream);
                }
            }
            UserStoreDeploymentManager userStoreDeploymentManager = new UserStoreDeploymentManager();
            userStoreDeploymentManager.deploy(deploymentFileData.getAbsolutePath());
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        String ext;
        if (fileName != null && !"enc".equalsIgnoreCase(ext = FilenameUtils.getExtension((String)fileName))) {
            UserStoreDeploymentManager userStoreDeploymentManager = new UserStoreDeploymentManager();
            userStoreDeploymentManager.undeploy(fileName);
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OMElement initializeOMElement(String absoluteFilePath) throws UserStoreConfigurationDeployerException {
        OMElement oMElement;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(absoluteFilePath);
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)inStream);
            oMElement = builder.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            try {
                String errMsg = " Secondary storage file Not found in given repo " + absoluteFilePath;
                throw new UserStoreConfigurationDeployerException(errMsg, e);
                catch (XMLStreamException e2) {
                    errMsg = " Secondary storage file reading for repo = " + absoluteFilePath + " failed ";
                    throw new UserStoreConfigurationDeployerException(errMsg, e2);
                }
            }
            catch (Throwable throwable) {
                IdentityIOStreamUtils.closeInputStream(inStream);
                throw throwable;
            }
        }
        IdentityIOStreamUtils.closeInputStream((InputStream)inStream);
        return oMElement;
    }

    private void updateSecondaryUserStore(OMElement secondaryStoreDocument) throws UserStoreConfigurationDeployerException {
        String className = secondaryStoreDocument.getAttributeValue(new QName("class"));
        ArrayList<String> encryptList = UserStoreConfigurationDeployer.getEncryptPropertyList(className);
        Iterator ite = secondaryStoreDocument.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            boolean encrypt;
            OMElement propElem = (OMElement)ite.next();
            if (propElem == null || propElem.getText() == null) continue;
            String propertyName = propElem.getAttributeValue(new QName("name"));
            OMAttribute encryptedAttr = propElem.getAttribute(new QName("encrypted"));
            if (encryptedAttr != null || !(encrypt = encryptList.contains(propertyName) || UserStoreConfigurationDeployer.isEligibleTobeEncrypted(propElem))) continue;
            OMAttribute encryptAttr = propElem.getAttribute(new QName("encrypt"));
            if (encryptAttr != null) {
                propElem.removeAttribute(encryptAttr);
            }
            try {
                String cipherText = Base64.encode((byte[])UserStoreUtil.encrypt(propElem.getText().getBytes()));
                propElem.setText(cipherText);
                propElem.addAttribute("encrypted", "true", null);
            }
            catch (CryptoException e) {
                String errMsg = "Encryption in secondary user store failed";
                throw new UserStoreConfigurationDeployerException(errMsg, e);
            }
        }
    }
}

