/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannelManager;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.handler.event.account.lock.exception.AccountLockServiceException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class Utils {
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static final Log log = LogFactory.getLog(Utils.class);
    private static ThreadLocal<org.wso2.carbon.identity.recovery.model.Property[]> arbitraryProperties = new ThreadLocal();
    private static ThreadLocal<Claim> emailVerifyTemporaryClaim = new ThreadLocal();
    private static ThreadLocal<String> skipSendingEmailVerificationOnUpdateState = new ThreadLocal();
    private static ThreadLocal<String> skipSendingSmsOtpVerificationOnUpdate = new ThreadLocal();
    private static final String[] pwdPatternViolations = new String[]{UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL_BY_ADMIN.getCode(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_DURING_PRE_UPDATE_CREDENTIAL.getCode()};
    private static final String PROPERTY_PASSWORD_ERROR_MSG = "PasswordJavaRegExViolationErrorMsg";

    public static NotificationChannelManager getNotificationChannelManager() {
        return (NotificationChannelManager)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(NotificationChannelManager.class, null);
    }

    public static org.wso2.carbon.identity.recovery.model.Property[] getArbitraryProperties() {
        if (arbitraryProperties.get() == null) {
            return null;
        }
        return arbitraryProperties.get();
    }

    public static void setArbitraryProperties(org.wso2.carbon.identity.recovery.model.Property[] properties) {
        arbitraryProperties.set(properties);
    }

    public static void clearArbitraryProperties() {
        arbitraryProperties.remove();
    }

    public static Claim getEmailVerifyTemporaryClaim() {
        if (emailVerifyTemporaryClaim.get() == null) {
            return null;
        }
        return emailVerifyTemporaryClaim.get();
    }

    public static void setEmailVerifyTemporaryClaim(Claim claim) {
        emailVerifyTemporaryClaim.set(claim);
    }

    public static void clearEmailVerifyTemporaryClaim() {
        emailVerifyTemporaryClaim.remove();
    }

    public static void unsetThreadLocalToSkipSendingEmailVerificationOnUpdate() {
        skipSendingEmailVerificationOnUpdateState.remove();
    }

    public static String getThreadLocalToSkipSendingEmailVerificationOnUpdate() {
        return skipSendingEmailVerificationOnUpdateState.get();
    }

    public static void setThreadLocalToSkipSendingEmailVerificationOnUpdate(String value) {
        skipSendingEmailVerificationOnUpdateState.set(value);
    }

    public static void unsetThreadLocalToSkipSendingSmsOtpVerificationOnUpdate() {
        skipSendingSmsOtpVerificationOnUpdate.remove();
    }

    public static String getThreadLocalToSkipSendingSmsOtpVerificationOnUpdate() {
        return skipSendingSmsOtpVerificationOnUpdate.get();
    }

    public static void setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(String value) {
        skipSendingSmsOtpVerificationOnUpdate.set(value);
    }

    public static String getClaimFromUserStoreManager(User user, String claim) throws org.wso2.carbon.user.api.UserStoreException {
        Map claimsMap;
        String userStoreQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        String claimValue = "";
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        if (realmService.getTenantUserRealm(tenantId) != null) {
            userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        if (userStoreManager != null && (claimsMap = userStoreManager.getUserClaimValues(userStoreQualifiedUsername, new String[]{claim}, "default")) != null && !claimsMap.isEmpty()) {
            claimValue = (String)claimsMap.get(claim);
        }
        return claimValue;
    }

    public static void removeClaimFromUserStoreManager(User user, String[] claims) throws org.wso2.carbon.user.api.UserStoreException {
        int tenantId;
        String userStoreQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        if (realmService.getTenantUserRealm(tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) != null) {
            userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        if (userStoreManager != null) {
            userStoreManager.deleteUserClaimValues(userStoreQualifiedUsername, claims, "default");
        }
    }

    public static IdentityRecoveryServerException handleServerException(IdentityRecoveryConstants.ErrorMessages error, String data) throws IdentityRecoveryServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityRecoveryServerException)IdentityException.error(IdentityRecoveryServerException.class, (String)error.getCode(), (String)errorDescription);
    }

    public static IdentityRecoveryServerException handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages error, String userId, int tenantId, String functionalityIdentifier, boolean isDetailedErrorMessagesEnabled) throws IdentityRecoveryServerException {
        String mappedErrorCode = Utils.prependOperationScenarioToErrorCode(error.getCode(), "PWR");
        StringBuilder message = new StringBuilder(error.getMessage());
        if (isDetailedErrorMessagesEnabled) {
            message.append(String.format("functionality: %s \nuserId: %s \ntenantId: %d.", functionalityIdentifier, userId, tenantId));
        }
        throw Utils.handleServerException(mappedErrorCode, message.toString(), null);
    }

    public static IdentityRecoveryServerException handleServerException(IdentityRecoveryConstants.ErrorMessages error, String data, Throwable e) throws IdentityRecoveryServerException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityRecoveryServerException)IdentityException.error(IdentityRecoveryServerException.class, (String)error.getCode(), (String)errorDescription, (Throwable)e);
    }

    public static IdentityRecoveryServerException handleServerException(String errorCode, String errorMessage, String data) {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(errorMessage, data) : errorMessage;
        return (IdentityRecoveryServerException)IdentityException.error(IdentityRecoveryServerException.class, (String)errorCode, (String)errorDescription);
    }

    public static IdentityRecoveryClientException handleClientException(IdentityRecoveryConstants.ErrorMessages error, String data) throws IdentityRecoveryClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)error.getCode(), (String)errorDescription);
    }

    public static IdentityRecoveryClientException handleClientException(IdentityRecoveryConstants.ErrorMessages error, String data, Throwable e) throws IdentityRecoveryClientException {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)error.getCode(), (String)errorDescription, (Throwable)e);
    }

    public static IdentityRecoveryClientException handleClientException(String errorCode, String errorMessage, String data) {
        String errorDescription = StringUtils.isNotBlank((String)data) ? String.format(errorMessage, data) : errorMessage;
        return (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)errorCode, (String)errorDescription);
    }

    public static String doHash(String value) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            String digsestFunction = "SHA-256";
            MessageDigest dgst = MessageDigest.getInstance(digsestFunction);
            byte[] byteValue = dgst.digest(value.getBytes());
            return Base64.encode((byte[])byteValue);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new org.wso2.carbon.user.api.UserStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static void setClaimInUserStoreManager(User user, String claim, String value) throws org.wso2.carbon.user.api.UserStoreException {
        Map values;
        String oldValue;
        String fullUserName = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        if (realmService.getTenantUserRealm(tenantId) != null) {
            userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        if (!(userStoreManager == null || (oldValue = (String)(values = userStoreManager.getUserClaimValues(fullUserName, new String[]{claim}, "default")).get(claim)) != null && oldValue.equals(value))) {
            HashMap<String, String> claimMap = new HashMap<String, String>();
            claimMap.put(claim, value);
            userStoreManager.setUserClaimValues(fullUserName, claimMap, "default");
        }
    }

    public static Map<String, String> getClaimListOfUser(User user, String[] claimsList) throws IdentityRecoveryClientException, IdentityRecoveryServerException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = Utils.getUserStoreManager(user);
        String userStoreQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        if (ArrayUtils.isEmpty((Object[])claimsList)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_CLAIMS, null);
        }
        try {
            return userStoreManager.getUserClaimValues(userStoreQualifiedUsername, claimsList, "default");
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_CLAIMS, user.getUserName(), e);
        }
    }

    public static void setClaimsListOfUser(User user, Map<String, String> claimsMap) throws IdentityRecoveryClientException, IdentityRecoveryServerException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = Utils.getUserStoreManager(user);
        String userStoreQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        try {
            if (MapUtils.isNotEmpty(claimsMap)) {
                userStoreManager.setUserClaimValues(userStoreQualifiedUsername, claimsMap, "default");
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_USER_CLAIMS, null, e);
        }
    }

    private static org.wso2.carbon.user.core.UserStoreManager getUserStoreManager(User user) throws IdentityRecoveryClientException, IdentityRecoveryServerException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager;
        if (user == null) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USER, "Invalid User Data provided.");
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        try {
            RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
            if (realmService == null || realmService.getTenantUserRealm(tenantId) == null) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, user.getTenantDomain());
            }
            userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, user.getTenantDomain(), e);
        }
        if (userStoreManager == null) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_STORE_MANAGER, null);
        }
        return userStoreManager;
    }

    public static String getRecoveryConfigs(String key, String tenantDomain) throws IdentityRecoveryServerException {
        try {
            Property[] connectorConfigs;
            IdentityGovernanceService identityGovernanceService = IdentityRecoveryServiceDataHolder.getInstance().getIdentityGovernanceService();
            for (Property connectorConfig : connectorConfigs = identityGovernanceService.getConfiguration(new String[]{key}, tenantDomain)) {
                if (!key.equals(connectorConfig.getName())) continue;
                return connectorConfig.getValue();
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ISSUE_IN_LOADING_RECOVERY_CONFIGS, null);
        }
        catch (IdentityGovernanceException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ISSUE_IN_LOADING_RECOVERY_CONFIGS, null, e);
        }
    }

    public static String getSignUpConfigs(String key, String tenantDomain) throws IdentityRecoveryServerException {
        try {
            IdentityGovernanceService identityGovernanceService = IdentityRecoveryServiceDataHolder.getInstance().getIdentityGovernanceService();
            Property[] connectorConfigs = identityGovernanceService.getConfiguration(new String[]{key}, tenantDomain);
            return connectorConfigs[0].getValue();
        }
        catch (IdentityGovernanceException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ISSUE_IN_LOADING_SIGNUP_CONFIGS, null, e);
        }
    }

    public static String getConnectorConfig(String key, String tenantDomain) throws IdentityEventException {
        try {
            IdentityGovernanceService identityGovernanceService = IdentityRecoveryServiceDataHolder.getInstance().getIdentityGovernanceService();
            Property[] connectorConfigs = identityGovernanceService.getConfiguration(new String[]{key}, tenantDomain);
            return connectorConfigs[0].getValue();
        }
        catch (IdentityGovernanceException e) {
            throw new IdentityEventException("Error while getting connector configurations", (Throwable)e);
        }
    }

    public static String getChallengeSetDirFromUri(String challengeSetUri) {
        if (StringUtils.isBlank((String)challengeSetUri)) {
            return challengeSetUri;
        }
        String[] components = challengeSetUri.split("http://wso2.org/claims/");
        return components.length > 1 ? components[1] : components[0];
    }

    public static ChallengeQuestion[] getDefaultChallengeQuestions() {
        String questionId;
        String setId;
        ArrayList<ChallengeQuestion> challengeQuestions = new ArrayList<ChallengeQuestion>();
        int count = 0;
        for (String question : IdentityRecoveryConstants.Questions.SECRET_QUESTIONS_SET01) {
            setId = "http://wso2.org/claims/challengeQuestion1";
            questionId = "question" + ++count;
            challengeQuestions.add(new ChallengeQuestion(setId, questionId, question, "en_US"));
        }
        count = 0;
        for (String question : IdentityRecoveryConstants.Questions.SECRET_QUESTIONS_SET02) {
            setId = "http://wso2.org/claims/challengeQuestion2";
            questionId = "question" + ++count;
            challengeQuestions.add(new ChallengeQuestion(setId, questionId, question, "en_US"));
        }
        return challengeQuestions.toArray(new ChallengeQuestion[challengeQuestions.size()]);
    }

    public static boolean isAccountLocked(User user) throws IdentityRecoveryException {
        try {
            return IdentityRecoveryServiceDataHolder.getInstance().getAccountLockService().isAccountLocked(user.getUserName(), user.getTenantDomain(), user.getUserStoreDomain());
        }
        catch (AccountLockServiceException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_CHECK_ACCOUNT_LOCK_STATUS, user.getUserName(), e);
        }
    }

    public static boolean isAccountDisabled(User user) throws IdentityRecoveryException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager;
        org.wso2.carbon.user.core.UserRealm userRealm;
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            userRealm = (org.wso2.carbon.user.core.UserRealm)realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, user.getTenantDomain(), e);
        }
        try {
            userStoreManager = userRealm.getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_STORE_MANAGER, null, e);
        }
        try {
            Map values = userStoreManager.getUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), new String[]{"http://wso2.org/claims/identity/accountDisabled"}, "default");
            boolean accountDisable = Boolean.parseBoolean((String)values.get("http://wso2.org/claims/identity/accountDisabled"));
            return accountDisable;
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_CLAIMS, null, e);
        }
    }

    public static User createUser(String username, String tenantDomain) {
        User user = new User();
        user.setUserName(MultitenantUtils.getTenantAwareUsername((String)username));
        user.setTenantDomain(tenantDomain);
        return user;
    }

    public static boolean validateCallbackURL(String callbackURL, String tenantDomain, String callbackRegexType) throws IdentityEventException {
        String callbackRegex = Utils.getConnectorConfig(callbackRegexType, tenantDomain);
        return callbackRegex != null && callbackURL.matches(callbackRegex);
    }

    public static String getCallbackURLFromRegistration(org.wso2.carbon.identity.recovery.model.Property[] properties) throws UnsupportedEncodingException, MalformedURLException {
        if (properties == null) {
            return null;
        }
        String callbackURL = null;
        for (org.wso2.carbon.identity.recovery.model.Property property : properties) {
            if (!"callback".equals(property.getKey())) continue;
            callbackURL = URLDecoder.decode(property.getValue(), "UTF-8");
            break;
        }
        if (StringUtils.isNotBlank(callbackURL)) {
            URL url = new URL(callbackURL);
            callbackURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), null).toString();
        }
        return callbackURL;
    }

    public static String getCallbackURL(org.wso2.carbon.identity.recovery.model.Property[] properties) throws UnsupportedEncodingException, URISyntaxException {
        if (properties == null) {
            return null;
        }
        String callbackURL = null;
        for (org.wso2.carbon.identity.recovery.model.Property property : properties) {
            if (!"callback".equals(property.getKey())) continue;
            callbackURL = property.getValue();
            break;
        }
        if (StringUtils.isNotBlank(callbackURL)) {
            URI uri = new URI(callbackURL);
            callbackURL = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
        }
        return callbackURL;
    }

    public static boolean isLiteSignUp(org.wso2.carbon.identity.recovery.model.Property[] properties) {
        if (properties == null) {
            return false;
        }
        boolean isLiteSignUp = false;
        for (org.wso2.carbon.identity.recovery.model.Property property : properties) {
            if (!"isLiteSignUp".equals(property.getKey())) continue;
            isLiteSignUp = Boolean.parseBoolean(property.getValue());
        }
        return isLiteSignUp;
    }

    public static boolean isUserPortalURL(org.wso2.carbon.identity.recovery.model.Property[] properties) {
        if (properties == null) {
            return false;
        }
        for (org.wso2.carbon.identity.recovery.model.Property property : properties) {
            if (!"isUserPortalURL".equals(property.getKey())) continue;
            return Boolean.parseBoolean(property.getValue());
        }
        return false;
    }

    public static void checkPasswordPatternViolation(org.wso2.carbon.user.api.UserStoreException exception, User user) throws IdentityRecoveryClientException {
        if (StringUtils.isBlank((String)exception.getMessage())) {
            return;
        }
        RealmConfiguration realmConfig = Utils.getRealmConfiguration(user);
        String passwordErrorMessage = realmConfig.getUserStoreProperty(PROPERTY_PASSWORD_ERROR_MSG);
        String exceptionMessage = exception.getMessage();
        if (StringUtils.indexOfAny((String)exceptionMessage, (String[])pwdPatternViolations) >= 0 && StringUtils.containsIgnoreCase((String)exceptionMessage, (String)passwordErrorMessage) || exceptionMessage.contains(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_INVALID_PASSWORD.getCode())) {
            throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_POLICY_VIOLATION.getCode(), (String)passwordErrorMessage, (Throwable)exception);
        }
    }

    private static RealmConfiguration getRealmConfiguration(User user) throws IdentityRecoveryClientException {
        UserStoreManager userStoreManager;
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        try {
            userStoreManager = IdentityRecoveryServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException userStoreException) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, userStoreException);
        }
        return ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getSecondaryUserStoreManager(user.getUserStoreDomain()).getRealmConfiguration();
    }

    public static boolean isAccountStateClaimExisting(String tenantDomain) throws IdentityEventException {
        UserRealm userRealm = null;
        ClaimManager claimManager = null;
        boolean isExist = false;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        if (realmService != null) {
            try {
                Claim claim;
                int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                userRealm = realmService.getTenantUserRealm(tenantId);
                if (userRealm != null && (claimManager = userRealm.getClaimManager()) != null && (claim = claimManager.getClaim("http://wso2.org/claims/identity/accountState")) != null) {
                    isExist = true;
                }
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityEventException("Error while retrieving accountState claim from ClaimManager.", (Throwable)e);
            }
        }
        return isExist;
    }

    public static String prependOperationScenarioToErrorCode(String exceptionErrorCode, String scenario) {
        if (StringUtils.isNotEmpty((String)exceptionErrorCode)) {
            if (exceptionErrorCode.contains("-")) {
                return exceptionErrorCode;
            }
            if (StringUtils.isNotEmpty((String)scenario)) {
                exceptionErrorCode = scenario + "-" + exceptionErrorCode;
            }
        }
        return exceptionErrorCode;
    }

    public static boolean isNotificationsInternallyManaged(String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        if (MapUtils.isNotEmpty(properties)) {
            try {
                String manageNotificationsInternally = properties.get("manageNotificationsInternally");
                if (StringUtils.isEmpty((String)manageNotificationsInternally)) {
                    return Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", tenantDomain));
                }
                return Boolean.parseBoolean(manageNotificationsInternally);
            }
            catch (NumberFormatException e) {
                String manageNotificationsInternally = Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", tenantDomain);
                if (log.isDebugEnabled()) {
                    String error = String.format("Invalid boolean value : %s to enable enable internal notification management. Server default value : %s will be used.", properties.get("manageNotificationsInternally"), manageNotificationsInternally);
                    log.debug((Object)error);
                }
                return Boolean.parseBoolean(manageNotificationsInternally);
            }
        }
        return Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", tenantDomain));
    }

    public static String resolveEventName(String notificationChannel) {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return "TRIGGER_" + notificationChannel + "_NOTIFICATION";
        }
        return "TRIGGER_NOTIFICATION";
    }

    public static void validateEmailUsername(String username) throws IdentityRecoveryClientException {
        if (IdentityUtil.isEmailUsernameEnabled() && StringUtils.countMatches((String)username, (String)"@") == 0) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USERNAME, username);
        }
    }

    public static User buildUser(String username, String tenantDomain) {
        User user = new User();
        user.setUserName(UserCoreUtil.removeDomainFromName((String)username));
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)username));
        return user;
    }

    public static boolean isPerUserFunctionalityLockingEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"EnablePerUserFunctionalityLocking"));
    }

    public static boolean isDetailedErrorResponseEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.ErrorMessage.EnableDetailedErrorMessages"));
    }

    public static String getUserId(String userName, int tenantId) throws IdentityRecoveryServerException {
        String userId;
        org.wso2.carbon.user.core.UserStoreManager userStoreManager;
        try {
            RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
            if (realmService == null || realmService.getTenantUserRealm(tenantId) == null) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, String.valueOf(tenantId));
            }
            userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (IdentityRecoveryServerException | org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, String.valueOf(tenantId), (Throwable)e);
        }
        try {
            userId = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(userName);
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_USER_CLAIMS, null, e);
        }
        return userId;
    }

    public static boolean isSkipRecoveryWithChallengeQuestionsForInsufficientAnswersEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.Question.Password.SkipOnInsufficientAnswers"));
    }

    public static void createAuditMessage(String action, String target, JSONObject dataObject, String result) {
        String loggedInUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUser)) {
            loggedInUser = "wso2.system.user";
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        loggedInUser = UserCoreUtil.addTenantDomainToEntry((String)loggedInUser, (String)tenantDomain);
        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : %s | Result : %s ", loggedInUser, action, target, dataObject, result));
    }

    public static String generateSecretKey(String channel, String tenantDomain, String recoveryScenario) throws IdentityRecoveryServerException {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(channel)) {
            String charSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            int otpLength = 6;
            if (StringUtils.equals((String)RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY.name(), (String)recoveryScenario)) {
                String otpRegex = Utils.getRecoveryConfigs("Recovery.Notification.Password.smsOtp.Regex", tenantDomain);
                if (!Pattern.matches("^\\[((a-z)|(A-Z)|(0-9)){1,3}\\]\\{[0-9]+\\}$", otpRegex)) {
                    throw new IdentityRecoveryServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_SMS_OTP_REGEX.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_SMS_OTP_REGEX.getMessage());
                }
                String charsRegex = otpRegex.replaceAll("[{].*", "");
                otpLength = Integer.parseInt(otpRegex.replaceAll(".*[{]", "").replaceAll("}", ""));
                charSet = Utils.generateCharSet(charsRegex);
            }
            return Utils.generateSMSOTP(charSet, otpLength);
        }
        return UUIDGenerator.generateUUID();
    }

    private static String generateCharSet(String regex) {
        StringBuilder charSet = new StringBuilder();
        if (regex.contains("A-Z")) {
            charSet.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        }
        if (regex.contains("a-z")) {
            charSet.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase());
        }
        if (regex.contains("0-9")) {
            charSet.append("0123456789");
        }
        return charSet.toString();
    }

    private static String generateSMSOTP(String charSet, int otpLength) {
        char[] chars = charSet.toCharArray();
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < otpLength; ++i) {
            sb.append(chars[rnd.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    public static boolean isUseVerifyClaimEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"UserClaimUpdate.UseVerifyClaim"));
    }
}

