/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.username;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.dto.RecoveryInformationDTO;
import org.wso2.carbon.identity.recovery.internal.service.impl.username.UsernameRecoveryManagerImpl;
import org.wso2.carbon.identity.recovery.model.UserClaim;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.Claim;

public class NotificationUsernameRecoveryManager {
    private static final Log log = LogFactory.getLog(NotificationUsernameRecoveryManager.class);
    private static final String FORWARD_SLASH = "/";
    private static NotificationUsernameRecoveryManager instance = new NotificationUsernameRecoveryManager();
    private static UsernameRecoveryManagerImpl usernameRecoveryManagerImpl = new UsernameRecoveryManagerImpl();

    private NotificationUsernameRecoveryManager() {
    }

    public static NotificationUsernameRecoveryManager getInstance() {
        return instance;
    }

    public String[] getUserIdentitySupportedClaims(String dialect, String tenantDomain) throws IdentityException {
        UserRealm realm;
        IdentityClaimManager claimManager = IdentityClaimManager.getInstance();
        Claim[] claims = claimManager.getAllSupportedClaims(dialect, realm = IdentityTenantUtil.getRealm(null, null));
        if (claims == null || claims.length == 0) {
            log.warn((Object)("Could not find any matching claims for requested dialect : " + dialect));
            return new String[0];
        }
        ArrayList<String> claimList = new ArrayList<String>();
        for (int i = 0; i < claims.length; ++i) {
            if (claims[i].getDisplayTag() == null || IdentityConstants.PPID_DISPLAY_VALUE.equals(claims[i].getDisplayTag()) || "http://wso2.org/claims/identity/accountLock".equals(claims[i].getClaimUri()) || !claims[i].isSupportedByDefault() || claims[i].isReadOnly()) continue;
            claimList.add(claims[i].getClaimUri());
        }
        return claimList.toArray(new String[claimList.size()]);
    }

    public Claim[] getIdentitySupportedClaims(String dialect, String tenantDomain) throws IdentityException {
        UserRealm realm;
        IdentityClaimManager claimManager = IdentityClaimManager.getInstance();
        Claim[] claims = claimManager.getAllSupportedClaims(dialect, realm = IdentityTenantUtil.getRealm((String)tenantDomain, null));
        if (claims == null || claims.length == 0) {
            log.warn((Object)("Could not find any matching claims for requested dialect : " + dialect));
            return new Claim[0];
        }
        return claims;
    }

    public String verifyUsername(UserClaim[] claims, String tenantDomain, Boolean notify) throws IdentityRecoveryException {
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        boolean isNotificationInternallyManaged = this.isNotificationsInternallyManaged(tenantDomain, notify);
        HashMap<String, String> userClaims = this.buildUserClaimsMap(claims);
        if (claims.length < 1) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_FIELD_FOUND_FOR_USER_RECOVERY, null);
        }
        RecoveryInformationDTO recoveryInformationDTO = this.initiateUsernameRecovery(userClaims, tenantDomain, isNotificationInternallyManaged);
        if (recoveryInformationDTO == null) {
            return null;
        }
        return recoveryInformationDTO.getUsername();
    }

    private RecoveryInformationDTO initiateUsernameRecovery(Map<String, String> claims, String tenantDomain, boolean manageNotificationsInternally) throws IdentityRecoveryException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("useLegacyAPI", Boolean.toString(true));
            properties.put("manageNotificationsInternally", Boolean.toString(manageNotificationsInternally));
            return usernameRecoveryManagerImpl.initiate(claims, tenantDomain, properties);
        }
        catch (IdentityRecoveryServerException exception) {
            if (StringUtils.isNotEmpty((String)exception.getErrorCode())) {
                String errorCode = exception.getErrorCode();
                if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER.getCode().equals(errorCode)) {
                    String msg = "Error retrieving the user store manager for the tenant";
                    throw new IdentityRecoveryException(msg, (Throwable)((Object)exception));
                }
                if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_USER_CLAIM.getCode().equals(errorCode)) {
                    String msg = "Unable to retrieve the claim for the given tenant";
                    throw new IdentityRecoveryException(msg, (Throwable)((Object)exception));
                }
            }
            throw exception;
        }
        catch (IdentityRecoveryClientException exception) {
            if (StringUtils.isNotEmpty((String)exception.getErrorCode())) {
                String errorCode = exception.getErrorCode();
                if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_MULTIPLE_MATCHING_USERS.getCode().equals(errorCode)) {
                    if (Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.NotifyUserExistence"))) {
                        throw exception;
                    }
                    return null;
                }
                if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_NOT_ENABLED.getCode().equals(errorCode)) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_NOT_ENABLE, null);
                }
            }
            throw exception;
        }
    }

    private HashMap<String, String> buildUserClaimsMap(UserClaim[] claims) {
        HashMap<String, String> claimsMap = new HashMap<String, String>();
        for (UserClaim userClaim : claims) {
            if (!StringUtils.isNotEmpty((String)userClaim.getClaimURI()) || !StringUtils.isNotEmpty((String)userClaim.getClaimValue())) continue;
            claimsMap.put(userClaim.getClaimURI(), userClaim.getClaimValue());
        }
        return claimsMap;
    }

    private boolean isNotificationsInternallyManaged(String tenantDomain, Boolean notify) throws IdentityRecoveryException {
        if (notify == null) {
            return Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", tenantDomain));
        }
        return notify;
    }
}

