/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;

public class JDBCRecoveryDataStore
implements UserRecoveryDataStore {
    private static UserRecoveryDataStore jdbcRecoveryDataStore = new JDBCRecoveryDataStore();
    private static final Log log = LogFactory.getLog(JDBCRecoveryDataStore.class);

    private JDBCRecoveryDataStore() {
    }

    public static UserRecoveryDataStore getInstance() {
        return jdbcRecoveryDataStore;
    }

    @Override
    public void store(UserRecoveryData recoveryDataDO) throws IdentityRecoveryException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_RECOVERY_DATA (USER_NAME, USER_DOMAIN, TENANT_ID, CODE, SCENARIO,STEP, TIME_CREATED, REMAINING_SETS)VALUES (?,?,?,?,?,?,?,?)");
            prepStmt.setString(1, recoveryDataDO.getUser().getUserName());
            prepStmt.setString(2, recoveryDataDO.getUser().getUserStoreDomain().toUpperCase());
            prepStmt.setInt(3, IdentityTenantUtil.getTenantId((String)recoveryDataDO.getUser().getTenantDomain()));
            prepStmt.setString(4, recoveryDataDO.getSecret());
            prepStmt.setString(5, String.valueOf(recoveryDataDO.getRecoveryScenario()));
            prepStmt.setString(6, String.valueOf(recoveryDataDO.getRecoveryStep()));
            prepStmt.setTimestamp(7, new Timestamp(new Date().getTime()));
            prepStmt.setString(8, recoveryDataDO.getRemainingSetIds());
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_STORING_RECOVERY_DATA, null, e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    @Override
    public UserRecoveryData load(User user, Enum recoveryScenario, Enum recoveryStep, String code) throws IdentityRecoveryException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block6: {
            UserRecoveryData userRecoveryData;
            prepStmt = null;
            resultSet = null;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            try {
                String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "SELECT * FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND USER_DOMAIN = ? AND TENANT_ID = ? AND CODE = ? AND SCENARIO = ? AND STEP = ?" : "SELECT * FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND USER_DOMAIN = ? AND TENANT_ID = ? AND CODE= ? AND SCENARIO = ? AND STEP = ?";
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, user.getUserName());
                prepStmt.setString(2, user.getUserStoreDomain().toUpperCase());
                prepStmt.setInt(3, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
                prepStmt.setString(4, code);
                prepStmt.setString(5, String.valueOf(recoveryScenario));
                prepStmt.setString(6, String.valueOf(recoveryStep));
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block6;
                UserRecoveryData userRecoveryData2 = new UserRecoveryData(user, code, recoveryScenario, recoveryStep);
                if (StringUtils.isNotBlank((String)resultSet.getString("REMAINING_SETS"))) {
                    userRecoveryData2.setRemainingSetIds(resultSet.getString("REMAINING_SETS"));
                }
                Timestamp timeCreated = resultSet.getTimestamp("TIME_CREATED");
                long createdTimeStamp = timeCreated.getTime();
                String remainingSets = resultSet.getString("REMAINING_SETS");
                if (this.isCodeExpired(user.getTenantDomain(), recoveryScenario, recoveryStep, createdTimeStamp, remainingSets)) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_CODE, code);
                }
                userRecoveryData = userRecoveryData2;
            }
            catch (SQLException e) {
                try {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return userRecoveryData;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, code);
    }

    @Override
    public UserRecoveryData load(String code) throws IdentityRecoveryException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block6: {
            UserRecoveryData userRecoveryData;
            prepStmt = null;
            resultSet = null;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            try {
                String sql = "SELECT * FROM IDN_RECOVERY_DATA WHERE CODE = ?";
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, code);
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block6;
                User user = new User();
                user.setUserName(resultSet.getString("USER_NAME"));
                user.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)resultSet.getInt("TENANT_ID")));
                user.setUserStoreDomain(resultSet.getString("USER_DOMAIN"));
                RecoveryScenarios recoveryScenario = RecoveryScenarios.valueOf(resultSet.getString("SCENARIO"));
                RecoverySteps recoveryStep = RecoverySteps.valueOf(resultSet.getString("STEP"));
                UserRecoveryData userRecoveryData2 = new UserRecoveryData(user, code, recoveryScenario, recoveryStep);
                if (StringUtils.isNotBlank((String)resultSet.getString("REMAINING_SETS"))) {
                    userRecoveryData2.setRemainingSetIds(resultSet.getString("REMAINING_SETS"));
                }
                Timestamp timeCreated = resultSet.getTimestamp("TIME_CREATED");
                long createdTimeStamp = timeCreated.getTime();
                if (this.isCodeExpired(user.getTenantDomain(), userRecoveryData2.getRecoveryScenario(), userRecoveryData2.getRecoveryStep(), createdTimeStamp, userRecoveryData2.getRemainingSetIds())) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_CODE, code);
                }
                userRecoveryData = userRecoveryData2;
            }
            catch (SQLException e) {
                try {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return userRecoveryData;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, code);
    }

    @Override
    public void invalidate(String code) throws IdentityRecoveryException {
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        try {
            String sql = "DELETE FROM IDN_RECOVERY_DATA WHERE CODE = ?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, code);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    @Override
    public UserRecoveryData load(User user) throws IdentityRecoveryException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block6: {
            UserRecoveryData userRecoveryData;
            prepStmt = null;
            resultSet = null;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            try {
                String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "SELECT * FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND USER_DOMAIN = ? AND TENANT_ID = ? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')" : "SELECT * FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND USER_DOMAIN = ? AND TENANT_ID = ? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')";
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, user.getUserName());
                prepStmt.setString(2, user.getUserStoreDomain().toUpperCase());
                prepStmt.setInt(3, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block6;
                Timestamp timeCreated = resultSet.getTimestamp("TIME_CREATED");
                RecoveryScenarios scenario = RecoveryScenarios.valueOf(resultSet.getString("SCENARIO"));
                RecoverySteps step = RecoverySteps.valueOf(resultSet.getString("STEP"));
                String code = resultSet.getString("CODE");
                String remainingSets = resultSet.getString("REMAINING_SETS");
                if (this.isCodeExpired(user.getTenantDomain(), scenario, step, timeCreated.getTime(), remainingSets)) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_CODE, code);
                }
                UserRecoveryData userRecoveryData2 = new UserRecoveryData(user, code, scenario, step);
                if (StringUtils.isNotBlank((String)remainingSets)) {
                    userRecoveryData2.setRemainingSetIds(resultSet.getString("REMAINING_SETS"));
                }
                userRecoveryData = userRecoveryData2;
            }
            catch (SQLException e) {
                try {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return userRecoveryData;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return null;
    }

    @Override
    public UserRecoveryData loadWithoutCodeExpiryValidation(User user) throws IdentityRecoveryException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block5: {
            UserRecoveryData userRecoveryData;
            prepStmt = null;
            resultSet = null;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            try {
                String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "SELECT * FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND USER_DOMAIN = ? AND TENANT_ID = ? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')" : "SELECT * FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND USER_DOMAIN = ? AND TENANT_ID = ? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')";
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, user.getUserName());
                prepStmt.setString(2, user.getUserStoreDomain().toUpperCase());
                prepStmt.setInt(3, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block5;
                RecoveryScenarios scenario = RecoveryScenarios.valueOf(resultSet.getString("SCENARIO"));
                RecoverySteps step = RecoverySteps.valueOf(resultSet.getString("STEP"));
                String code = resultSet.getString("CODE");
                UserRecoveryData userRecoveryData2 = new UserRecoveryData(user, code, scenario, step);
                if (StringUtils.isNotBlank((String)resultSet.getString("REMAINING_SETS"))) {
                    userRecoveryData2.setRemainingSetIds(resultSet.getString("REMAINING_SETS"));
                }
                userRecoveryData = userRecoveryData2;
            }
            catch (SQLException e) {
                try {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return userRecoveryData;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return null;
    }

    @Override
    public UserRecoveryData loadWithoutCodeExpiryValidation(User user, Enum recoveryScenario) throws IdentityRecoveryException {
        Connection connection;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        block5: {
            UserRecoveryData userRecoveryData;
            prepStmt = null;
            resultSet = null;
            connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            try {
                String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "SELECT * FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND SCENARIO = ? AND USER_DOMAIN = ? AND TENANT_ID = ?" : "SELECT * FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND SCENARIO = ? AND USER_DOMAIN = ? AND TENANT_ID = ?";
                prepStmt = connection.prepareStatement(sql);
                prepStmt.setString(1, user.getUserName());
                prepStmt.setString(2, String.valueOf(recoveryScenario));
                prepStmt.setString(3, user.getUserStoreDomain().toUpperCase());
                prepStmt.setInt(4, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
                resultSet = prepStmt.executeQuery();
                if (!resultSet.next()) break block5;
                RecoveryScenarios scenario = RecoveryScenarios.valueOf(resultSet.getString("SCENARIO"));
                RecoverySteps step = RecoverySteps.valueOf(resultSet.getString("STEP"));
                String code = resultSet.getString("CODE");
                UserRecoveryData userRecoveryData2 = new UserRecoveryData(user, code, scenario, step);
                if (StringUtils.isNotBlank((String)resultSet.getString("REMAINING_SETS"))) {
                    userRecoveryData2.setRemainingSetIds(resultSet.getString("REMAINING_SETS"));
                }
                userRecoveryData = userRecoveryData2;
            }
            catch (SQLException e) {
                try {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
            return userRecoveryData;
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return null;
    }

    @Override
    public void invalidate(User user) throws IdentityRecoveryException {
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "DELETE FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND USER_DOMAIN = ? AND TENANT_ID =? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')" : "DELETE FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND USER_DOMAIN = ? AND TENANT_ID =? AND SCENARIO NOT IN ('EMAIL_VERIFICATION_ON_UPDATE', 'MOBILE_VERIFICATION_ON_UPDATE')";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, user.getUserName());
            prepStmt.setString(2, user.getUserStoreDomain());
            prepStmt.setInt(3, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    @Override
    public void invalidate(User user, Enum recoveryScenario, Enum recoveryStep) throws IdentityRecoveryException {
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        try {
            String sql = IdentityUtil.isUserStoreCaseSensitive((String)user.getUserStoreDomain(), (int)IdentityTenantUtil.getTenantId((String)user.getTenantDomain())) ? "DELETE FROM IDN_RECOVERY_DATA WHERE USER_NAME = ? AND SCENARIO = ? AND STEP = ? AND USER_DOMAIN = ? AND TENANT_ID =?" : "DELETE FROM IDN_RECOVERY_DATA WHERE LOWER(USER_NAME)=LOWER(?) AND SCENARIO = ? AND STEP = ? AND USER_DOMAIN = ? AND TENANT_ID =?";
            prepStmt = connection.prepareStatement(sql);
            prepStmt.setString(1, user.getUserName());
            prepStmt.setString(2, String.valueOf(recoveryScenario));
            prepStmt.setString(3, String.valueOf(recoveryStep));
            prepStmt.setString(4, user.getUserStoreDomain());
            prepStmt.setInt(5, IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    @Override
    public void deleteRecoveryDataByTenantId(int tenantId) throws IdentityRecoveryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting User Recovery Data of the tenant: " + tenantId));
        }
        PreparedStatement prepStmt = null;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            prepStmt = connection.prepareStatement("DELETE FROM IDN_RECOVERY_DATA WHERE TENANT_ID = ?");
            prepStmt.setInt(1, tenantId);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_DELETING_RECOVERY_DATA, Integer.toString(tenantId), e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    private boolean isCodeExpired(String tenantDomain, Enum recoveryScenario, Enum recoveryStep, long createdTimestamp, String recoveryData) throws IdentityRecoveryServerException {
        String message;
        int notificationExpiryTimeInMinutes = 0;
        if (RecoveryScenarios.SELF_SIGN_UP.equals(recoveryScenario) && RecoverySteps.CONFIRM_SIGN_UP.equals(recoveryStep)) {
            if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equalsIgnoreCase(recoveryData)) {
                if (log.isDebugEnabled()) {
                    message = String.format("Verification channel: %s was detected for recovery scenario: %s and recovery step: %s", recoveryData, recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("SelfRegistration.VerificationCode.ExpiryTime", tenantDomain));
            } else if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(recoveryData)) {
                if (log.isDebugEnabled()) {
                    message = String.format("Verification channel: %s was detected for recovery scenario: %s and recovery step: %s", recoveryData, recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("SelfRegistration.VerificationCode.SMSOTP.ExpiryTime", tenantDomain));
            } else {
                if (log.isDebugEnabled()) {
                    message = String.format("No verification channel for recovery scenario: %s and recovery step: %s .Therefore, using verification link default timeout configs", recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("SelfRegistration.VerificationCode.ExpiryTime", tenantDomain));
            }
        } else if (RecoveryScenarios.ASK_PASSWORD.equals(recoveryScenario)) {
            notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("EmailVerification.AskPassword.ExpiryTime", tenantDomain));
        } else if (RecoveryScenarios.USERNAME_RECOVERY.equals(recoveryScenario)) {
            notificationExpiryTimeInMinutes = this.getRecoveryCodeExpiryTime();
        } else if (RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY.equals(recoveryScenario)) {
            notificationExpiryTimeInMinutes = RecoverySteps.RESEND_CONFIRMATION_CODE.toString().equals(recoveryStep.toString()) ? this.getResendCodeExpiryTime() : (RecoverySteps.SEND_RECOVERY_INFORMATION.toString().equals(recoveryStep.toString()) ? this.getRecoveryCodeExpiryTime() : (NotificationChannels.SMS_CHANNEL.getChannelType().equals(recoveryData) ? Integer.parseInt(Utils.getRecoveryConfigs("Recovery.Notification.Password.ExpiryTime.smsOtp", tenantDomain)) : Integer.parseInt(Utils.getRecoveryConfigs("Recovery.ExpiryTime", tenantDomain))));
        } else if (RecoveryScenarios.EMAIL_VERIFICATION_ON_UPDATE.equals(recoveryScenario)) {
            notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("UserClaimUpdate.Email.VerificationCode.ExpiryTime", tenantDomain));
        } else if (RecoveryScenarios.TENANT_ADMIN_ASK_PASSWORD.equals(recoveryScenario)) {
            notificationExpiryTimeInMinutes = Integer.parseInt(IdentityUtil.getProperty((String)"TenantRegistrationVerification.AskPassword.ExpiryTime"));
        } else if (RecoveryScenarios.LITE_SIGN_UP.equals(recoveryScenario) && RecoverySteps.CONFIRM_LITE_SIGN_UP.equals(recoveryStep)) {
            if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equalsIgnoreCase(recoveryData)) {
                if (log.isDebugEnabled()) {
                    message = String.format("Verification channel: %s was detected for recovery scenario: %s and recovery step: %s", recoveryData, recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("LiteRegistration.VerificationCode.ExpiryTime", tenantDomain));
            } else if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(recoveryData)) {
                if (log.isDebugEnabled()) {
                    message = String.format("Verification channel: %s was detected for recovery scenario: %s and recovery step: %s", recoveryData, recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("LiteRegistration.VerificationCode.SMSOTP.ExpiryTime", tenantDomain));
            } else {
                if (log.isDebugEnabled()) {
                    message = String.format("No verification channel for recovery scenario: %s and recovery step: %s .Therefore, using verification link default timeout configs", recoveryScenario, recoveryStep);
                    log.debug((Object)message);
                }
                notificationExpiryTimeInMinutes = Integer.parseInt(Utils.getRecoveryConfigs("LiteRegistration.VerificationCode.ExpiryTime", tenantDomain));
            }
        } else {
            notificationExpiryTimeInMinutes = RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE.equals(recoveryScenario) ? Integer.parseInt(Utils.getRecoveryConfigs("UserClaimUpdate.MobileNumber.VerificationCode.ExpiryTime", tenantDomain)) : Integer.parseInt(Utils.getRecoveryConfigs("Recovery.ExpiryTime", tenantDomain));
        }
        if (notificationExpiryTimeInMinutes < 0) {
            notificationExpiryTimeInMinutes = Integer.MAX_VALUE;
        }
        long expiryTime = createdTimestamp + TimeUnit.MINUTES.toMillis(notificationExpiryTimeInMinutes);
        return System.currentTimeMillis() > expiryTime;
    }

    private int getRecoveryCodeExpiryTime() {
        String expiryTime = IdentityUtil.getProperty((String)"Recovery.Notification.ExpiryTime.RecoveryCode");
        if (StringUtils.isEmpty((String)expiryTime)) {
            return 1;
        }
        try {
            return Integer.parseInt(expiryTime);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                String message = String.format("User recovery code expired. Therefore setting DEFAULT expiry time : %s minutes", 1);
                log.debug((Object)message);
            }
            return 1;
        }
    }

    private int getResendCodeExpiryTime() {
        String expiryTime = IdentityUtil.getProperty((String)"Recovery.Notification.ExpiryTime.ResendCode");
        if (StringUtils.isEmpty((String)expiryTime)) {
            return 1;
        }
        try {
            return Integer.parseInt(expiryTime);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                String message = String.format("User recovery code expired. Therefore setting DEFAULT expiry time : %s minutes", 1);
                log.debug((Object)message);
            }
            return 1;
        }
    }
}

