/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.signup;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.slf4j.MDC;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.consent.mgt.exceptions.ConsentUtilityServiceException;
import org.wso2.carbon.identity.consent.mgt.services.ConsentUtilityService;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventClientException;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.IdentityEventServerException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityMgtConstants;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerClientException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannelManager;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.mgt.policy.PolicyViolationException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.bean.NotificationResponseBean;
import org.wso2.carbon.identity.recovery.confirmation.ResendConfirmationManager;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserSelfRegistrationManager {
    private static final Log log = LogFactory.getLog(UserSelfRegistrationManager.class);
    private static UserSelfRegistrationManager instance = new UserSelfRegistrationManager();
    private static final String PURPOSE_GROUP_SELF_REGISTER = "SELF-SIGNUP";
    private static final String PURPOSE_GROUP_TYPE_SYSTEM = "SYSTEM";

    private UserSelfRegistrationManager() {
    }

    public static UserSelfRegistrationManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResponseBean registerUser(User user, String password, Claim[] claims, org.wso2.carbon.identity.recovery.model.Property[] properties) throws IdentityRecoveryException {
        NotificationResponseBean notificationResponseBean;
        boolean enable;
        this.publishEvent(user, claims, properties, "PRE_SELF_SIGNUP_REGISTER");
        String consent = this.getPropertyValue(properties, "consent");
        String tenantDomain = user.getTenantDomain();
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        String callbackURL = null;
        try {
            callbackURL = Utils.getCallbackURLFromRegistration(properties);
            if (StringUtils.isNotBlank((String)callbackURL) && !Utils.validateCallbackURL(callbackURL, tenantDomain, "SelfRegistration.CallbackRegex")) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException | IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
        }
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            log.info((Object)("registerUser :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("registerUser :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (!(enable = Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.Enable", user.getTenantDomain())))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLE_SELF_SIGN_UP, user.getUserName());
        }
        try {
            String preferredChannel;
            UserStoreManager userStoreManager;
            RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
            try {
                userStoreManager = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)user.getTenantDomain())).getUserStoreManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, user.getUserName(), e);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            carbonContext.setTenantDomain(user.getTenantDomain());
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            for (Claim claim : claims) {
                claimsMap.put(claim.getClaimUri(), claim.getValue());
            }
            Utils.setArbitraryProperties(properties);
            this.validateAndFilterFromReceipt(consent, claimsMap);
            try {
                if (!userStoreManager.isExistingRole("Internal/selfsignup")) {
                    Permission permission = new Permission("/permission/admin/login", "ui.execute");
                    userStoreManager.addRole("Internal/selfsignup", null, (org.wso2.carbon.user.api.Permission[])new Permission[]{permission});
                }
                String[] userRoles = new String[]{"Internal/selfsignup"};
                try {
                    NotificationChannelManager notificationChannelManager = Utils.getNotificationChannelManager();
                    preferredChannel = notificationChannelManager.resolveCommunicationChannel(user.getUserName(), user.getTenantDomain(), user.getUserStoreDomain(), claimsMap);
                }
                catch (NotificationChannelManagerException e) {
                    throw this.mapNotificationChannelManagerException(e, user);
                }
                if (StringUtils.isEmpty((String)((String)claimsMap.get("http://wso2.org/claims/identity/preferredChannel"))) && StringUtils.isNotEmpty((String)preferredChannel)) {
                    claimsMap.put("http://wso2.org/claims/identity/preferredChannel", preferredChannel);
                }
                userStoreManager.addUser(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), (Object)password, userRoles, claimsMap, null);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof PolicyViolationException)) continue;
                    throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_POLICY_VIOLATION.getCode(), (String)cause.getMessage(), (Throwable)e);
                }
                Utils.checkPasswordPatternViolation(e, user);
                NotificationResponseBean notificationResponseBean2 = this.handleClientException(user, e);
                Utils.clearArbitraryProperties();
                PrivilegedCarbonContext.endTenantFlow();
                return notificationResponseBean2;
            }
            this.addUserConsent(consent, tenantDomain);
            notificationResponseBean = this.buildNotificationResponseBean(user, preferredChannel, claimsMap);
        }
        finally {
            Utils.clearArbitraryProperties();
            PrivilegedCarbonContext.endTenantFlow();
        }
        this.publishEvent(user, claims, properties, "POST_SELF_SIGNUP_REGISTER");
        return notificationResponseBean;
    }

    private NotificationResponseBean buildNotificationResponseBean(User user, String preferredChannel, Map<String, String> claimsMap) throws IdentityRecoveryException {
        boolean isAccountLockOnCreation = Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.LockOnCreation", user.getTenantDomain()));
        boolean isNotificationInternallyManage = Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.Notification.InternallyManage", user.getTenantDomain()));
        boolean preferredChannelVerified = this.isPreferredChannelVerified(user.getUserName(), preferredChannel, claimsMap);
        NotificationResponseBean notificationResponseBean = new NotificationResponseBean(user);
        if (preferredChannelVerified) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_WITH_VERIFIED_CHANNEL.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_WITH_VERIFIED_CHANNEL.getMessage());
        } else if (isNotificationInternallyManage && isAccountLockOnCreation) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_INTERNAL_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_INTERNAL_VERIFICATION.getMessage());
            notificationResponseBean.setNotificationChannel(preferredChannel);
        } else if (!isAccountLockOnCreation) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_UNLOCKED_WITH_NO_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_UNLOCKED_WITH_NO_VERIFICATION.getMessage());
        } else {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.invalidate(user);
            String secretKey = UUIDGenerator.generateUUID();
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.SELF_SIGN_UP, RecoverySteps.CONFIRM_SIGN_UP);
            recoveryDataDO.setRemainingSetIds(NotificationChannels.EXTERNAL_CHANNEL.getChannelType());
            userRecoveryDataStore.store(recoveryDataDO);
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_EXTERNAL_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_EXTERNAL_VERIFICATION.getMessage());
            notificationResponseBean.setRecoveryId(secretKey);
            notificationResponseBean.setNotificationChannel(NotificationChannels.EXTERNAL_CHANNEL.getChannelType());
            notificationResponseBean.setKey(secretKey);
        }
        return notificationResponseBean;
    }

    private NotificationResponseBean handleClientException(User user, org.wso2.carbon.user.api.UserStoreException e) throws IdentityRecoveryException {
        if (StringUtils.isEmpty((String)e.getMessage())) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ADD_SELF_USER, user.getUserName(), e);
        }
        if (e.getMessage().contains("31301")) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_POLICY_VIOLATED, user.getUserName(), e);
        }
        if (e.getMessage().contains("PasswordInvalidAsk")) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_POLICY_VIOLATED, "", e);
        }
        if (e.getMessage().contains("UserAlreadyExisting")) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_ALREADY_EXISTS, user.getUserName(), e);
        }
        if (e.getMessage().contains("Invalid Domain")) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DOMAIN_VIOLATED, user.getUserStoreDomain(), e);
        }
        throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ADD_SELF_USER, user.getUserName(), e);
    }

    private IdentityRecoveryException mapNotificationChannelManagerException(NotificationChannelManagerException e, User user) throws IdentityRecoveryException {
        if (StringUtils.isNotEmpty((String)e.getErrorCode()) && e.getErrorCode().equals(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CLAIM_MATCHED_FOR_PREFERRED_CHANNEL.getCode())) {
            return Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PREFERRED_CHANNEL_VALUE_EMPTY, user.getUserName(), e);
        }
        if (StringUtils.isNotEmpty((String)e.getErrorCode()) && e.getErrorCode().equals(IdentityMgtConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNEL.getCode())) {
            return Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNELS, user.getUserName(), e);
        }
        return Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_BAD_SELF_REGISTER_REQUEST, user.getUserName(), e);
    }

    private boolean isPreferredChannelVerified(String username, String notificationChannel, Map<String, String> claimsMap) throws IdentityRecoveryClientException {
        boolean isEnableAccountLockForVerifiedPreferredChannelEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"SelfRegistration.EnableAccountLockForVerifiedPreferredChannel"));
        if (!isEnableAccountLockForVerifiedPreferredChannelEnabled) {
            NotificationChannels channel = this.getNotificationChannel(username, notificationChannel);
            String verifiedClaimUri = channel.getVerifiedClaimUrl();
            String verifiedStatus = claimsMap.get(verifiedClaimUri);
            return StringUtils.isNotEmpty((String)verifiedStatus) && Boolean.parseBoolean(verifiedStatus);
        }
        return false;
    }

    private NotificationChannels getNotificationChannel(String username, String notificationChannel) throws IdentityRecoveryClientException {
        NotificationChannels channel;
        try {
            channel = NotificationChannels.getNotificationChannel((String)notificationChannel);
        }
        catch (NotificationChannelManagerClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported channel type : " + notificationChannel), (Throwable)e);
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNELS, username, e);
        }
        return channel;
    }

    public void addUserConsent(String consent, String tenantDomain) throws IdentityRecoveryServerException {
        if (StringUtils.isNotEmpty((String)consent)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Adding consent to tenant domain : %s : %s", tenantDomain, consent));
            }
            try {
                this.addConsent(consent, tenantDomain);
            }
            catch (ConsentManagementException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ADD_USER_CONSENT, "", e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Consent string is empty. Hence not adding consent");
        }
    }

    private void validateAndFilterFromReceipt(String consent, Map<String, String> claimsMap) throws IdentityRecoveryServerException {
        if (StringUtils.isEmpty((String)consent)) {
            return;
        }
        ConsentManager consentManager = IdentityRecoveryServiceDataHolder.getInstance().getConsentManager();
        try {
            List purposes = consentManager.listPurposes(PURPOSE_GROUP_SELF_REGISTER, PURPOSE_GROUP_TYPE_SYSTEM, 0, 0);
            Gson gson = new Gson();
            ReceiptInput receiptInput = (ReceiptInput)gson.fromJson(consent, ReceiptInput.class);
            this.validateUserConsent(receiptInput, purposes);
            this.filterClaimsFromReceipt(receiptInput, claimsMap);
        }
        catch (ConsentManagementException e) {
            throw new IdentityRecoveryServerException("Error while retrieving System purposes for self registration", e);
        }
    }

    private void validateUserConsent(ReceiptInput receiptInput, List<Purpose> purposes) throws IdentityRecoveryServerException {
        ConsentUtilityService consentUtilityService = IdentityRecoveryServiceDataHolder.getInstance().getConsentUtilityService();
        try {
            consentUtilityService.validateReceiptPIIs(receiptInput, purposes);
        }
        catch (ConsentUtilityServiceException e) {
            throw new IdentityRecoveryServerException("Receipt validation failed against purposes", e);
        }
    }

    private void filterClaimsFromReceipt(ReceiptInput receiptInput, Map<String, String> claims) throws IdentityRecoveryServerException {
        ConsentUtilityService consentUtilityService = IdentityRecoveryServiceDataHolder.getInstance().getConsentUtilityService();
        try {
            Set filteredKeys = consentUtilityService.filterPIIsFromReceipt(claims.keySet(), receiptInput);
            claims.keySet().retainAll(filteredKeys);
        }
        catch (ConsentUtilityServiceException e) {
            throw new IdentityRecoveryServerException("Receipt validation failed against purposes", e);
        }
    }

    public boolean isUserConfirmed(User user) throws IdentityRecoveryException {
        UserRecoveryDataStore userRecoveryDataStore;
        UserRecoveryData load;
        boolean isUserConfirmed = false;
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            log.info((Object)("confirmUserSelfRegistration :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("confirmUserSelfRegistration :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if ((load = (userRecoveryDataStore = JDBCRecoveryDataStore.getInstance()).loadWithoutCodeExpiryValidation(user)) == null || !RecoveryScenarios.SELF_SIGN_UP.equals(load.getRecoveryScenario())) {
            isUserConfirmed = true;
        }
        return isUserConfirmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmUserSelfRegistration(String code) throws IdentityRecoveryException {
        String userTenantDomain;
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData recoveryData = userRecoveryDataStore.load(code);
        User user = recoveryData.getUser();
        String contextTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!StringUtils.equalsIgnoreCase((String)contextTenantDomain, (String)(userTenantDomain = user.getTenantDomain()))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_TENANT, contextTenantDomain);
        }
        if (!RecoverySteps.CONFIRM_SIGN_UP.equals(recoveryData.getRecoveryStep()) && !RecoverySteps.CONFIRM_LITE_SIGN_UP.equals(recoveryData.getRecoveryStep())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, null);
        }
        try {
            UserStoreManager userStoreManager;
            RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
            try {
                userStoreManager = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)user.getTenantDomain())).getUserStoreManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, user.getUserName(), e);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            carbonContext.setTenantDomain(user.getTenantDomain());
            HashMap<String, String> userClaims = new HashMap<String, String>();
            userClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.FALSE.toString());
            userClaims.put("http://wso2.org/claims/identity/emailVerified", Boolean.TRUE.toString());
            try {
                userStoreManager.setUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), userClaims, null);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNLOCK_USER_USER, user.getUserName(), e);
            }
            userRecoveryDataStore.invalidate(code);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void confirmUserSelfRegistration(String code, String verifiedChannelType, String verifiedChannelClaim, Map<String, String> properties) throws IdentityRecoveryException {
        this.publishEvent(code, verifiedChannelType, verifiedChannelClaim, properties, "PRE_SELF_SIGNUP_CONFIRM");
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData userRecoveryData = this.validateSelfRegistrationCode(code, verifiedChannelType, verifiedChannelClaim, properties);
        User user = userRecoveryData.getUser();
        userRecoveryDataStore.invalidate(code);
        boolean isSelfRegistrationConfirmationNotify = false;
        isSelfRegistrationConfirmationNotify = Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.NotifyAccountConfirmation", user.getTenantDomain()));
        if (isSelfRegistrationConfirmationNotify) {
            this.triggerNotification(user);
        }
        this.publishEvent(user, code, verifiedChannelType, verifiedChannelClaim, properties, "POST_SELF_SIGNUP_CONFIRM");
    }

    public UserRecoveryData introspectUserSelfRegistration(String code, String verifiedChannelType, String verifiedChannelClaim, Map<String, String> properties) throws IdentityRecoveryException {
        return this.validateSelfRegistrationCode(code, verifiedChannelType, verifiedChannelClaim, properties);
    }

    private UserRecoveryData validateSelfRegistrationCode(String code, String verifiedChannelType, String verifiedChannelClaim, Map<String, String> properties) throws IdentityRecoveryException {
        String pendingEmailClaimValue;
        Utils.unsetThreadLocalToSkipSendingEmailVerificationOnUpdate();
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData recoveryData = userRecoveryDataStore.load(code);
        User user = recoveryData.getUser();
        this.validateContextTenantDomainWithUserTenantDomain(user);
        if (!(RecoverySteps.CONFIRM_SIGN_UP.equals(recoveryData.getRecoveryStep()) || RecoverySteps.VERIFY_EMAIL.equals(recoveryData.getRecoveryStep()) || RecoverySteps.CONFIRM_LITE_SIGN_UP.equals(recoveryData.getRecoveryStep()))) {
            this.auditRecoveryConfirm(recoveryData, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE.getMessage(), "Failed");
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, null);
        }
        UserStoreManager userStoreManager = this.getUserStoreManager(user);
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("USER", user);
        eventProperties.put("userStoreManager", userStoreManager);
        if (RecoverySteps.CONFIRM_SIGN_UP.equals(recoveryData.getRecoveryStep())) {
            this.triggerEvent(eventProperties, "PRE_USER_ACCOUNT_CONFIRMATION");
        } else if (RecoverySteps.VERIFY_EMAIL.equals(recoveryData.getRecoveryStep())) {
            this.triggerEvent(eventProperties, "PRE_EMAIL_CHANGE_VERIFICATION");
        }
        String externallyVerifiedClaim = null;
        if (!NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(verifiedChannelType)) {
            externallyVerifiedClaim = this.getChannelVerifiedClaim(recoveryData.getUser().getUserName(), verifiedChannelType, verifiedChannelClaim);
        }
        HashMap<String, String> userClaims = this.getClaimsListToUpdate(user, recoveryData.getRemainingSetIds(), externallyVerifiedClaim, recoveryData.getRecoveryScenario().toString());
        if (RecoverySteps.VERIFY_EMAIL.equals(recoveryData.getRecoveryStep()) && StringUtils.isNotBlank((String)(pendingEmailClaimValue = recoveryData.getRemainingSetIds()))) {
            eventProperties.put("VERIFIED_EMAIL", pendingEmailClaimValue);
            userClaims.put("http://wso2.org/claims/identity/emailaddress.pendingValue", "");
            userClaims.put("http://wso2.org/claims/emailaddress", pendingEmailClaimValue);
            Utils.setThreadLocalToSkipSendingEmailVerificationOnUpdate(IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString());
        }
        this.updateUserClaims(userStoreManager, user, userClaims);
        if (RecoverySteps.CONFIRM_SIGN_UP.equals(recoveryData.getRecoveryStep())) {
            String verifiedChannelURI = this.extractVerifiedChannelURI(userClaims, verifiedChannelClaim);
            eventProperties.put("VERIFIED_CHANNEL", verifiedChannelURI);
            this.triggerEvent(eventProperties, "POST_USER_ACCOUNT_CONFIRMATION");
        } else if (RecoverySteps.VERIFY_EMAIL.equals(recoveryData.getRecoveryStep())) {
            this.triggerEvent(eventProperties, "POST_EMAIL_CHANGE_VERIFICATION");
        }
        this.auditRecoveryConfirm(recoveryData, null, "Success");
        return recoveryData;
    }

    private String extractVerifiedChannelURI(HashMap<String, String> userClaims, String externallyVerifiedClaim) {
        String verifiedChannelURI = null;
        for (Map.Entry<String, String> entry : userClaims.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(externallyVerifiedClaim) && !key.equals("http://wso2.org/claims/identity/emailVerified") && !key.equals(NotificationChannels.SMS_CHANNEL.getVerifiedClaimUrl())) continue;
            verifiedChannelURI = key;
            break;
        }
        return verifiedChannelURI;
    }

    private void triggerEvent(Map<String, Object> properties, String eventName) throws IdentityRecoveryServerException, IdentityRecoveryClientException {
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventClientException e) {
            throw new IdentityRecoveryClientException(e.getErrorCode(), e.getMessage(), e);
        }
        catch (IdentityEventServerException e) {
            throw new IdentityRecoveryServerException(e.getErrorCode(), e.getMessage(), e);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PUBLISH_EVENT, eventName, e);
        }
    }

    public void confirmVerificationCodeMe(String code, Map<String, String> properties) throws IdentityRecoveryException {
        String pendingMobileNumberClaimValue;
        Utils.unsetThreadLocalToSkipSendingSmsOtpVerificationOnUpdate();
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData recoveryData = userRecoveryDataStore.load(code);
        if (!RecoverySteps.VERIFY_MOBILE_NUMBER.equals(recoveryData.getRecoveryStep())) {
            this.auditRecoveryConfirm(recoveryData, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE.getMessage(), "Failed");
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, null);
        }
        User user = recoveryData.getUser();
        this.validateUser(user);
        UserStoreManager userStoreManager = this.getUserStoreManager(user);
        HashMap<String, String> userClaims = new HashMap<String, String>();
        if (RecoverySteps.VERIFY_MOBILE_NUMBER.equals(recoveryData.getRecoveryStep()) && StringUtils.isNotBlank((String)(pendingMobileNumberClaimValue = recoveryData.getRemainingSetIds()))) {
            userClaims.put("http://wso2.org/claims/identity/mobileNumber.pendingValue", "");
            userClaims.put("http://wso2.org/claims/mobile", pendingMobileNumberClaimValue);
            userClaims.put(NotificationChannels.SMS_CHANNEL.getVerifiedClaimUrl(), Boolean.TRUE.toString());
            Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString());
        }
        this.updateUserClaims(userStoreManager, user, userClaims);
        userRecoveryDataStore.invalidate(code);
        this.auditRecoveryConfirm(recoveryData, null, "Success");
    }

    private void updateUserClaims(UserStoreManager userStoreManager, User user, HashMap<String, String> userClaims) throws IdentityRecoveryException {
        try {
            userStoreManager.setUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), userClaims, null);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNLOCK_USER_USER, user.getUserName(), e);
        }
    }

    private String getChannelVerifiedClaim(String username, String verifiedChannelType, String verifiedChannelClaim) throws IdentityRecoveryException {
        if (StringUtils.isNotEmpty((String)verifiedChannelType) && StringUtils.isNotEmpty((String)verifiedChannelClaim)) {
            NotificationChannels channel = this.getNotificationChannel(username, verifiedChannelType);
            String channelClaim = channel.getClaimUri();
            if (channelClaim.equals(verifiedChannelClaim)) {
                return channel.getVerifiedClaimUrl();
            }
            if (log.isDebugEnabled()) {
                String error = String.format("Channel claim: %s in the request does not match the channel claim bound to channelType : %s", verifiedChannelType, verifiedChannelType);
                log.debug((Object)error);
            }
            throw new IdentityRecoveryException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_VERIFICATION_CHANNEL.getMessage(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_VERIFICATION_CHANNEL.getCode());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Externally verified channels are not specified");
        }
        return null;
    }

    private HashMap<String, String> getClaimsListToUpdate(User user, String verificationChannel, String externallyVerifiedChannelClaim, String recoveryScenario) {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.FALSE.toString());
        this.setVerificationClaims(user, verificationChannel, externallyVerifiedChannelClaim, recoveryScenario, userClaims);
        userClaims.put("http://wso2.org/claims/identity/accountConfirmedTime", Instant.now().toString());
        return userClaims;
    }

    private UserStoreManager getUserStoreManager(User user) throws IdentityRecoveryException {
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            UserRealm tenantUserRealm = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            if (IdentityUtil.getPrimaryDomainName().equals(user.getUserStoreDomain())) {
                return tenantUserRealm.getUserStoreManager();
            }
            return ((org.wso2.carbon.user.core.UserStoreManager)tenantUserRealm.getUserStoreManager()).getSecondaryUserStoreManager(user.getUserStoreDomain());
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            if (log.isDebugEnabled()) {
                String message = String.format("Error getting the user store manager for the user : %s with in domain : %s.", user.getUserStoreDomain() + CarbonConstants.DOMAIN_SEPARATOR + user.getUserName(), user.getTenantDomain());
                log.debug((Object)message);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, user.getUserName(), e);
        }
    }

    private void validateUser(User user) throws IdentityRecoveryException {
        this.validateContextTenantDomainWithUserTenantDomain(user);
        String contextUsername = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        String username = user.getUserName();
        if (!StringUtils.equalsIgnoreCase((String)contextUsername, (String)username)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USER, contextUsername);
        }
    }

    private void validateContextTenantDomainWithUserTenantDomain(User user) throws IdentityRecoveryException {
        String userTenantDomain;
        String contextTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!StringUtils.equalsIgnoreCase((String)contextTenantDomain, (String)(userTenantDomain = user.getTenantDomain()))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_TENANT, contextTenantDomain);
        }
    }

    private void setVerificationClaims(User user, String verificationChannel, String externallyVerifiedChannelClaim, String recoveryScenario, HashMap<String, String> userClaims) {
        if (NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(verificationChannel)) {
            if (StringUtils.isNotEmpty((String)externallyVerifiedChannelClaim)) {
                if (log.isDebugEnabled()) {
                    String message = String.format("Externally verified claim is available for user :%s in tenant domain : %s ", user.getUserName(), user.getTenantDomain());
                    log.debug((Object)message);
                }
                userClaims.put(externallyVerifiedChannelClaim, Boolean.TRUE.toString());
            } else {
                if (log.isDebugEnabled()) {
                    String message = String.format("Externally verified channel claims are not available for user : %s in tenant domain : %s. Therefore, setting %s claim as the default verified channel.", user.getUserName(), user.getTenantDomain(), NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl());
                    log.debug((Object)message);
                }
                userClaims.put("http://wso2.org/claims/identity/emailVerified", Boolean.TRUE.toString());
            }
        } else if (NotificationChannels.SMS_CHANNEL.getChannelType().equalsIgnoreCase(verificationChannel)) {
            if (log.isDebugEnabled()) {
                String message = String.format("Self sign-up via SMS channel detected. Updating %s value for user : %s in tenant domain : %s ", NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl(), user.getUserName(), user.getTenantDomain());
                log.debug((Object)message);
            }
            userClaims.put(NotificationChannels.SMS_CHANNEL.getVerifiedClaimUrl(), Boolean.TRUE.toString());
        } else if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equalsIgnoreCase(verificationChannel)) {
            if (log.isDebugEnabled()) {
                String message = String.format("Self sign-up via EMAIL channel detected. Updating %s value for user : %s in tenant domain : %s ", NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl(), user.getUserName(), user.getTenantDomain());
                log.debug((Object)message);
            }
            userClaims.put("http://wso2.org/claims/identity/emailVerified", Boolean.TRUE.toString());
        } else {
            if (log.isDebugEnabled()) {
                String message = String.format("No notification channel detected for user : %s in tenant domain : %s for recovery scenario : %s. Therefore setting email as the verified channel.", user.getUserName(), user.getTenantDomain(), recoveryScenario);
                log.debug((Object)message);
            }
            userClaims.put("http://wso2.org/claims/identity/emailVerified", Boolean.TRUE.toString());
        }
    }

    @Deprecated
    public NotificationResponseBean resendConfirmationCode(User user, org.wso2.carbon.identity.recovery.model.Property[] properties) throws IdentityRecoveryException {
        boolean selfRegistrationEnabled;
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (StringUtils.isBlank((String)tenantDomain)) {
                tenantDomain = "carbon.super";
            }
            user.setTenantDomain(tenantDomain);
            log.info((Object)("confirmUserSelfRegistration :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("confirmUserSelfRegistration :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (!(selfRegistrationEnabled = Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.Enable", user.getTenantDomain())))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLE_SELF_SIGN_UP, user.getUserName());
        }
        ResendConfirmationManager resendConfirmationManager = ResendConfirmationManager.getInstance();
        NotificationResponseBean notificationResponseBean = resendConfirmationManager.resendConfirmationCode(user, RecoveryScenarios.SELF_SIGN_UP.toString(), RecoverySteps.CONFIRM_SIGN_UP.toString(), "resendaccountconfirmation", properties);
        notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_RESEND_CONFIRMATION_CODE.getCode());
        notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_RESEND_CONFIRMATION_CODE.getMessage());
        return notificationResponseBean;
    }

    public boolean isValidTenantDomain(String tenantDomain) throws IdentityRecoveryException {
        boolean isValidTenant = false;
        try {
            org.wso2.carbon.user.core.UserRealm userRealm = this.getUserRealm(tenantDomain);
            isValidTenant = userRealm != null;
        }
        catch (CarbonException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting user realm for user " + tenantDomain));
            }
            throw new IdentityRecoveryException("Error while retrieving user realm for tenant : " + tenantDomain, e);
        }
        return isValidTenant;
    }

    @Deprecated
    public boolean isUsernameAlreadyTaken(String username) throws IdentityRecoveryException {
        return this.isUsernameAlreadyTaken(username, null);
    }

    public boolean isUsernameAlreadyTaken(String username, String tenantDomain) throws IdentityRecoveryException {
        boolean isUsernameAlreadyTaken = true;
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        }
        try {
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            org.wso2.carbon.user.core.UserRealm userRealm = this.getUserRealm(tenantDomain);
            if (userRealm != null) {
                isUsernameAlreadyTaken = userRealm.getUserStoreManager().isExistingUser(tenantAwareUsername);
            }
        }
        catch (CarbonException | UserStoreException e) {
            throw new IdentityRecoveryException("Error while retrieving user realm for tenant : " + tenantDomain, e);
        }
        return isUsernameAlreadyTaken;
    }

    public boolean isSelfRegistrationEnabled(String tenantDomain) throws IdentityRecoveryException {
        String selfSignUpEnabled = this.getIDPProperty(tenantDomain, "SelfRegistration.Enable");
        return Boolean.parseBoolean(selfSignUpEnabled);
    }

    private String getIDPProperty(String tenantDomain, String propertyName) throws IdentityRecoveryException {
        String propertyValue = "";
        try {
            Property[] configuration;
            for (Property configProperty : configuration = IdentityRecoveryServiceDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(new String[]{"SelfRegistration.Enable"}, tenantDomain)) {
                if (configProperty == null || !propertyName.equalsIgnoreCase(configProperty.getName())) continue;
                propertyValue = configProperty.getValue();
            }
        }
        catch (IdentityGovernanceException e) {
            throw new IdentityRecoveryException("Error while retrieving resident identity provider for tenant : " + tenantDomain, e);
        }
        return propertyValue;
    }

    private void addConsent(String consent, String tenantDomain) throws ConsentManagementException, IdentityRecoveryServerException {
        Gson gson = new Gson();
        ReceiptInput receiptInput = (ReceiptInput)gson.fromJson(consent, ReceiptInput.class);
        ConsentManager consentManager = IdentityRecoveryServiceDataHolder.getInstance().getConsentManager();
        if (receiptInput.getServices().size() < 0) {
            throw new IdentityRecoveryServerException("A service should be available in a receipt");
        }
        ReceiptServiceInput receiptServiceInput = (ReceiptServiceInput)receiptInput.getServices().get(0);
        if (receiptServiceInput.getPurposes().isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Consent does not contain any purposes. Hence not adding consent");
            }
            return;
        }
        receiptServiceInput.setTenantDomain(tenantDomain);
        try {
            this.setIDPData(tenantDomain, receiptServiceInput);
        }
        catch (IdentityProviderManagementException e) {
            throw new ConsentManagementException("Error while retrieving identity provider data", "Error while setting IDP data", (Throwable)e);
        }
        receiptInput.setTenantDomain(tenantDomain);
        consentManager.addConsent(receiptInput);
    }

    private void setIDPData(String tenantDomain, ReceiptServiceInput receiptServiceInput) throws IdentityProviderManagementException {
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        IdentityProvider residentIdP = idpManager.getResidentIdP(tenantDomain);
        if (StringUtils.isEmpty((String)receiptServiceInput.getService())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No service name found. Hence adding resident IDP home realm ID");
            }
            receiptServiceInput.setService(residentIdP.getHomeRealmId());
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getTenantDomain())) {
            receiptServiceInput.setTenantDomain(tenantDomain);
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getSpDescription())) {
            if (StringUtils.isNotEmpty((String)residentIdP.getIdentityProviderDescription())) {
                receiptServiceInput.setSpDescription(residentIdP.getIdentityProviderDescription());
            } else {
                receiptServiceInput.setSpDescription("Resident IDP");
            }
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getSpDisplayName())) {
            if (StringUtils.isNotEmpty((String)residentIdP.getDisplayName())) {
                receiptServiceInput.setSpDisplayName(residentIdP.getDisplayName());
            } else {
                receiptServiceInput.setSpDisplayName("Resident IDP");
            }
        }
    }

    private String getPropertyValue(org.wso2.carbon.identity.recovery.model.Property[] properties, String key) {
        String propertyValue = "";
        if (properties != null && StringUtils.isNotEmpty((String)key)) {
            for (int index = 0; index < properties.length; ++index) {
                org.wso2.carbon.identity.recovery.model.Property property = properties[index];
                if (!key.equalsIgnoreCase(property.getKey())) continue;
                propertyValue = property.getValue();
                ArrayUtils.removeElement((Object[])properties, (Object)property);
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning value for key : " + key + " - " + propertyValue));
        }
        return propertyValue;
    }

    private org.wso2.carbon.user.core.UserRealm getUserRealm(String tenantDomain) throws CarbonException {
        return AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)IdentityRecoveryServiceDataHolder.getInstance().getRegistryService(), (RealmService)IdentityRecoveryServiceDataHolder.getInstance().getRealmService(), (String)tenantDomain);
    }

    public boolean isMatchUserNameRegex(String tenantDomain, String username) throws IdentityRecoveryException {
        boolean isValidUsername;
        String userDomain = IdentityUtil.extractDomainFromName((String)username);
        try {
            org.wso2.carbon.user.core.UserRealm userRealm = this.getUserRealm(tenantDomain);
            RealmConfiguration realmConfiguration = userRealm.getUserStoreManager().getSecondaryUserStoreManager(userDomain).getRealmConfiguration();
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            String userStoreDomainAwareUsername = UserCoreUtil.removeDomainFromName((String)tenantAwareUsername);
            isValidUsername = this.checkUserNameValid(userStoreDomainAwareUsername, realmConfiguration);
        }
        catch (CarbonException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting user realm for user " + tenantDomain));
            }
            throw new IdentityRecoveryException("Error while retrieving user realm for tenant : " + tenantDomain, e);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while getting user store configuration for tenant: " + tenantDomain + ", domain: " + userDomain));
            }
            throw new IdentityRecoveryException("Error while retrieving user store configuration for: " + userDomain, e);
        }
        return isValidUsername;
    }

    private boolean checkUserNameValid(String userName, RealmConfiguration realmConfig) {
        if (userName == null || "wso2.system.user".equals(userName)) {
            return false;
        }
        if ((userName = userName.trim()).length() < 1) {
            return false;
        }
        String regularExpression = realmConfig.getUserStoreProperty("UsernameJavaRegEx");
        if (MultitenantUtils.isEmailUserName() && (regularExpression = realmConfig.getUserStoreProperty("UsernameWithEmailJavaScriptRegEx")) == null) {
            regularExpression = "^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
        }
        if (regularExpression != null) {
            regularExpression = regularExpression.trim();
        }
        return StringUtils.isEmpty((String)regularExpression) || this.isFormatCorrect(regularExpression, userName);
    }

    private boolean isFormatCorrect(String regularExpression, String attribute) {
        Pattern p2 = Pattern.compile(regularExpression);
        Matcher m2 = p2.matcher(attribute);
        return m2.matches();
    }

    public void preValidatePasswordWithConfirmationKey(String confirmationKey, String password) throws IdentityEventException, IdentityRecoveryException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData recoveryData = userRecoveryDataStore.load(confirmationKey);
        User user = recoveryData.getUser();
        String userStoreDomain = user.getUserStoreDomain();
        String username = user.getUserName();
        this.preValidatePassword(username, password, userStoreDomain);
    }

    public void preValidatePasswordWithUsername(String username, String password) throws IdentityEventException, IdentityRecoveryServerException {
        String userStoreDomain = IdentityUtil.extractDomainFromName((String)username);
        username = UserCoreUtil.removeDomainFromName((String)username);
        this.preValidatePassword(username, password, userStoreDomain);
    }

    private void preValidatePassword(String username, String password, String userStoreDomain) throws IdentityRecoveryServerException, IdentityEventException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String eventName = "PRE_UPDATE_CREDENTIAL_BY_ADMIN";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user-name", username);
        properties.put("CREDENTIAL", password);
        properties.put("tenant-domain", tenantDomain);
        properties.put("tenantId", tenantId);
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            org.wso2.carbon.user.core.UserStoreManager secondaryUserStoreManager = userStoreManager.getSecondaryUserStoreManager(userStoreDomain);
            properties.put("userStoreManager", secondaryUserStoreManager);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String message = String.format("Error getting the user store manager for the user : %s in domain : %s.", userStoreDomain + CarbonConstants.DOMAIN_SEPARATOR + username, tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validating password against policies for user: %s in tenant: %s and in user store: %s", username, tenantDomain, userStoreDomain));
        }
        Event identityMgtEvent = new Event(eventName, properties);
        IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResponseBean registerLiteUser(User user, Claim[] claims, org.wso2.carbon.identity.recovery.model.Property[] properties) throws IdentityRecoveryException {
        NotificationResponseBean notificationResponseBean;
        boolean enable;
        String consent = this.getPropertyValue(properties, "consent");
        String tenantDomain = user.getTenantDomain();
        if (StringUtils.isEmpty((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        String callbackURL = null;
        try {
            callbackURL = Utils.getCallbackURLFromRegistration(properties);
            if (StringUtils.isNotBlank((String)callbackURL) && !Utils.validateCallbackURL(callbackURL, tenantDomain, "SelfRegistration.CallbackRegex")) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException | IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
        }
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            log.info((Object)("registerUser :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("registerUser :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (!(enable = Boolean.parseBoolean(Utils.getSignUpConfigs("LiteRegistration.Enable", user.getTenantDomain())))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLE_LITE_SIGN_UP, user.getUserName());
        }
        try {
            String preferredChannel;
            UserStoreManager userStoreManager;
            RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
            try {
                userStoreManager = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)user.getTenantDomain())).getUserStoreManager();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, user.getUserName(), e);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            carbonContext.setTenantDomain(user.getTenantDomain());
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            for (Claim claim : claims) {
                claimsMap.put(claim.getClaimUri(), claim.getValue());
            }
            claimsMap.put("http://wso2.org/claims/identity/isLiteUser", Boolean.TRUE.toString());
            Utils.setArbitraryProperties(properties);
            this.validateAndFilterFromReceipt(consent, claimsMap);
            try {
                String[] userRoles = new String[]{};
                try {
                    NotificationChannelManager notificationChannelManager = Utils.getNotificationChannelManager();
                    preferredChannel = notificationChannelManager.resolveCommunicationChannel(user.getUserName(), user.getTenantDomain(), user.getUserStoreDomain(), claimsMap);
                }
                catch (NotificationChannelManagerException e) {
                    throw this.mapNotificationChannelManagerException(e, user);
                }
                if (StringUtils.isEmpty((String)((String)claimsMap.get("http://wso2.org/claims/identity/preferredChannel"))) && StringUtils.isNotEmpty((String)preferredChannel)) {
                    claimsMap.put("http://wso2.org/claims/identity/preferredChannel", preferredChannel);
                }
                userStoreManager.addUser(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), (Object)this.getRandomPassword(), userRoles, claimsMap, null);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof PolicyViolationException)) continue;
                    throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_POLICY_VIOLATION.getCode(), (String)cause.getMessage(), (Throwable)e);
                }
                NotificationResponseBean notificationResponseBean2 = this.handleClientException(user, e);
                Utils.clearArbitraryProperties();
                PrivilegedCarbonContext.endTenantFlow();
                return notificationResponseBean2;
            }
            this.addUserConsent(consent, tenantDomain);
            notificationResponseBean = this.buildLiteNotificationResponseBean(user, preferredChannel, claimsMap);
        }
        finally {
            Utils.clearArbitraryProperties();
            PrivilegedCarbonContext.endTenantFlow();
        }
        return notificationResponseBean;
    }

    private char[] getRandomPassword() {
        SecureRandom random = new SecureRandom();
        byte[] seed = random.generateSeed(20);
        return (seed + "A$g0").toCharArray();
    }

    private NotificationResponseBean buildLiteNotificationResponseBean(User user, String preferredChannel, Map<String, String> claimsMap) throws IdentityRecoveryException {
        boolean isAccountLockOnCreation = Boolean.parseBoolean(Utils.getSignUpConfigs("LiteRegistration.LockOnCreation", user.getTenantDomain()));
        boolean isNotificationInternallyManage = Boolean.parseBoolean(Utils.getSignUpConfigs("LiteRegistration.Notification.InternallyManage", user.getTenantDomain()));
        boolean preferredChannelVerified = this.isPreferredChannelVerified(user.getUserName(), preferredChannel, claimsMap);
        NotificationResponseBean notificationResponseBean = new NotificationResponseBean(user);
        if (preferredChannelVerified) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_WITH_VERIFIED_CHANNEL.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_WITH_VERIFIED_CHANNEL.getMessage());
        } else if (isNotificationInternallyManage && isAccountLockOnCreation) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_INTERNAL_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_INTERNAL_VERIFICATION.getMessage());
            notificationResponseBean.setNotificationChannel(preferredChannel);
        } else if (!isAccountLockOnCreation) {
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_UNLOCKED_WITH_NO_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_UNLOCKED_WITH_NO_VERIFICATION.getMessage());
        } else {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.invalidate(user);
            String secretKey = UUIDGenerator.generateUUID();
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.LITE_SIGN_UP, RecoverySteps.CONFIRM_LITE_SIGN_UP);
            recoveryDataDO.setRemainingSetIds(NotificationChannels.EXTERNAL_CHANNEL.getChannelType());
            userRecoveryDataStore.store(recoveryDataDO);
            notificationResponseBean.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_EXTERNAL_VERIFICATION.getCode());
            notificationResponseBean.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_USER_CREATION_EXTERNAL_VERIFICATION.getMessage());
            notificationResponseBean.setRecoveryId(secretKey);
            notificationResponseBean.setNotificationChannel(NotificationChannels.EXTERNAL_CHANNEL.getChannelType());
            notificationResponseBean.setKey(secretKey);
        }
        return notificationResponseBean;
    }

    private void auditRecoveryConfirm(UserRecoveryData recoveryData, String errorMsg, String result) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("RemoteAddress", (Object)MDC.get((String)"remoteAddress"));
        dataObject.put("User Agent", (Object)MDC.get((String)"User-Agent"));
        dataObject.put("Email To be Changed", (Object)recoveryData.getRemainingSetIds());
        dataObject.put("ServiceProviderName", (Object)MDC.get((String)"serviceProvider"));
        if ("Failed".equals(result)) {
            dataObject.put("Error Message", (Object)errorMsg);
        }
        Utils.createAuditMessage(recoveryData.getRecoveryScenario().toString(), recoveryData.getUser().getUserName(), dataObject, result);
    }

    private void triggerNotification(User user) throws IdentityRecoveryServerException {
        String eventName = "TRIGGER_NOTIFICATION";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("TEMPLATE_TYPE", "selfSignUpSuccess");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yy hh:mm:ss");
        String selfSignUpConfirmationTime = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        properties.put("selfsignup-confirm-time", selfSignUpConfirmationTime);
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private void publishEvent(User user, Claim[] claims, org.wso2.carbon.identity.recovery.model.Property[] metaProperties, String eventName) throws IdentityRecoveryException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("USER_CLAIMS", claims);
        if (metaProperties != null) {
            for (org.wso2.carbon.identity.recovery.model.Property metaProperty : metaProperties) {
                if (!StringUtils.isNotBlank((String)metaProperty.getValue()) || !StringUtils.isNotBlank((String)metaProperty.getKey())) continue;
                properties.put(metaProperty.getKey(), metaProperty.getValue());
            }
        }
        this.handleEvent(eventName, properties, user);
    }

    private void publishEvent(User user, String code, String verifiedChannelType, String verifiedChannelClaim, Map<String, String> metaProperties, String eventName) throws IdentityRecoveryException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("selfsignup-code", code);
        }
        if (StringUtils.isNotBlank((String)verifiedChannelType)) {
            properties.put("selfsignup-verify-channel", verifiedChannelType);
        }
        if (StringUtils.isNotBlank((String)verifiedChannelClaim)) {
            properties.put("selfsignup-verify-channel-claim", verifiedChannelClaim);
        }
        if (metaProperties != null) {
            for (Map.Entry<String, String> entry : metaProperties.entrySet()) {
                if (!StringUtils.isNotBlank((String)entry.getValue()) || !StringUtils.isNotBlank((String)entry.getKey())) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        this.handleEvent(eventName, properties, user);
    }

    private void publishEvent(String code, String verifiedChannelType, String verifiedChannelClaim, Map<String, String> metaProperties, String eventName) throws IdentityRecoveryException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("selfsignup-code", code);
        }
        if (StringUtils.isNotBlank((String)verifiedChannelType)) {
            properties.put("selfsignup-verify-channel", verifiedChannelType);
        }
        if (StringUtils.isNotBlank((String)verifiedChannelClaim)) {
            properties.put("selfsignup-verify-channel-claim", verifiedChannelClaim);
        }
        if (metaProperties != null) {
            for (Map.Entry<String, String> entry : metaProperties.entrySet()) {
                if (!StringUtils.isNotBlank((String)entry.getValue()) || !StringUtils.isNotBlank((String)entry.getKey())) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            log.error((Object)("Error occurred while publishing event " + eventName));
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PUBLISH_EVENT, eventName, e);
        }
    }

    private void handleEvent(String eventName, HashMap<String, Object> properties, User user) throws IdentityRecoveryServerException {
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PUBLISH_EVENT, eventName, e);
        }
    }
}

