/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.services;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.model.UserChallengeAnswer;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ChallengeQuestionManagementAdminService {
    private static final Log log = LogFactory.getLog(ChallengeQuestionManagementAdminService.class);
    private ChallengeQuestionManager questionManager = ChallengeQuestionManager.getInstance();

    public ChallengeQuestion[] getChallengeQuestionsOfTenant(String tenantDomain) throws IdentityRecoveryException {
        this.checkCrossTenantAccess(tenantDomain);
        try {
            List<ChallengeQuestion> challengeQuestionList = this.questionManager.getAllChallengeQuestions(tenantDomain);
            return challengeQuestionList.toArray(new ChallengeQuestion[challengeQuestionList.size()]);
        }
        catch (IdentityRecoveryException e) {
            String errorMgs = "Error loading challenge questions for tenant : %s.";
            log.error((Object)String.format(errorMgs, tenantDomain), (Throwable)((Object)e));
            throw new IdentityRecoveryException(String.format(errorMgs, tenantDomain), (Throwable)((Object)e));
        }
    }

    public ChallengeQuestion[] getChallengeQuestionsForUser(User user) throws IdentityRecoveryException {
        if (user == null) {
            log.error((Object)"User object provided is null.");
            throw new IdentityRecoveryClientException("User object provided is null.");
        }
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            List<ChallengeQuestion> challengeQuestionList = this.questionManager.getAllChallengeQuestionsForUser(tenantDomain, user);
            return challengeQuestionList.toArray(new ChallengeQuestion[challengeQuestionList.size()]);
        }
        catch (IdentityRecoveryException e) {
            String errorMgs = "Error loading challenge questions for user : %s@%s.";
            log.error((Object)String.format(errorMgs, user.getUserName(), tenantDomain), (Throwable)((Object)e));
            throw new IdentityRecoveryException(String.format(errorMgs, user.getUserName(), tenantDomain), (Throwable)((Object)e));
        }
    }

    public ChallengeQuestion[] getChallengeQuestionsForLocale(String tenantDomain, String locale) throws IdentityRecoveryException {
        this.checkCrossTenantAccess(tenantDomain);
        try {
            List<ChallengeQuestion> challengeQuestionList = this.questionManager.getAllChallengeQuestions(tenantDomain, locale);
            return challengeQuestionList.toArray(new ChallengeQuestion[challengeQuestionList.size()]);
        }
        catch (IdentityRecoveryException e) {
            String errorMgs = String.format("Error loading challenge questions for tenant %s in %s locale.", tenantDomain, locale);
            log.error((Object)errorMgs, (Throwable)((Object)e));
            throw new IdentityRecoveryException(errorMgs, (Throwable)((Object)e));
        }
    }

    public void setChallengeQuestionsOfTenant(ChallengeQuestion[] challengeQuestions, String tenantDomain) throws IdentityRecoveryException {
        this.checkCrossTenantAccess(tenantDomain);
        try {
            this.questionManager.addChallengeQuestions(challengeQuestions, tenantDomain);
        }
        catch (IdentityRecoveryException e) {
            String errorMsg = "Error setting challenge questions for tenant domain %s.";
            log.error((Object)String.format(errorMsg, tenantDomain), (Throwable)((Object)e));
            throw new IdentityRecoveryException(String.format(errorMsg, tenantDomain), (Throwable)((Object)e));
        }
    }

    public void deleteChallengeQuestionsOfTenant(ChallengeQuestion[] challengeQuestions, String tenantDomain) throws IdentityRecoveryException {
        this.checkCrossTenantAccess(tenantDomain);
        try {
            this.questionManager.deleteChallengeQuestions(challengeQuestions, tenantDomain);
        }
        catch (IdentityRecoveryException e) {
            String errorMsg = "Error deleting challenge questions in tenant domain %s.";
            log.error((Object)String.format(errorMsg, tenantDomain), (Throwable)((Object)e));
            throw new IdentityRecoveryException(String.format(errorMsg, tenantDomain), (Throwable)((Object)e));
        }
    }

    public void setUserChallengeAnswers(User user, UserChallengeAnswer[] userChallengeAnswers) throws IdentityRecoveryException {
        if (user == null) {
            log.error((Object)"User object provided is null.");
            throw new IdentityRecoveryClientException("User object provided is null.");
        }
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user.getUserName());
        if (ArrayUtils.isEmpty((Object[])userChallengeAnswers)) {
            String errorMsg = "No challenge question answers provided by the user " + tenantAwareUserName;
            log.error((Object)errorMsg);
            throw new IdentityRecoveryClientException(errorMsg);
        }
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String loggedInName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (tenantAwareUserName != null && !this.isValidUser(user.getUserStoreDomain(), tenantAwareUserName, loggedInName)) {
            boolean isAuthorized = this.isUserAuthorized(loggedInName, tenantDomain);
            if (!isAuthorized) {
                throw new IdentityRecoveryClientException("Unauthorized access!! Possible elevation of privilege attack. User " + loggedInName + " trying to change challenge questions for user " + tenantAwareUserName);
            }
        } else if (tenantAwareUserName == null) {
            tenantAwareUserName = loggedInName;
        }
        try {
            this.questionManager.setChallengesOfUser(user, userChallengeAnswers);
        }
        catch (IdentityException e) {
            String errorMessage = "Error while persisting user challenges for user : " + tenantAwareUserName;
            log.error((Object)errorMessage, (Throwable)e);
            throw new IdentityRecoveryException(errorMessage, e);
        }
    }

    public UserChallengeAnswer[] getUserChallengeAnswers(User user) throws IdentityRecoveryException {
        if (user == null) {
            log.error((Object)"User object provided is null.");
            throw new IdentityRecoveryClientException("User object provided is null.");
        }
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user.getUserName());
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String loggedInName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        if (tenantAwareUserName != null && !this.isValidUser(user.getUserStoreDomain(), tenantAwareUserName, loggedInName)) {
            boolean isAuthorized = this.isUserAuthorized(loggedInName, tenantDomain);
            if (!isAuthorized) {
                throw new IdentityRecoveryClientException("Unauthorized access!! Possible violation of confidentiality. User " + loggedInName + " trying to get challenge questions for user " + tenantAwareUserName);
            }
        } else if (tenantAwareUserName == null) {
            tenantAwareUserName = loggedInName;
        }
        try {
            return this.questionManager.getChallengeAnswersOfUser(user);
        }
        catch (IdentityRecoveryException e) {
            String msg = "Error retrieving user challenge answers for " + tenantAwareUserName;
            log.error((Object)msg, (Throwable)((Object)e));
            throw new IdentityRecoveryException(msg, (Throwable)((Object)e));
        }
    }

    private boolean isUserAuthorized(String tenantAwareUserName, String tenantDomain) throws IdentityRecoveryException {
        boolean isAuthorized;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        AuthorizationManager authzManager = null;
        try {
            authzManager = IdentityRecoveryServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager();
            isAuthorized = authzManager.isUserAuthorized(tenantAwareUserName, "/permission/admin/manage/identity", "ui.execute");
        }
        catch (UserStoreException e) {
            throw new IdentityRecoveryServerException("Error occurred while checking access level for user " + tenantAwareUserName + " in tenant " + tenantDomain, e);
        }
        return isAuthorized;
    }

    private void checkCrossTenantAccess(String tenantDomain) throws IdentityRecoveryClientException {
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        String loggedInTenant = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!StringUtils.equals((String)loggedInTenant, (String)tenantDomain)) {
            String errorMsg = String.format("Unauthorized Access. User %s@%s trying to retrieve challenge questions of %s tenant", loggedInUser, loggedInTenant, tenantDomain);
            throw new IdentityRecoveryClientException(errorMsg);
        }
    }

    private boolean isValidUser(String userDomain, String tenantAwareUserName, String loggedInName) {
        String loggedInUserDomain = UserCoreUtil.getDomainFromThreadLocal();
        if (StringUtils.isEmpty((String)loggedInUserDomain)) {
            loggedInUserDomain = "PRIMARY";
        }
        if (StringUtils.isEmpty((String)userDomain)) {
            userDomain = "PRIMARY";
        }
        String domainAppendedUsername = this.appendDomainToUserName(tenantAwareUserName, userDomain);
        String domainAppendedLoggedInName = this.appendDomainToUserName(loggedInName, loggedInUserDomain);
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreCaseSensitive((String)loggedInUserDomain, (int)tenantId);
        if (isUsernameCaseSensitive) {
            return domainAppendedUsername.equals(domainAppendedLoggedInName);
        }
        return domainAppendedUsername.equalsIgnoreCase(domainAppendedLoggedInName);
    }

    private String appendDomainToUserName(String username, String domainName) {
        int domainSeparatorIndex = username.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
        if (domainSeparatorIndex > 0) {
            String existingDomainName = username.substring(0, domainSeparatorIndex);
            return username.replace(existingDomainName, existingDomainName.toUpperCase());
        }
        return UserCoreUtil.addDomainToName((String)username, (String)domainName);
    }
}

