/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.password;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.bean.ChallengeQuestionResponse;
import org.wso2.carbon.identity.recovery.bean.ChallengeQuestionsResponse;
import org.wso2.carbon.identity.recovery.handler.ConfigStoreFunctionalityLockPropertyHandler;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.model.UserChallengeAnswer;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementClientException;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementException;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementServerException;
import org.wso2.carbon.identity.user.functionality.mgt.model.FunctionalityLockStatus;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class SecurityQuestionPasswordRecoveryManager {
    private static final Log log = LogFactory.getLog(SecurityQuestionPasswordRecoveryManager.class);
    private static final String PROPERTY_ACCOUNT_LOCK_ON_FAILURE = "account.lock.handler.enable";
    private static final String PROPERTY_ACCOUNT_LOCK_ON_FAILURE_MAX = "account.lock.handler.On.Failure.Max.Attempts";
    private static final String PROPERTY_ACCOUNT_LOCK_TIME = "account.lock.handler.Time";
    private static final String PROPERTY_LOGIN_FAIL_TIMEOUT_RATIO = "account.lock.handler.login.fail.timeout.ratio";
    private static final boolean isPerUserFunctionalityLockingEnabled = Utils.isPerUserFunctionalityLockingEnabled();
    private static final boolean isDetailedErrorMessagesEnabled = Utils.isDetailedErrorResponseEnabled();
    private static SecurityQuestionPasswordRecoveryManager instance = new SecurityQuestionPasswordRecoveryManager();

    private SecurityQuestionPasswordRecoveryManager() {
    }

    public static SecurityQuestionPasswordRecoveryManager getInstance() {
        return instance;
    }

    public ChallengeQuestionResponse initiateUserChallengeQuestion(User user) throws IdentityRecoveryException {
        Utils.validateEmailUsername(user.getUserName());
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            log.info((Object)("initiateUserChallengeQuestion :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("initiateUserChallengeQuestion :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        boolean isNotificationInternallyManaged = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", user.getTenantDomain()));
        boolean isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.Enable", user.getTenantDomain()));
        if (!isRecoveryEnable) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_QUESTION_BASED_RECOVERY_NOT_ENABLE, null);
        }
        this.verifyUserExists(user);
        this.validateFunctionalityForUser(user);
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        userRecoveryDataStore.invalidate(user);
        String challengeQuestionSeparator = IdentityUtil.getProperty((String)"Recovery.Question.Password.Separator");
        if (StringUtils.isEmpty((String)challengeQuestionSeparator)) {
            challengeQuestionSeparator = "!";
        }
        if (Utils.isAccountDisabled(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT, user.getUserName());
        }
        if (Utils.isAccountLocked(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT, user.getUserName());
        }
        boolean isNotificationSendWhenInitiatingPWRecovery = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.NotifyStart", user.getTenantDomain()));
        if (isNotificationInternallyManaged && isNotificationSendWhenInitiatingPWRecovery) {
            try {
                this.triggerNotification(user, "initiaterecovery", null);
            }
            catch (Exception e) {
                log.warn((Object)("Error while sending password reset initiating notification to user :" + user.getUserName()));
            }
        }
        int minNoOfQuestionsToAnswer = Integer.parseInt(Utils.getRecoveryConfigs("Recovery.Question.Password.MinAnswers", user.getTenantDomain()));
        ChallengeQuestionManager challengeQuestionManager = ChallengeQuestionManager.getInstance();
        String[] ids = challengeQuestionManager.getUserChallengeQuestionIds(user);
        if (ids == null || ids.length == 0) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, user.getUserName());
        }
        if (ids.length > minNoOfQuestionsToAnswer) {
            ids = SecurityQuestionPasswordRecoveryManager.getRandomQuestionIds(ids, minNoOfQuestionsToAnswer);
        }
        String metaData = null;
        for (int i = 1; i < ids.length; ++i) {
            metaData = i == 1 ? ids[1] : metaData + challengeQuestionSeparator + ids[i];
        }
        ChallengeQuestion userChallengeQuestion = challengeQuestionManager.getUserChallengeQuestion(user, ids[0]);
        ChallengeQuestionResponse challengeQuestionResponse = new ChallengeQuestionResponse(userChallengeQuestion);
        String secretKey = UUIDGenerator.generateUUID();
        UserRecoveryData recoveryData = new UserRecoveryData(user, secretKey, RecoveryScenarios.QUESTION_BASED_PWD_RECOVERY, RecoverySteps.VALIDATE_CHALLENGE_QUESTION);
        recoveryData.setRemainingSetIds(metaData);
        challengeQuestionResponse.setCode(secretKey);
        if (ids.length > 1) {
            challengeQuestionResponse.setStatus("INCOMPLETE");
        }
        userRecoveryDataStore.store(recoveryData);
        return challengeQuestionResponse;
    }

    private void validateFunctionalityForUser(User user) throws IdentityRecoveryServerException, IdentityRecoveryClientException {
        FunctionalityLockStatus functionalityLockStatus;
        if (isPerUserFunctionalityLockingEnabled && (functionalityLockStatus = this.getFunctionalityStatusOfUser(user, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier())).getLockStatus()) {
            StringBuilder message = new StringBuilder(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_SECURITY_QUESTION_BASED_PWR_LOCKED.getMessage());
            if (isDetailedErrorMessagesEnabled) {
                message.append(": ").append(functionalityLockStatus.getLockReason());
            }
            throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_SECURITY_QUESTION_BASED_PWR_LOCKED.getCode(), (String)message.toString());
        }
    }

    public ChallengeQuestionsResponse initiateUserChallengeQuestionAtOnce(User user) throws IdentityRecoveryException {
        boolean isRecoveryEnable;
        String challengeQuestionSeparator = IdentityUtil.getProperty((String)"Recovery.Question.Password.Separator");
        if (StringUtils.isEmpty((String)challengeQuestionSeparator)) {
            challengeQuestionSeparator = "!";
        }
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            log.info((Object)("initiateUserChallengeQuestionAtOnce :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            log.info((Object)("initiateUserChallengeQuestionAtOnce :User store domain is not in the request. set to default for user : " + user.getUserName()));
        }
        if (!(isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.Enable", user.getTenantDomain())))) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_QUESTION_BASED_RECOVERY_NOT_ENABLE, null);
        }
        boolean isNotificationInternallyManaged = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", user.getTenantDomain()));
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        userRecoveryDataStore.invalidate(user);
        this.verifyUserExists(user);
        if (Utils.isAccountDisabled(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT, null);
        }
        if (Utils.isAccountLocked(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT, null);
        }
        boolean isNotificationSendWhenInitiatingPWRecovery = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.NotifyStart", user.getTenantDomain()));
        if (isNotificationInternallyManaged && isNotificationSendWhenInitiatingPWRecovery) {
            try {
                this.triggerNotification(user, "initiaterecovery", null);
            }
            catch (Exception e) {
                log.warn((Object)("Error while sending password reset initiating notification to user :" + user.getUserName()));
            }
        }
        int minNoOfQuestionsToAnswer = Integer.parseInt(Utils.getRecoveryConfigs("Recovery.Question.Password.MinAnswers", user.getTenantDomain()));
        ChallengeQuestionManager challengeQuestionManager = ChallengeQuestionManager.getInstance();
        String[] ids = challengeQuestionManager.getUserChallengeQuestionIds(user);
        if (ids == null || ids.length == 0) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, user.getUserName());
        }
        if (ids.length > minNoOfQuestionsToAnswer) {
            ids = SecurityQuestionPasswordRecoveryManager.getRandomQuestionIds(ids, minNoOfQuestionsToAnswer);
        }
        ChallengeQuestion[] questions = new ChallengeQuestion[ids.length];
        StringBuilder allChallengeQuestions = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            questions[i] = challengeQuestionManager.getUserChallengeQuestion(user, ids[i]);
            if (i == 0) {
                allChallengeQuestions.append(ids[0]);
                continue;
            }
            allChallengeQuestions.append(challengeQuestionSeparator).append(ids[i]);
        }
        ChallengeQuestionsResponse challengeQuestionResponse = new ChallengeQuestionsResponse(questions);
        String secretKey = UUIDGenerator.generateUUID();
        UserRecoveryData recoveryData = new UserRecoveryData(user, secretKey, RecoveryScenarios.QUESTION_BASED_PWD_RECOVERY, RecoverySteps.VALIDATE_ALL_CHALLENGE_QUESTION);
        recoveryData.setRemainingSetIds(allChallengeQuestions.toString());
        challengeQuestionResponse.setCode(secretKey);
        userRecoveryDataStore.store(recoveryData);
        return challengeQuestionResponse;
    }

    public ChallengeQuestionResponse validateUserChallengeQuestions(UserChallengeAnswer[] userChallengeAnswer, String code, org.wso2.carbon.identity.recovery.model.Property[] properties) throws IdentityRecoveryException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData userRecoveryData = userRecoveryDataStore.load(code);
        User user = userRecoveryData.getUser();
        this.validateFunctionalityForUser(user);
        try {
            boolean isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.Enable", userRecoveryData.getUser().getTenantDomain()));
            if (!isRecoveryEnable) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_QUESTION_BASED_RECOVERY_NOT_ENABLE, null);
            }
            this.verifyUserExists(user);
            if (Utils.isAccountDisabled(user)) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT, user.getUserName());
            }
            if (Utils.isAccountLocked(user)) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT, user.getUserName());
            }
            if (userChallengeAnswer == null) {
                String error = "Challenge answers cannot be found for user: " + userRecoveryData.getUser();
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, error);
            }
            String challengeQuestionSeparator = IdentityUtil.getProperty((String)"Recovery.Question.Password.Separator");
            if (StringUtils.isEmpty((String)challengeQuestionSeparator)) {
                challengeQuestionSeparator = "!";
            }
            if (RecoverySteps.VALIDATE_CHALLENGE_QUESTION.equals(userRecoveryData.getRecoveryStep())) {
                if (userChallengeAnswer.length > 1) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_MULTIPLE_QUESTION_NOT_ALLOWED, null);
                }
                ChallengeQuestionManager challengeQuestionManager = ChallengeQuestionManager.getInstance();
                boolean verified = challengeQuestionManager.verifyUserChallengeAnswer(userRecoveryData.getUser(), userChallengeAnswer[0]);
                if (verified) {
                    boolean resetFailedLoginCount = false;
                    userRecoveryDataStore.invalidate(code);
                    String remainingSetIds = userRecoveryData.getRemainingSetIds();
                    ChallengeQuestionResponse challengeQuestionResponse = new ChallengeQuestionResponse();
                    String secretKey = UUIDGenerator.generateUUID();
                    challengeQuestionResponse.setCode(secretKey);
                    UserRecoveryData recoveryData = new UserRecoveryData(userRecoveryData.getUser(), secretKey, RecoveryScenarios.QUESTION_BASED_PWD_RECOVERY);
                    if (StringUtils.isNotBlank((String)remainingSetIds)) {
                        String[] ids = remainingSetIds.split(challengeQuestionSeparator);
                        ChallengeQuestion challengeQuestion = challengeQuestionManager.getUserChallengeQuestion(userRecoveryData.getUser(), ids[0]);
                        challengeQuestionResponse.setQuestion(challengeQuestion);
                        recoveryData.setRecoveryStep(RecoverySteps.VALIDATE_CHALLENGE_QUESTION);
                        challengeQuestionResponse.setStatus("INCOMPLETE");
                        if (ids.length > 1) {
                            for (int i = 1; i < ids.length; ++i) {
                                remainingSetIds = i == 1 ? ids[1] : remainingSetIds + challengeQuestionSeparator + ids[i];
                            }
                            recoveryData.setRemainingSetIds(remainingSetIds);
                        }
                    } else {
                        resetFailedLoginCount = true;
                        recoveryData.setRecoveryStep(RecoverySteps.UPDATE_PASSWORD);
                        challengeQuestionResponse.setStatus("COMPLETE");
                    }
                    userRecoveryDataStore.store(recoveryData);
                    if (isPerUserFunctionalityLockingEnabled) {
                        this.resetRecoveryPasswordProperties(userRecoveryData.getUser(), resetFailedLoginCount);
                    } else {
                        this.resetRecoveryPasswordFailedAttempts(userRecoveryData.getUser(), resetFailedLoginCount);
                    }
                    return challengeQuestionResponse;
                }
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_ANSWER_FOR_SECURITY_QUESTION, null);
            }
            if (RecoverySteps.VALIDATE_ALL_CHALLENGE_QUESTION.equals(userRecoveryData.getRecoveryStep())) {
                String[] requestedQuestions;
                String allChallengeQuestions = userRecoveryData.getRemainingSetIds();
                if (StringUtils.isNotBlank((String)allChallengeQuestions)) {
                    requestedQuestions = allChallengeQuestions.split(challengeQuestionSeparator);
                    if (requestedQuestions.length != userChallengeAnswer.length) {
                        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NEED_TO_ANSWER_TO_REQUESTED_QUESTIONS, null);
                    }
                } else {
                    String error = "Could not find requested challenge questions for user: " + userRecoveryData.getUser();
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, error);
                }
                this.validateQuestion(requestedQuestions, userChallengeAnswer);
                ChallengeQuestionManager challengeQuestionManager = ChallengeQuestionManager.getInstance();
                for (int i = 0; i < userChallengeAnswer.length; ++i) {
                    boolean verified = challengeQuestionManager.verifyUserChallengeAnswer(userRecoveryData.getUser(), userChallengeAnswer[i]);
                    if (verified) continue;
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_ANSWER_FOR_SECURITY_QUESTION, null);
                }
                if (isPerUserFunctionalityLockingEnabled) {
                    this.resetRecoveryPasswordProperties(userRecoveryData.getUser(), true);
                } else {
                    this.resetRecoveryPasswordFailedAttempts(userRecoveryData.getUser(), true);
                }
                userRecoveryDataStore.invalidate(code);
                ChallengeQuestionResponse challengeQuestionResponse = new ChallengeQuestionResponse();
                String secretKey = UUIDGenerator.generateUUID();
                challengeQuestionResponse.setCode(secretKey);
                challengeQuestionResponse.setStatus("COMPLETE");
                UserRecoveryData recoveryData = new UserRecoveryData(userRecoveryData.getUser(), secretKey, RecoveryScenarios.QUESTION_BASED_PWD_RECOVERY);
                recoveryData.setRecoveryStep(RecoverySteps.UPDATE_PASSWORD);
                userRecoveryDataStore.store(recoveryData);
                return challengeQuestionResponse;
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, null);
        }
        catch (IdentityRecoveryClientException e) {
            if (isPerUserFunctionalityLockingEnabled) {
                this.handleAnswerVerificationFailInFunctionalityLockMode(userRecoveryData.getUser());
                throw e;
            }
            this.handleAnswerVerificationFail(userRecoveryData.getUser());
            throw e;
        }
    }

    private void validateQuestion(String[] requestedQuestions, UserChallengeAnswer[] userChallengeAnswer) throws IdentityRecoveryException {
        int i;
        ArrayList<String> userChallengeIds = new ArrayList<String>();
        for (i = 0; i < userChallengeAnswer.length; ++i) {
            userChallengeIds.add(userChallengeAnswer[i].getQuestion().getQuestionSetId().toLowerCase());
        }
        for (i = 0; i < requestedQuestions.length; ++i) {
            if (userChallengeIds.contains(requestedQuestions[i].toLowerCase())) continue;
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NEED_TO_ANSWER_TO_REQUESTED_QUESTIONS, null);
        }
    }

    private static String[] getRandomQuestionIds(String[] allQuesitons, int minNoOfQuestionsToAnswser) {
        ArrayList<String> remainingQuestions = new ArrayList<String>(Arrays.asList(allQuesitons));
        ArrayList<String> selectedQuestions = new ArrayList<String>();
        for (int i = 0; i < minNoOfQuestionsToAnswser; ++i) {
            int random = new Random().nextInt(remainingQuestions.size());
            selectedQuestions.add(i, remainingQuestions.get(random));
            remainingQuestions.remove(random);
        }
        return selectedQuestions.toArray(new String[selectedQuestions.size()]);
    }

    private void triggerNotification(User user, String type, String code) throws IdentityRecoveryException {
        String eventName = "TRIGGER_NOTIFICATION";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        properties.put("TEMPLATE_TYPE", type);
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private Property[] getConnectorConfigs(String tenantDomain) throws IdentityRecoveryException {
        Property[] connectorConfigs;
        try {
            connectorConfigs = IdentityRecoveryServiceDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(new String[]{PROPERTY_ACCOUNT_LOCK_ON_FAILURE, PROPERTY_ACCOUNT_LOCK_ON_FAILURE_MAX, PROPERTY_ACCOUNT_LOCK_TIME, PROPERTY_LOGIN_FAIL_TIMEOUT_RATIO}, tenantDomain);
        }
        catch (Exception e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_GOV_CONFIGS, null, e);
        }
        return connectorConfigs;
    }

    private void resetRecoveryPasswordFailedAttempts(User user, boolean resetFailedLoginLockOutCount) throws IdentityRecoveryException {
        org.wso2.carbon.user.core.UserStoreManager userStoreManager;
        UserRealm userRealm;
        Property[] connectorConfigs;
        for (Property connectorConfig : connectorConfigs = this.getConnectorConfigs(user.getTenantDomain())) {
            if (!PROPERTY_ACCOUNT_LOCK_ON_FAILURE.equals(connectorConfig.getName()) || Boolean.parseBoolean(connectorConfig.getValue())) continue;
            return;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, user.getTenantDomain(), e);
        }
        try {
            userStoreManager = userRealm.getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_STORE_MANAGER, null, e);
        }
        HashMap<String, String> updatedClaims = new HashMap<String, String>();
        if (resetFailedLoginLockOutCount) {
            updatedClaims.put("http://wso2.org/claims/identity/failedLoginLockoutCount", "0");
        }
        updatedClaims.put("http://wso2.org/claims/identity/failedPasswordRecoveryAttempts", "0");
        try {
            userStoreManager.setUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), updatedClaims, "default");
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_USER_CLAIMS, null, e);
        }
    }

    private void resetRecoveryPasswordProperties(User user, boolean resetFailedLoginLockOutCount) throws IdentityRecoveryException {
        Property[] connectorConfigs;
        for (Property connectorConfig : connectorConfigs = this.getConnectorConfigs(user.getTenantDomain())) {
            if (!PROPERTY_ACCOUNT_LOCK_ON_FAILURE.equals(connectorConfig.getName()) || Boolean.parseBoolean(connectorConfig.getValue())) continue;
            return;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        String userId = Utils.getUserId(user.getUserName(), tenantId);
        UserFunctionalityManager userFunctionalityManager = IdentityRecoveryServiceDataHolder.getInstance().getUserFunctionalityManagerService();
        if (resetFailedLoginLockOutCount) {
            try {
                userFunctionalityManager.unlock(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier());
                userFunctionalityManager.deleteAllPropertiesForUser(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier());
            }
            catch (UserFunctionalityManagementException e) {
                throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UNLOCK_FUNCTIONALITY_FOR_USER, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
            }
        }
        try {
            HashMap<String, String> propertiesToUpdate = new HashMap<String, String>();
            propertiesToUpdate.put("FailedAttempts", "0");
            userFunctionalityManager.setProperties(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), propertiesToUpdate);
        }
        catch (UserFunctionalityManagementException e) {
            throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_PROPERTIES_FOR_FUNCTIONALITY, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
        }
    }

    private void handleAnswerVerificationFail(User user) throws IdentityRecoveryException {
        Map claimValues;
        org.wso2.carbon.user.core.UserStoreManager userStoreManager;
        UserRealm userRealm;
        Property[] connectorConfigs = this.getConnectorConfigs(user.getTenantDomain());
        int maxAttempts = 0;
        long unlockTimePropertyValue = 0L;
        double unlockTimeRatio = 1.0;
        for (Property connectorConfig : connectorConfigs) {
            double value;
            if (PROPERTY_ACCOUNT_LOCK_ON_FAILURE.equals(connectorConfig.getName()) && !Boolean.parseBoolean(connectorConfig.getValue())) {
                return;
            }
            if (PROPERTY_ACCOUNT_LOCK_ON_FAILURE_MAX.equals(connectorConfig.getName()) && NumberUtils.isNumber((String)connectorConfig.getValue())) {
                maxAttempts = Integer.parseInt(connectorConfig.getValue());
                continue;
            }
            if (PROPERTY_ACCOUNT_LOCK_TIME.equals(connectorConfig.getName()) && NumberUtils.isNumber((String)connectorConfig.getValue())) {
                unlockTimePropertyValue = Integer.parseInt(connectorConfig.getValue());
                continue;
            }
            if (!PROPERTY_LOGIN_FAIL_TIMEOUT_RATIO.equals(connectorConfig.getName()) || !NumberUtils.isNumber((String)connectorConfig.getValue()) || !((value = Double.parseDouble(connectorConfig.getValue())) > 0.0)) continue;
            unlockTimeRatio = value;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_REALM_SERVICE, user.getTenantDomain(), e);
        }
        try {
            userStoreManager = userRealm.getUserStoreManager();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_STORE_MANAGER, null, e);
        }
        if (Utils.isAccountLocked(user)) {
            return;
        }
        try {
            claimValues = userStoreManager.getUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), new String[]{"http://wso2.org/claims/identity/failedPasswordRecoveryAttempts", "http://wso2.org/claims/identity/failedLoginLockoutCount"}, "default");
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_CLAIMS, null, e);
        }
        int currentAttempts = 0;
        if (NumberUtils.isNumber((String)((String)claimValues.get("http://wso2.org/claims/identity/failedPasswordRecoveryAttempts")))) {
            currentAttempts = Integer.parseInt((String)claimValues.get("http://wso2.org/claims/identity/failedPasswordRecoveryAttempts"));
        }
        int failedLoginLockoutCountValue = 0;
        if (NumberUtils.isNumber((String)((String)claimValues.get("http://wso2.org/claims/identity/failedLoginLockoutCount")))) {
            failedLoginLockoutCountValue = Integer.parseInt((String)claimValues.get("http://wso2.org/claims/identity/failedLoginLockoutCount"));
        }
        HashMap<String, String> updatedClaims = new HashMap<String, String>();
        if (currentAttempts + 1 >= maxAttempts) {
            unlockTimePropertyValue = (long)((double)(unlockTimePropertyValue * 1000L * 60L) * Math.pow(unlockTimeRatio, failedLoginLockoutCountValue));
            long unlockTime = System.currentTimeMillis() + unlockTimePropertyValue;
            updatedClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.TRUE.toString());
            updatedClaims.put("http://wso2.org/claims/identity/failedPasswordRecoveryAttempts", "0");
            updatedClaims.put("http://wso2.org/claims/identity/unlockTime", String.valueOf(unlockTime));
            updatedClaims.put("http://wso2.org/claims/identity/failedLoginLockoutCount", String.valueOf(failedLoginLockoutCountValue + 1));
            try {
                userStoreManager.setUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), updatedClaims, "default");
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT, IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()));
            }
            catch (UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_USER_CLAIMS, null, e);
            }
        }
        updatedClaims.put("http://wso2.org/claims/identity/failedPasswordRecoveryAttempts", String.valueOf(currentAttempts + 1));
        try {
            userStoreManager.setUserClaimValues(IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), updatedClaims, "default");
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_USER_CLAIMS, null, e);
        }
    }

    private void handleAnswerVerificationFailInFunctionalityLockMode(User user) throws IdentityRecoveryException {
        Map functionalityLockProperties;
        if (Utils.isAccountLocked(user)) {
            return;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        String userId = Utils.getUserId(user.getUserName(), tenantId);
        Map<String, String> configStoreProperties = ConfigStoreFunctionalityLockPropertyHandler.getInstance().getConfigStoreProperties(user.getTenantDomain(), IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier());
        this.validateUserFunctionalityProperties(configStoreProperties);
        int maxAttempts = Integer.parseInt(configStoreProperties.get("MaxAttempts"));
        long unlockTimePropertyValue = Integer.parseInt(configStoreProperties.get("LockoutTime"));
        double unlockTimeRatio = Double.parseDouble(configStoreProperties.get("TimeoutRatio"));
        int currentAttempts = 0;
        int failedLoginLockoutCountValue = 0;
        UserFunctionalityManager userFunctionalityManager = IdentityRecoveryServiceDataHolder.getInstance().getUserFunctionalityManagerService();
        try {
            functionalityLockProperties = userFunctionalityManager.getProperties(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier());
        }
        catch (UserFunctionalityManagementException e) {
            throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_PROPERTIES_FOR_FUNCTIONALITY, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
        }
        if (functionalityLockProperties.isEmpty()) {
            functionalityLockProperties.put("LockoutCount", String.valueOf(failedLoginLockoutCountValue));
            functionalityLockProperties.put("FailedAttempts", String.valueOf(currentAttempts));
            functionalityLockProperties.put("MaxAttempts", String.valueOf(maxAttempts));
            try {
                userFunctionalityManager.setProperties(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), functionalityLockProperties);
            }
            catch (UserFunctionalityManagementException e) {
                throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_ADD_PROPERTIES_FOR_FUNCTIONALITY, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
            }
        } else {
            if (NumberUtils.isNumber((String)((String)functionalityLockProperties.get("LockoutCount")))) {
                failedLoginLockoutCountValue = Integer.parseInt((String)functionalityLockProperties.get("LockoutCount"));
            }
            if (NumberUtils.isNumber((String)((String)functionalityLockProperties.get("FailedAttempts")))) {
                currentAttempts = Integer.parseInt((String)functionalityLockProperties.get("FailedAttempts"));
            }
        }
        HashMap<String, String> updatedFunctionalityLockProperties = new HashMap<String, String>();
        if (currentAttempts + 1 >= maxAttempts) {
            unlockTimePropertyValue = (long)((double)(unlockTimePropertyValue * 1000L * 60L) * Math.pow(unlockTimeRatio, failedLoginLockoutCountValue));
            try {
                updatedFunctionalityLockProperties.put("FailedAttempts", "0");
                updatedFunctionalityLockProperties.put("LockoutCount", String.valueOf(failedLoginLockoutCountValue + 1));
                userFunctionalityManager.lock(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), unlockTimePropertyValue, IdentityRecoveryConstants.RecoveryLockReasons.PWD_RECOVERY_MAX_ATTEMPTS_EXCEEDED.getFunctionalityLockCode(), IdentityRecoveryConstants.RecoveryLockReasons.PWD_RECOVERY_MAX_ATTEMPTS_EXCEEDED.getFunctionalityLockReason());
                userFunctionalityManager.setProperties(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), updatedFunctionalityLockProperties);
            }
            catch (UserFunctionalityManagementServerException e) {
                throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOCK_FUNCTIONALITY_FOR_USER, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
            }
            catch (UserFunctionalityManagementException e) {
                e.printStackTrace();
            }
            StringBuilder message = new StringBuilder(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_SECURITY_QUESTION_BASED_PWR_LOCKED.getMessage());
            if (isDetailedErrorMessagesEnabled) {
                message.append(": ").append(IdentityRecoveryConstants.RecoveryLockReasons.PWD_RECOVERY_MAX_ATTEMPTS_EXCEEDED.getFunctionalityLockReason());
            }
            throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_SECURITY_QUESTION_BASED_PWR_LOCKED.getCode(), (String)message.toString());
        }
        try {
            HashMap<String, String> propertiesToUpdate = new HashMap<String, String>();
            propertiesToUpdate.put("FailedAttempts", String.valueOf(currentAttempts + 1));
            userFunctionalityManager.setProperties(userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), propertiesToUpdate);
        }
        catch (UserFunctionalityManagementException e) {
            throw Utils.handleFunctionalityLockMgtServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_UPDATE_PROPERTIES_FOR_FUNCTIONALITY, userId, tenantId, IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), isDetailedErrorMessagesEnabled);
        }
    }

    private void validateUserFunctionalityProperties(Map<String, String> configStoreProperties) {
        HashSet<String> propertyNames = new HashSet<String>(Arrays.asList("MaxAttempts", "LockoutTime", "TimeoutRatio"));
        if (MapUtils.isEmpty(configStoreProperties)) {
            throw new UnsupportedOperationException("User Functionality properties are not configured.");
        }
        if (configStoreProperties.keySet().equals(propertyNames)) {
            if (!NumberUtils.isNumber((String)configStoreProperties.get("MaxAttempts"))) {
                throw new UnsupportedOperationException("User Functionality properties are not configured.");
            }
            if (!NumberUtils.isNumber((String)configStoreProperties.get("LockoutTime"))) {
                throw new UnsupportedOperationException("User Functionality properties are not configured.");
            }
            if (!NumberUtils.isNumber((String)configStoreProperties.get("TimeoutRatio"))) {
                throw new UnsupportedOperationException("User Functionality properties are not configured.");
            }
        } else {
            throw new UnsupportedOperationException("User Functionality properties are not configured.");
        }
    }

    private void verifyUserExists(User user) throws IdentityRecoveryClientException, IdentityRecoveryServerException {
        try {
            int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
            UserStoreManager userStoreManager = IdentityRecoveryServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            String domainQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
            if (!userStoreManager.isExistingUser(domainQualifiedUsername)) {
                boolean notifyUserExistence;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user found for recovery with username: " + user.toFullQualifiedUsername()));
                }
                if (notifyUserExistence = Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.NotifyUserExistence"))) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USER, domainQualifiedUsername);
                }
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, user.getUserName());
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null);
        }
    }

    private FunctionalityLockStatus getFunctionalityStatusOfUser(User user, String functionalityIdentifier) throws IdentityRecoveryServerException {
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        String userId = Utils.getUserId(user.getUserName(), tenantId);
        UserFunctionalityManager userFunctionalityManager = IdentityRecoveryServiceDataHolder.getInstance().getUserFunctionalityManagerService();
        try {
            return userFunctionalityManager.getLockStatus(userId, tenantId, functionalityIdentifier);
        }
        catch (UserFunctionalityManagementException e) {
            String mappedErrorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getCode(), "PWR");
            StringBuilder message = new StringBuilder(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getMessage());
            if (isDetailedErrorMessagesEnabled) {
                message.append(String.format("functionalityIdentifier: %s for %s.", IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), user.getUserName()));
            }
            String errorMessage = "Error occurred while getting functionality status of user.";
            if (e instanceof UserFunctionalityManagementClientException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
            } else {
                log.error((Object)errorMessage, (Throwable)e);
            }
            throw Utils.handleServerException(mappedErrorCode, message.toString(), null);
        }
    }
}

