/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.password;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.slf4j.MDC;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.mgt.policy.PolicyViolationException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.bean.NotificationResponseBean;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;

public class NotificationPasswordRecoveryManager {
    private static final Log log = LogFactory.getLog(NotificationPasswordRecoveryManager.class);
    private static NotificationPasswordRecoveryManager instance = new NotificationPasswordRecoveryManager();

    private NotificationPasswordRecoveryManager() {
    }

    public static NotificationPasswordRecoveryManager getInstance() {
        return instance;
    }

    public NotificationResponseBean sendRecoveryNotification(User user, String type, Boolean notify, Property[] properties) throws IdentityRecoveryException {
        this.publishEvent(user, String.valueOf(notify), null, null, properties, "PRE_SEND_RECOVERY_NOTIFICATION");
        Utils.validateEmailUsername(user.getUserName());
        this.resolveUserAttributes(user);
        this.validatePasswordRecoveryConfiguration(user.getTenantDomain());
        this.validateCallback(properties, user.getTenantDomain());
        HashMap<String, String> propertyMap = this.buildPropertyMap(properties);
        String notificationChannel = this.getNotificationChannelFromProperties(propertyMap);
        boolean isNotificationInternallyManage = this.isNotificationsInternallyManaged(user.getTenantDomain(), notify);
        if (!isNotificationInternallyManage) {
            notificationChannel = NotificationChannels.EXTERNAL_CHANNEL.getChannelType();
        }
        if (!this.isUserVerified(propertyMap) && !this.isExistingUser(user)) {
            boolean notifyUserExistence = Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.NotifyUserExistence"));
            if (notifyUserExistence) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USER, user.getUserName());
            }
            return new NotificationResponseBean(user);
        }
        this.checkAccountLockedStatus(user);
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        userRecoveryDataStore.invalidate(user);
        String secretKey = Utils.generateSecretKey(notificationChannel, user.getTenantDomain(), RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY.name());
        UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY, RecoverySteps.UPDATE_PASSWORD);
        recoveryDataDO.setRemainingSetIds(notificationChannel);
        userRecoveryDataStore.store(recoveryDataDO);
        NotificationResponseBean notificationResponseBean = new NotificationResponseBean(user);
        if (isNotificationInternallyManage) {
            String eventName = Utils.resolveEventName(notificationChannel);
            this.triggerNotification(user, notificationChannel, "passwordreset", secretKey, eventName, properties);
        } else {
            notificationResponseBean.setKey(secretKey);
        }
        this.publishEvent(user, String.valueOf(notify), null, null, properties, "POST_SEND_RECOVERY_NOTIFICATION");
        return notificationResponseBean;
    }

    private void checkAccountLockedStatus(User user) throws IdentityRecoveryException {
        if (Utils.isAccountDisabled(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT, user.getUserName());
        }
        if (Utils.isAccountLocked(user)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT, user.getUserName());
        }
    }

    private boolean isExistingUser(User user) throws IdentityRecoveryException {
        try {
            int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
            UserStoreManager userStoreManager = IdentityRecoveryServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            String domainQualifiedUsername = IdentityUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
            if (!userStoreManager.isExistingUser(domainQualifiedUsername)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No user found for recovery with username: " + user.toFullQualifiedUsername()));
                }
                return false;
            }
            return true;
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
        }
    }

    private boolean isNotificationsInternallyManaged(String tenantDomain, Boolean notify) throws IdentityRecoveryException {
        if (notify == null) {
            boolean manageNotificationsInternally = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", tenantDomain));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notify parameter not in the request. ManageNotificationsInternally set to server default value: " + manageNotificationsInternally));
            }
            return manageNotificationsInternally;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notify parameter in the request. ManageNotificationsInternally set to : " + notify));
        }
        return notify;
    }

    private boolean isUserVerified(HashMap<String, String> propertyMap) {
        if (MapUtils.isEmpty(propertyMap)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Empty property map received in the recovery request");
            }
            return false;
        }
        String verified = propertyMap.get("verifiedUser");
        if (StringUtils.isBlank((String)verified)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Property : verifiedUser is not in the property map. Hence returning FALSE");
            }
            return false;
        }
        try {
            return Boolean.parseBoolean(verified);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                String message = String.format("Value : %s given for property : %s is not a boolean. Therefore, returning false for the property.", verified, "verifiedUser");
                log.debug((Object)message);
            }
            return false;
        }
    }

    private String getNotificationChannelFromProperties(HashMap<String, String> propertyMap) {
        if (MapUtils.isEmpty(propertyMap)) {
            return NotificationChannels.EMAIL_CHANNEL.getChannelType();
        }
        String notificationChannel = propertyMap.get("notificationChannel");
        return this.getServerSupportedNotificationChannel(notificationChannel);
    }

    private String getServerSupportedNotificationChannel(String channel) {
        if (StringUtils.isEmpty((String)channel)) {
            if (log.isDebugEnabled()) {
                String message = "No notification channel in the request properties. Configuring the notification channel to: " + NotificationChannels.EMAIL_CHANNEL.getChannelType();
                log.debug((Object)message);
            }
            return NotificationChannels.EMAIL_CHANNEL.getChannelType();
        }
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(channel)) {
            return channel;
        }
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(channel)) {
            return channel;
        }
        if (NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(channel)) {
            return channel;
        }
        String defaultNotificationChannel = IdentityGovernanceUtil.getDefaultNotificationChannel();
        if (log.isDebugEnabled()) {
            String message = String.format("Not a server supported notification channel : %s. Therefore default notification channel : %s will be used.", channel, defaultNotificationChannel);
            log.debug((Object)message);
        }
        return defaultNotificationChannel;
    }

    private HashMap<String, String> buildPropertyMap(Property[] properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])properties)) {
            for (Property property : properties) {
                if (!StringUtils.isNotEmpty((String)property.getKey())) continue;
                propertyMap.put(property.getKey(), property.getValue());
            }
        }
        return propertyMap;
    }

    private void validateCallback(Property[] properties, String tenantDomain) throws IdentityRecoveryServerException {
        String callbackURL = null;
        try {
            callbackURL = Utils.getCallbackURL(properties);
            if (StringUtils.isNotBlank((String)callbackURL) && !Utils.validateCallbackURL(callbackURL, tenantDomain, "Recovery.CallbackRegex")) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException | IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
        }
    }

    private void validatePasswordRecoveryConfiguration(String tenantDomain) throws IdentityRecoveryException {
        boolean isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.Password.Enable", tenantDomain));
        if (!isRecoveryEnable) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NOTIFICATION_BASED_PASSWORD_RECOVERY_NOT_ENABLE, null);
        }
    }

    private void resolveUserAttributes(User user) {
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            user.setTenantDomain("carbon.super");
            if (log.isDebugEnabled()) {
                log.debug((Object)("SendRecoveryNotification :Tenant domain is not in the request. set to default for user : " + user.getUserName()));
            }
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("SendRecoveryNotification : User store domain is not in the request. set to default for user : " + user.getUserName()));
            }
        }
    }

    public void updatePassword(String code, String password, Property[] properties) throws IdentityRecoveryException, IdentityEventException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData userRecoveryData = userRecoveryDataStore.load(code);
        this.validateCallback(properties, userRecoveryData.getUser().getTenantDomain());
        this.publishEvent(userRecoveryData.getUser(), null, code, password, properties, "PRE_ADD_NEW_PASSWORD");
        this.validateTenantDomain(userRecoveryData.getUser());
        if (!RecoverySteps.UPDATE_PASSWORD.equals(userRecoveryData.getRecoveryStep())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, code);
        }
        String notificationChannel = this.getServerSupportedNotificationChannel(userRecoveryData.getRemainingSetIds());
        boolean notificationsInternallyManaged = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.InternallyManage", userRecoveryData.getUser().getTenantDomain()));
        boolean isNotificationSendWhenSuccess = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.NotifySuccess", userRecoveryData.getUser().getTenantDomain()));
        String domainQualifiedName = IdentityUtil.addDomainToName((String)userRecoveryData.getUser().getUserName(), (String)userRecoveryData.getUser().getUserStoreDomain());
        this.updateNewPassword(userRecoveryData.getUser(), password, domainQualifiedName, userRecoveryData, notificationsInternallyManaged);
        userRecoveryDataStore.invalidate(userRecoveryData.getUser());
        if (notificationsInternallyManaged && isNotificationSendWhenSuccess && !NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            try {
                String eventName = Utils.resolveEventName(notificationChannel);
                this.triggerNotification(userRecoveryData.getUser(), notificationChannel, "passwordresetsucess", "", eventName, properties);
            }
            catch (IdentityRecoveryException e) {
                String errorMsg = String.format("Error while sending password reset success notification to user : %s", userRecoveryData.getUser().getUserName());
                log.error((Object)errorMsg);
                this.auditPasswordReset("Password reset", userRecoveryData.getUser(), errorMsg, "Success");
            }
        }
        this.publishEvent(userRecoveryData.getUser(), null, code, password, properties, "POST_ADD_NEW_PASSWORD");
        if (log.isDebugEnabled()) {
            String msg = "Password is updated for  user: " + domainQualifiedName;
            log.debug((Object)msg);
        }
        this.auditPasswordReset("Password reset", userRecoveryData.getUser(), null, "Success");
    }

    private void updateNewPassword(User user, String password, String domainQualifiedName, UserRecoveryData userRecoveryData, boolean isNotificationInternallyManaged) throws IdentityEventException, IdentityRecoveryException {
        try {
            int tenantId = IdentityTenantUtil.getTenantId((String)userRecoveryData.getUser().getTenantDomain());
            UserStoreManager userStoreManager = IdentityRecoveryServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
            userStoreManager.updateCredentialByAdmin(domainQualifiedName, (Object)password);
            HashMap<String, String> userClaims = this.getAccountStateClaims(userRecoveryData, isNotificationInternallyManaged);
            if (MapUtils.isNotEmpty(userClaims)) {
                userStoreManager.setUserClaimValues(domainQualifiedName, userClaims, null);
            }
        }
        catch (UserStoreException e) {
            this.checkPasswordValidity(e, user);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NotificationPasswordRecoveryManager: Unexpected Error occurred while updating password for the user: " + domainQualifiedName), (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
        }
    }

    private HashMap<String, String> getAccountStateClaims(UserRecoveryData userRecoveryData, boolean isNotificationInternallyManaged) throws IdentityEventException {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        if (isNotificationInternallyManaged) {
            if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(userRecoveryData.getRemainingSetIds())) {
                userClaims.put(NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl(), Boolean.TRUE.toString());
            } else if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(userRecoveryData.getRemainingSetIds())) {
                userClaims.put(NotificationChannels.SMS_CHANNEL.getVerifiedClaimUrl(), Boolean.TRUE.toString());
            } else {
                if (log.isDebugEnabled()) {
                    String error = String.format("No notification channels for the user : %s in tenant domain : %s", userRecoveryData.getUser().getUserStoreDomain() + userRecoveryData.getUser().getUserName(), userRecoveryData.getUser().getTenantDomain());
                    log.debug((Object)error);
                }
                userClaims.put(NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl(), Boolean.TRUE.toString());
            }
            if (Utils.isAccountStateClaimExisting(userRecoveryData.getUser().getTenantDomain())) {
                userClaims.put("http://wso2.org/claims/identity/accountState", "UNLOCKED");
            }
        }
        if (RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_EMAIL_LINK.equals(userRecoveryData.getRecoveryScenario()) || RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_OTP.equals(userRecoveryData.getRecoveryScenario())) {
            userClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.FALSE.toString());
            userClaims.remove("http://wso2.org/claims/identity/accountState");
        }
        return userClaims;
    }

    private void validateTenantDomain(User user) throws IdentityRecoveryClientException {
        String userTenantDomain;
        String contextTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!StringUtils.equals((String)contextTenantDomain, (String)(userTenantDomain = user.getTenantDomain()))) {
            throw new IdentityRecoveryClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_TENANT_DOMAIN_MISS_MATCH_WITH_CONTEXT.getCode(), "invalid tenant domain: " + userTenantDomain);
        }
    }

    private void checkPasswordValidity(UserStoreException e, User user) throws IdentityRecoveryClientException {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            String errorCode;
            if (cause instanceof IdentityEventException && StringUtils.equals((String)(errorCode = ((IdentityEventException)cause).getErrorCode()), (String)"22001")) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_HISTORY_VIOLATE, null, e);
            }
            if (!(cause instanceof PolicyViolationException)) continue;
            throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_POLICY_VIOLATION.getCode(), (String)cause.getMessage(), (Throwable)e);
        }
        Utils.checkPasswordPatternViolation(e, user);
    }

    private void triggerNotification(User user, String notificationChannel, String templateName, String code, String eventName, Property[] metaProperties) throws IdentityRecoveryException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("notification-channel", notificationChannel);
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        if (metaProperties != null) {
            for (Property metaProperty : metaProperties) {
                if (!StringUtils.isNotBlank((String)metaProperty.getValue()) || !StringUtils.isNotBlank((String)metaProperty.getKey())) continue;
                properties.put(metaProperty.getKey(), metaProperty.getValue());
            }
        }
        properties.put("TEMPLATE_TYPE", templateName);
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
            this.auditPasswordRecovery("Password recovery", notificationChannel, user, null, "Success");
        }
        catch (IdentityEventException e) {
            this.auditPasswordRecovery("Password recovery", notificationChannel, user, e.getMessage(), "Failed");
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private void publishEvent(User user, String notify, String code, String password, Property[] metaProperties, String eventName) throws IdentityRecoveryException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        if (StringUtils.isNotBlank((String)notify)) {
            properties.put("notify", notify);
        }
        if (metaProperties != null) {
            for (Property metaProperty : metaProperties) {
                if (!StringUtils.isNotBlank((String)metaProperty.getValue()) || !StringUtils.isNotBlank((String)metaProperty.getKey())) continue;
                properties.put(metaProperty.getKey(), metaProperty.getValue());
            }
        }
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            log.error((Object)("Error occurred while publishing event " + eventName + " for user " + user));
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PUBLISH_EVENT, eventName, e);
        }
    }

    public void validateConfirmationCode(String code, String recoveryStep) throws IdentityRecoveryException {
        String userTenantDomain;
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData userRecoveryData = userRecoveryDataStore.load(code);
        String contextTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (!StringUtils.equals((String)contextTenantDomain, (String)(userTenantDomain = userRecoveryData.getUser().getTenantDomain()))) {
            throw new IdentityRecoveryClientException("Invalid tenant domain: " + userTenantDomain);
        }
        if (StringUtils.isNotBlank((String)recoveryStep) && !recoveryStep.equals(userRecoveryData.getRecoveryStep().name())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE, null);
        }
        String domainQualifiedName = IdentityUtil.addDomainToName((String)userRecoveryData.getUser().getUserName(), (String)userRecoveryData.getUser().getUserStoreDomain());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Valid confirmation code for user: " + domainQualifiedName));
        }
    }

    private void auditPasswordRecovery(String action, String notificationChannel, User user, String errorMsg, String result) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("RemoteAddress", (Object)MDC.get((String)"remoteAddress"));
        dataObject.put("User Agent", (Object)MDC.get((String)"User-Agent"));
        dataObject.put("Notification Channel", (Object)notificationChannel);
        dataObject.put("ServiceProviderName", (Object)MDC.get((String)"serviceProvider"));
        dataObject.put("UserStoreDomain", (Object)user.getUserStoreDomain());
        if ("Failed".equals(result)) {
            dataObject.put("Error Message", (Object)errorMsg);
        }
        Utils.createAuditMessage(action, user.getUserName(), dataObject, result);
    }

    private void auditPasswordReset(String action, User user, String errorMsg, String result) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("RemoteAddress", (Object)MDC.get((String)"remoteAddress"));
        dataObject.put("User Agent", (Object)MDC.get((String)"User-Agent"));
        dataObject.put("ServiceProviderName", (Object)MDC.get((String)"serviceProvider"));
        dataObject.put("UserStoreDomain", (Object)user.getUserStoreDomain());
        if ("Failed".equals(result)) {
            dataObject.put("Error Message", (Object)errorMsg);
        }
        Utils.createAuditMessage(action, user.getUserName(), dataObject, result);
    }
}

