/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

public class TenantManagementListener
implements TenantMgtListener {
    private static final int EXEC_ORDER = 40;
    private static final Log log = LogFactory.getLog(TenantManagementListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTenantCreate(TenantInfoBean tenantInfoBean) throws StratosException {
        String tenantDomain = tenantInfoBean.getTenantDomain();
        PrivilegedCarbonContext.getThreadLocalCarbonContext();
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantInfoBean.getTenantId());
        ChallengeQuestionManager questionManager = ChallengeQuestionManager.getInstance();
        try {
            questionManager.setDefaultChallengeQuestions(tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default Challenge Questions persisted to the " + tenantDomain + " tenant"));
            }
        }
        catch (IdentityRecoveryException e) {
            log.error((Object)("Error when trying to set default challenge question for tenant : " + tenantDomain), (Throwable)((Object)e));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfoBean) throws StratosException {
    }

    public void onTenantDelete(int i) {
    }

    public void onTenantRename(int i, String s, String s1) throws StratosException {
    }

    public void onTenantInitialActivation(int i) throws StratosException {
    }

    public void onTenantActivation(int i) throws StratosException {
    }

    public void onTenantDeactivation(int i) throws StratosException {
    }

    public void onSubscriptionPlanChange(int i, String s, String s1) throws StratosException {
    }

    public int getListenerOrder() {
        return 0;
    }

    public void onPreDelete(int tenantId) throws StratosException {
        try {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.deleteRecoveryDataByTenantId(tenantId);
        }
        catch (IdentityRecoveryException e) {
            throw new StratosException("Error in deleting recovery data of the tenant:" + tenantId, (Throwable)((Object)e));
        }
    }
}

