/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.internal.service.impl.username;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.slf4j.MDC;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.dto.RecoveryInformationDTO;
import org.wso2.carbon.identity.recovery.dto.UsernameRecoverDTO;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.internal.service.impl.UserAccountRecoveryManager;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.services.username.UsernameRecoveryManager;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UsernameRecoveryManagerImpl
implements UsernameRecoveryManager {
    private static final Log log = LogFactory.getLog(UsernameRecoveryManagerImpl.class);
    private static final String NOTIFICATION_TYPE_INTERNAL = "Internal";
    private static final String NOTIFICATION_TYPE_EXTERNAL = "External";

    @Override
    public RecoveryInformationDTO initiate(Map<String, String> claims, String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        this.validateConfigurations(tenantDomain);
        UserAccountRecoveryManager userAccountRecoveryManager = UserAccountRecoveryManager.getInstance();
        RecoveryInformationDTO recoveryInformationDTO = new RecoveryInformationDTO();
        boolean useLegacyAPIApproach = this.useLegacyAPIApproach(properties);
        boolean manageNotificationsInternally = Utils.isNotificationsInternallyManaged(tenantDomain, properties);
        if (useLegacyAPIApproach) {
            String username = userAccountRecoveryManager.getUsernameByClaims(claims, tenantDomain);
            if (StringUtils.isNotEmpty((String)username)) {
                if (manageNotificationsInternally) {
                    User user = this.createUser(username, tenantDomain);
                    this.triggerNotification(user, NotificationChannels.EMAIL_CHANNEL.getChannelType(), "TRIGGER_NOTIFICATION", null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successful username recovery for user: " + username + ". User notified Internally"));
                    }
                    this.auditUserNameRecovery("Username recovery", claims, NOTIFICATION_TYPE_INTERNAL, username, null, "Success");
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successful username recovery for user: " + username + ". User notified Externally"));
                }
            } else {
                String errorMsg = String.format("No user found for the given claims in tenant domain : %s", tenantDomain);
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMsg);
                }
                this.auditUserNameRecovery("Username recovery", claims, "N/A", username, errorMsg, "Failed");
                if (Boolean.parseBoolean(IdentityUtil.getProperty((String)"Recovery.NotifyUserExistence"))) {
                    throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_USER_FOUND, null);
                }
                return null;
            }
            this.auditUserNameRecovery("Username recovery", claims, NOTIFICATION_TYPE_EXTERNAL, username, null, "Success");
            recoveryInformationDTO.setUsername(username);
            return recoveryInformationDTO;
        }
        HashMap<String, String> metaProperties = new HashMap<String, String>();
        metaProperties.put("manageNotificationsInternally", Boolean.toString(manageNotificationsInternally));
        recoveryInformationDTO.setRecoveryChannelInfoDTO(userAccountRecoveryManager.retrieveUserRecoveryInformation(claims, tenantDomain, RecoveryScenarios.USERNAME_RECOVERY, metaProperties));
        return recoveryInformationDTO;
    }

    @Override
    public UsernameRecoverDTO notify(String recoveryCode, String channelId, String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        int channelIdCode = this.validateChannelID(channelId);
        this.validateConfigurations(tenantDomain);
        UserAccountRecoveryManager recoveryAccountManager = UserAccountRecoveryManager.getInstance();
        UserRecoveryData userRecoveryData = recoveryAccountManager.getUserRecoveryData(recoveryCode, RecoverySteps.SEND_RECOVERY_INFORMATION);
        this.invalidateRecoveryCode(recoveryCode);
        String notificationChannel = this.extractNotificationChannelDetails(userRecoveryData.getRemainingSetIds(), channelIdCode);
        if (!NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            String eventName = Utils.resolveEventName(notificationChannel);
            this.validateCallbackURL(properties, userRecoveryData.getUser());
            this.triggerNotification(userRecoveryData.getUser(), notificationChannel, eventName, properties);
        }
        return this.buildUserNameRecoveryResponseDTO(userRecoveryData.getUser(), notificationChannel);
    }

    private boolean useLegacyAPIApproach(Map<String, String> properties) {
        block3: {
            if (MapUtils.isNotEmpty(properties)) {
                try {
                    return Boolean.parseBoolean(properties.get("useLegacyAPI"));
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    String message = String.format("Invalid boolean value : %s to enable legacyAPIs", properties.get("useLegacyAPI"));
                    log.debug((Object)message);
                }
            }
        }
        return false;
    }

    private User createUser(String userName, String tenantDomain) {
        User user = new User();
        user.setUserName(UserCoreUtil.removeDomainFromName((String)userName));
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(IdentityUtil.extractDomainFromName((String)userName));
        return user;
    }

    private int validateChannelID(String channelId) throws IdentityRecoveryClientException {
        int id;
        try {
            id = Integer.parseInt(channelId);
        }
        catch (NumberFormatException e) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        if (id < 1) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        return id;
    }

    private UsernameRecoverDTO buildUserNameRecoveryResponseDTO(User user, String notificationChannel) {
        String qualifiedUsernameRegexPattern = "%s@%s";
        UsernameRecoverDTO usernameRecoverDTO = new UsernameRecoverDTO();
        usernameRecoverDTO.setNotificationChannel(notificationChannel);
        if (NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            usernameRecoverDTO.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_USERNAME_EXTERNALLY_NOTIFIED.getCode());
            usernameRecoverDTO.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_USERNAME_EXTERNALLY_NOTIFIED.getMessage());
            String username = String.format(qualifiedUsernameRegexPattern, user.getUserName(), user.getTenantDomain());
            usernameRecoverDTO.setUsername(username);
        } else {
            usernameRecoverDTO.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_USERNAME_INTERNALLY_NOTIFIED.getCode());
            usernameRecoverDTO.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_USERNAME_INTERNALLY_NOTIFIED.getMessage());
            usernameRecoverDTO.setUsername("");
        }
        return usernameRecoverDTO;
    }

    private void invalidateRecoveryCode(String recoveryCode) throws IdentityRecoveryException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        userRecoveryDataStore.invalidate(recoveryCode);
    }

    private void triggerNotification(User user, String notificationChannel, String eventName, Map<String, String> metaProperties) throws IdentityRecoveryException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("notification-channel", notificationChannel);
        if (metaProperties != null) {
            for (String key : metaProperties.keySet()) {
                String value = metaProperties.get(key);
                if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
                properties.put(key, value);
            }
        }
        properties.put("TEMPLATE_TYPE", "accountidrecovery");
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private String extractNotificationChannelDetails(String recoveryChannels, int channelId) throws IdentityRecoveryException {
        String[] channels = recoveryChannels.split(",");
        if (channels.length < channelId) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        String notificationChannel = channels[channelId - 1];
        String[] channelDetails = notificationChannel.split(":");
        return channelDetails[0];
    }

    private void validateConfigurations(String tenantDomain) throws IdentityRecoveryException {
        boolean isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.Username.Enable", tenantDomain));
        if (!isRecoveryEnable) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_NOT_ENABLED, null);
        }
    }

    private void validateCallbackURL(Map<String, String> properties, User user) throws IdentityRecoveryException {
        String callbackURL = this.getCallbackURL(properties);
        try {
            if (StringUtils.isNotBlank((String)callbackURL) && !Utils.validateCallbackURL(callbackURL, user.getTenantDomain(), "Recovery.CallbackRegex")) {
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
            }
        }
        catch (IdentityEventException e) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
        }
    }

    private String getCallbackURL(Map<String, String> properties) throws IdentityRecoveryServerException {
        String callbackURL = null;
        try {
            if (MapUtils.isNotEmpty(properties)) {
                for (String key : properties.keySet()) {
                    if (!"callback".equals(key)) continue;
                    callbackURL = URLDecoder.decode(properties.get(key), "UTF-8");
                    break;
                }
                if (StringUtils.isNotBlank(callbackURL)) {
                    URI uri = new URI(callbackURL);
                    callbackURL = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
                }
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            String error = "Error getting callback url";
            if (log.isDebugEnabled()) {
                log.debug((Object)error, (Throwable)e);
            }
            String mappedErrorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID.getCode(), "UAR");
            throw Utils.handleServerException(mappedErrorCode, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID.getMessage(), callbackURL);
        }
        return callbackURL;
    }

    private void validateTenantDomain(String tenantDomain) throws IdentityRecoveryClientException {
        if (StringUtils.isBlank((String)tenantDomain)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_EMPTY_TENANT_DOMAIN.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_EMPTY_TENANT_DOMAIN.getMessage(), null);
        }
    }

    private void auditUserNameRecovery(String action, Map<String, String> claims, String notificationType, String target, String errorMsg, String result) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("Claims", (Object)new JSONObject(claims));
        dataObject.put("RemoteAddress", (Object)MDC.get((String)"remoteAddress"));
        dataObject.put("User Agent", (Object)MDC.get((String)"User-Agent"));
        dataObject.put("User notified type", (Object)notificationType);
        dataObject.put("ServiceProviderName", (Object)MDC.get((String)"serviceProvider"));
        if ("Failed".equals(result)) {
            dataObject.put("Error Message", (Object)errorMsg);
        }
        Utils.createAuditMessage(action, target, dataObject, result);
    }
}

