/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.internal.service.impl.password;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.bean.NotificationResponseBean;
import org.wso2.carbon.identity.recovery.confirmation.ResendConfirmationManager;
import org.wso2.carbon.identity.recovery.dto.PasswordRecoverDTO;
import org.wso2.carbon.identity.recovery.dto.PasswordResetCodeDTO;
import org.wso2.carbon.identity.recovery.dto.RecoveryChannelInfoDTO;
import org.wso2.carbon.identity.recovery.dto.RecoveryInformationDTO;
import org.wso2.carbon.identity.recovery.dto.ResendConfirmationDTO;
import org.wso2.carbon.identity.recovery.dto.SuccessfulPasswordResetDTO;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.internal.service.impl.UserAccountRecoveryManager;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.password.NotificationPasswordRecoveryManager;
import org.wso2.carbon.identity.recovery.services.password.PasswordRecoveryManager;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementException;
import org.wso2.carbon.identity.user.functionality.mgt.model.FunctionalityLockStatus;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class PasswordRecoveryManagerImpl
implements PasswordRecoveryManager {
    private static final Log log = LogFactory.getLog(PasswordRecoveryManagerImpl.class);
    private static final boolean isSkipRecoveryWithChallengeQuestionsForInsufficientAnswersEnabled = Utils.isSkipRecoveryWithChallengeQuestionsForInsufficientAnswersEnabled();
    private static final boolean isPerUserFunctionalityLockingEnabled = Utils.isPerUserFunctionalityLockingEnabled();
    private static final boolean isDetailedErrorMessagesEnabled = Utils.isDetailedErrorResponseEnabled();

    @Override
    public RecoveryInformationDTO initiate(Map<String, String> claims, String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        UserAccountRecoveryManager userAccountRecoveryManager = UserAccountRecoveryManager.getInstance();
        boolean isQuestionBasedRecoveryEnabled = this.isQuestionBasedRecoveryEnabled(tenantDomain);
        boolean isNotificationBasedRecoveryEnabled = this.isNotificationBasedRecoveryEnabled(tenantDomain);
        if (!isNotificationBasedRecoveryEnabled && !isQuestionBasedRecoveryEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User password recovery is not enabled for the tenant: " + tenantDomain));
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_RECOVERY_NOT_ENABLED, null);
        }
        RecoveryChannelInfoDTO recoveryChannelInfoDTO = userAccountRecoveryManager.retrieveUserRecoveryInformation(claims, tenantDomain, RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY, properties);
        RecoveryInformationDTO recoveryInformationDTO = new RecoveryInformationDTO();
        String username = recoveryChannelInfoDTO.getUsername();
        recoveryInformationDTO.setUsername(username);
        recoveryInformationDTO.setNotificationBasedRecoveryEnabled(isNotificationBasedRecoveryEnabled);
        if (isNotificationBasedRecoveryEnabled) {
            recoveryInformationDTO.setRecoveryChannelInfoDTO(recoveryChannelInfoDTO);
        }
        if (isSkipRecoveryWithChallengeQuestionsForInsufficientAnswersEnabled) {
            recoveryInformationDTO.setQuestionBasedRecoveryAllowedForUser(isQuestionBasedRecoveryEnabled && this.isMinNoOfRecoveryQuestionsAnswered(username, tenantDomain));
        } else {
            recoveryInformationDTO.setQuestionBasedRecoveryAllowedForUser(isQuestionBasedRecoveryEnabled);
        }
        if (isPerUserFunctionalityLockingEnabled) {
            boolean isQuestionBasedRecoveryLocked = this.getFunctionalityStatusOfUser(tenantDomain, recoveryChannelInfoDTO.getUsername(), IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier()).getLockStatus();
            recoveryInformationDTO.setQuestionBasedRecoveryEnabled(!isQuestionBasedRecoveryLocked);
        } else {
            recoveryInformationDTO.setQuestionBasedRecoveryEnabled(isQuestionBasedRecoveryEnabled);
        }
        recoveryInformationDTO.setNotificationBasedRecoveryEnabled(isNotificationBasedRecoveryEnabled);
        return recoveryInformationDTO;
    }

    @Override
    public PasswordRecoverDTO notify(String recoveryCode, String channelId, String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        this.validateConfigurations(tenantDomain);
        int channelIDCode = this.validateChannelID(channelId);
        UserAccountRecoveryManager userAccountRecoveryManager = UserAccountRecoveryManager.getInstance();
        UserRecoveryData userRecoveryData = userAccountRecoveryManager.getUserRecoveryData(recoveryCode, RecoverySteps.SEND_RECOVERY_INFORMATION);
        String notificationChannel = this.extractNotificationChannelDetails(userRecoveryData.getRemainingSetIds(), channelIDCode);
        boolean manageNotificationsInternally = true;
        if (NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            manageNotificationsInternally = false;
        }
        NotificationResponseBean notificationResponseBean = this.notifyUser(userRecoveryData.getUser(), notificationChannel, manageNotificationsInternally, properties);
        String secretKey = notificationResponseBean.getKey();
        String resendCode = this.generateResendCode(notificationChannel, userRecoveryData);
        return this.buildPasswordRecoveryResponseDTO(notificationChannel, secretKey, resendCode);
    }

    @Override
    public PasswordResetCodeDTO confirm(String confirmationCode, String tenantDomain, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        UserAccountRecoveryManager userAccountRecoveryManager = UserAccountRecoveryManager.getInstance();
        UserRecoveryData userRecoveryData = userAccountRecoveryManager.getUserRecoveryData(confirmationCode, RecoverySteps.UPDATE_PASSWORD);
        if (!tenantDomain.equals(userRecoveryData.getUser().getTenantDomain())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_TENANT_DOMAIN_MISS_MATCH_WITH_CONTEXT, tenantDomain);
        }
        String domainQualifiedName = IdentityUtil.addDomainToName((String)userRecoveryData.getUser().getUserName(), (String)userRecoveryData.getUser().getUserStoreDomain());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Valid confirmation code for user: " + domainQualifiedName));
        }
        return this.buildPasswordResetCodeDTO(confirmationCode);
    }

    @Override
    public SuccessfulPasswordResetDTO reset(String resetCode, char[] password, Map<String, String> properties) throws IdentityRecoveryException {
        if (ArrayUtils.isEmpty((char[])password)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_PASSWORD_IN_REQUEST.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_PASSWORD_IN_REQUEST.getMessage(), null);
        }
        String newPassword = String.valueOf(password);
        NotificationPasswordRecoveryManager notificationPasswordRecoveryManager = NotificationPasswordRecoveryManager.getInstance();
        Property[] metaProperties = this.buildPropertyList(null, properties);
        try {
            notificationPasswordRecoveryManager.updatePassword(resetCode, newPassword, metaProperties);
        }
        catch (IdentityRecoveryServerException e) {
            String errorCode = Utils.prependOperationScenarioToErrorCode(e.getErrorCode(), "PWR");
            throw Utils.handleServerException(errorCode, e.getMessage(), null);
        }
        catch (IdentityRecoveryClientException e) {
            throw this.mapClientExceptionWithImprovedErrorCodes(e);
        }
        catch (IdentityEventException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PasswordRecoveryManagerImpl: Error while resetting password ", (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED_ERROR_PASSWORD_RESET.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED_ERROR_PASSWORD_RESET.getMessage(), null);
        }
        return this.buildSuccessfulPasswordUpdateDTO();
    }

    @Override
    public ResendConfirmationDTO resend(String tenantDomain, String resendCode, Map<String, String> properties) throws IdentityRecoveryException {
        this.validateTenantDomain(tenantDomain);
        Property[] metaProperties = this.buildPropertyList(null, properties);
        ResendConfirmationManager resendConfirmationManager = ResendConfirmationManager.getInstance();
        try {
            return resendConfirmationManager.resendConfirmation(tenantDomain, resendCode, RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY.name(), RecoverySteps.UPDATE_PASSWORD.name(), "resendPasswordReset", metaProperties);
        }
        catch (IdentityRecoveryException e) {
            e.setErrorCode(Utils.prependOperationScenarioToErrorCode(e.getErrorCode(), "PWR"));
            throw e;
        }
    }

    private IdentityRecoveryClientException mapClientExceptionWithImprovedErrorCodes(IdentityRecoveryClientException exception) {
        if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE.getCode().equals(exception.getErrorCode())) {
            exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RECOVERY_CODE.getCode());
        } else if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_CODE.getCode().equals(exception.getErrorCode())) {
            exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_RECOVERY_CODE.getCode());
        } else if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_HISTORY_VIOLATE.getCode().equals(exception.getErrorCode())) {
            exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_HISTORY_VIOLATION.getCode());
        } else if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_POLICY_VIOLATION.getCode().equals(exception.getErrorCode())) {
            exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_POLICY_VIOLATION.getCode());
        } else {
            exception.setErrorCode(Utils.prependOperationScenarioToErrorCode(exception.getErrorCode(), "PWR"));
        }
        return Utils.handleClientException(exception.getErrorCode(), exception.getMessage(), null);
    }

    private NotificationResponseBean notifyUser(User user, String notificationChannel, boolean manageNotificationInternally, Map<String, String> properties) throws IdentityRecoveryException {
        NotificationResponseBean notificationResponseBean;
        Property[] metaProperties = this.buildPropertyList(notificationChannel, properties);
        try {
            notificationResponseBean = NotificationPasswordRecoveryManager.getInstance().sendRecoveryNotification(user, null, manageNotificationInternally, metaProperties);
        }
        catch (IdentityRecoveryException exception) {
            if (StringUtils.isNotEmpty((String)exception.getErrorCode())) {
                String errorCode = exception.getErrorCode();
                if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID.getCode().equals(errorCode)) {
                    exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CALLBACK_PASSWORD_RESET.getCode());
                } else if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getCode().equals(errorCode)) {
                    exception.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED_ERROR_PASSWORD_RESET.getCode());
                }
                exception.setErrorCode(Utils.prependOperationScenarioToErrorCode(exception.getErrorCode(), "PWR"));
            }
            throw exception;
        }
        if (notificationResponseBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Empty Response while notifying password recovery information for user : " + user.getUserName()));
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNEXPECTED_ERROR_PASSWORD_RESET, null);
        }
        return notificationResponseBean;
    }

    private Property[] buildPropertyList(String notificationChannel, Map<String, String> properties) {
        ArrayList<Property> propertyArrayList = new ArrayList<Property>();
        if (MapUtils.isNotEmpty(properties)) {
            for (String key : properties.keySet()) {
                if (!StringUtils.isNotEmpty((String)key)) continue;
                propertyArrayList.add(this.buildProperty(key, properties.get(key)));
            }
        }
        if (StringUtils.isNotEmpty((String)notificationChannel)) {
            propertyArrayList.add(this.buildProperty("notificationChannel", notificationChannel));
        }
        propertyArrayList.add(this.buildProperty("verifiedUser", Boolean.toString(true)));
        return propertyArrayList.toArray(new Property[0]);
    }

    private Property buildProperty(String key, String value) {
        Property property = new Property();
        property.setKey(key);
        property.setValue(value);
        return property;
    }

    private SuccessfulPasswordResetDTO buildSuccessfulPasswordUpdateDTO() {
        SuccessfulPasswordResetDTO successfulPasswordResetDTO = new SuccessfulPasswordResetDTO();
        successfulPasswordResetDTO.setSuccessCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_PASSWORD_UPDATE.getCode());
        successfulPasswordResetDTO.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_SUCCESSFUL_PASSWORD_UPDATE.getMessage());
        return successfulPasswordResetDTO;
    }

    private int validateChannelID(String channelId) throws IdentityRecoveryClientException {
        int id;
        try {
            id = Integer.parseInt(channelId);
        }
        catch (NumberFormatException e) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        if (id < 1) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        return id;
    }

    private PasswordResetCodeDTO buildPasswordResetCodeDTO(String resetCode) {
        PasswordResetCodeDTO passwordResetCodeDTO = new PasswordResetCodeDTO();
        passwordResetCodeDTO.setPasswordResetCode(resetCode);
        return passwordResetCodeDTO;
    }

    private PasswordRecoverDTO buildPasswordRecoveryResponseDTO(String notificationChannel, String confirmationCode, String resendCode) {
        PasswordRecoverDTO passwordRecoverDTO = new PasswordRecoverDTO();
        passwordRecoverDTO.setNotificationChannel(notificationChannel);
        if (NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            passwordRecoverDTO.setConfirmationCode(confirmationCode);
        }
        passwordRecoverDTO.setResendCode(resendCode);
        passwordRecoverDTO.setCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_PASSWORD_RECOVERY_INTERNALLY_NOTIFIED.getCode());
        passwordRecoverDTO.setMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_PASSWORD_RECOVERY_INTERNALLY_NOTIFIED.getMessage());
        return passwordRecoverDTO;
    }

    private String extractNotificationChannelDetails(String recoveryChannels, int channelId) throws IdentityRecoveryException {
        String[] channels = recoveryChannels.split(",");
        if (channels.length < channelId) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHANNEL_ID, null);
        }
        String notificationChannel = channels[channelId - 1];
        String[] channelDetails = notificationChannel.split(":");
        return channelDetails[0];
    }

    private void validateConfigurations(String tenantDomain) throws IdentityRecoveryException {
        boolean isRecoveryEnable = Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.Password.Enable", tenantDomain));
        if (!isRecoveryEnable) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_RECOVERY_WITH_NOTIFICATIONS_NOT_ENABLED, null);
        }
    }

    private boolean isQuestionBasedRecoveryEnabled(String tenantDomain) throws IdentityRecoveryServerException {
        try {
            return Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Question.Password.Enable", tenantDomain));
        }
        catch (IdentityRecoveryServerException e) {
            String errorCode = Utils.prependOperationScenarioToErrorCode("PWR", e.getErrorCode());
            throw Utils.handleServerException(errorCode, e.getMessage(), null);
        }
    }

    private boolean isNotificationBasedRecoveryEnabled(String tenantDomain) throws IdentityRecoveryServerException {
        try {
            return Boolean.parseBoolean(Utils.getRecoveryConfigs("Recovery.Notification.Password.Enable", tenantDomain));
        }
        catch (IdentityRecoveryServerException e) {
            String errorCode = Utils.prependOperationScenarioToErrorCode("PWR", e.getErrorCode());
            throw Utils.handleServerException(errorCode, e.getMessage(), null);
        }
    }

    private String generateResendCode(String notificationChannel, UserRecoveryData userRecoveryData) throws IdentityRecoveryServerException {
        String resendCode = UUIDGenerator.generateUUID();
        this.addRecoveryDataObject(resendCode, notificationChannel, userRecoveryData.getUser());
        return resendCode;
    }

    private void addRecoveryDataObject(String secretKey, String recoveryData, User user) throws IdentityRecoveryServerException {
        UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY, RecoverySteps.RESEND_CONFIRMATION_CODE);
        recoveryDataDO.setRemainingSetIds(recoveryData);
        try {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.store(recoveryDataDO);
        }
        catch (IdentityRecoveryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_STORING_RECOVERY_DATA, "Error Storing Recovery Data", (Throwable)((Object)e));
        }
    }

    private void validateTenantDomain(String tenantDomain) throws IdentityRecoveryClientException {
        if (StringUtils.isBlank((String)tenantDomain)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_RECOVERY_EMPTY_TENANT_DOMAIN.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_RECOVERY_EMPTY_TENANT_DOMAIN.getMessage(), null);
        }
    }

    private FunctionalityLockStatus getFunctionalityStatusOfUser(String tenantDomain, String userName, String functionalityIdentifier) throws IdentityRecoveryServerException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String userId = Utils.getUserId(userName, tenantId);
        UserFunctionalityManager userFunctionalityManager = IdentityRecoveryServiceDataHolder.getInstance().getUserFunctionalityManagerService();
        try {
            return userFunctionalityManager.getLockStatus(userId, tenantId, functionalityIdentifier);
        }
        catch (UserFunctionalityManagementException e) {
            String mappedErrorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getCode(), "PWR");
            StringBuilder message = new StringBuilder(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getMessage());
            if (isDetailedErrorMessagesEnabled) {
                message.append(String.format("functionality: %s for %s.", IdentityRecoveryConstants.FunctionalityTypes.FUNCTIONALITY_SECURITY_QUESTION_PW_RECOVERY.getFunctionalityIdentifier(), userName));
            }
            throw Utils.handleServerException(mappedErrorCode, message.toString(), null);
        }
    }

    private boolean isMinNoOfRecoveryQuestionsAnswered(String username, String tenantDomain) throws IdentityRecoveryException {
        User user = Utils.buildUser(username, tenantDomain);
        ChallengeQuestionManager challengeQuestionManager = ChallengeQuestionManager.getInstance();
        String[] ids = challengeQuestionManager.getUserChallengeQuestionIds(user);
        boolean isMinNoOfRecoveryQuestionsAnswered = false;
        if (ids != null) {
            int minNoOfQuestionsToAnswer = Integer.parseInt(Utils.getRecoveryConfigs("Recovery.Question.Password.MinAnswers", tenantDomain));
            boolean bl = isMinNoOfRecoveryQuestionsAnswered = ids.length >= minNoOfQuestionsToAnswer;
            if (isMinNoOfRecoveryQuestionsAnswered && log.isDebugEnabled()) {
                log.debug((Object)String.format("User: %s in tenant domain %s has set answers for at least the minimum number of questions with answers required for password recovery.", username, tenantDomain));
            }
        }
        return isMinNoOfRecoveryQuestionsAnswered;
    }
}

