/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.internal.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.dto.NotificationChannelDTO;
import org.wso2.carbon.identity.recovery.dto.RecoveryChannelInfoDTO;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.NotificationChannel;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.identity.user.functionality.mgt.exception.UserFunctionalityManagementException;
import org.wso2.carbon.identity.user.functionality.mgt.model.FunctionalityLockStatus;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class UserAccountRecoveryManager {
    private static final Log log = LogFactory.getLog(UserAccountRecoveryManager.class);
    private static UserAccountRecoveryManager instance = new UserAccountRecoveryManager();
    private static final String FORWARD_SLASH = "/";
    private static final NotificationChannels[] notificationChannels = new NotificationChannels[]{NotificationChannels.EMAIL_CHANNEL, NotificationChannels.SMS_CHANNEL};
    private static final boolean PER_USER_FUNCTIONALITY_LOCKING_ENABLED = Utils.isPerUserFunctionalityLockingEnabled();
    private static final String FUNCTIONALITY_PREFIX = "FUNCTIONALITY_";

    private UserAccountRecoveryManager() {
    }

    public static UserAccountRecoveryManager getInstance() {
        return instance;
    }

    public RecoveryChannelInfoDTO retrieveUserRecoveryInformation(Map<String, String> claims, String tenantDomain, RecoveryScenarios recoveryScenario, Map<String, String> properties) throws IdentityRecoveryException {
        String username = this.getUsernameByClaims(claims, tenantDomain);
        if (StringUtils.isNotEmpty((String)username)) {
            User user = Utils.buildUser(username, tenantDomain);
            this.checkAccountLockedStatus(user);
            boolean isNotificationsInternallyManaged = Utils.isNotificationsInternallyManaged(tenantDomain, properties);
            List<NotificationChannel> notificationChannels = isNotificationsInternallyManaged ? this.getInternalNotificationChannelList(username, tenantDomain, recoveryScenario) : this.getExternalNotificationChannelList();
            this.checkUserValidityForAccountRecovery(user, recoveryScenario, notificationChannels, properties);
            String recoveryCode = UUIDGenerator.generateUUID();
            return this.buildUserRecoveryInformationResponseDTO(username, recoveryCode, this.getNotificationChannelsResponseDTOList(username, recoveryCode, tenantDomain, notificationChannels, recoveryScenario));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No valid user found for the given claims");
        }
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_USER_FOUND, null);
    }

    private void checkAccountLockedStatus(User user) throws IdentityRecoveryException {
        if (Utils.isAccountDisabled(user)) {
            String errorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT.getCode(), "UAR");
            throw Utils.handleClientException(errorCode, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DISABLED_ACCOUNT.getMessage(), user.getUserName());
        }
        if (Utils.isAccountLocked(user)) {
            String errorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT.getCode(), "UAR");
            throw Utils.handleClientException(errorCode, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_LOCKED_ACCOUNT.getMessage(), user.getUserName());
        }
    }

    private void checkUserValidityForAccountRecovery(User user, RecoveryScenarios recoveryScenario, List<NotificationChannel> recoveryNotificationChannels, Map<String, String> metaProperties) throws IdentityRecoveryException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER", user);
        properties.put("userStoreManager", this.getUserStoreManager(user));
        properties.put("RECOVERY_SCENARIO", (Object)recoveryScenario);
        properties.put("notification-channel", recoveryNotificationChannels);
        if (MapUtils.isNotEmpty(metaProperties)) {
            for (Map.Entry<String, String> metaProperty : metaProperties.entrySet()) {
                if (!StringUtils.isNotBlank((String)metaProperty.getValue()) || !StringUtils.isNotBlank((String)metaProperty.getKey())) continue;
                properties.put(metaProperty.getKey(), metaProperty.getValue());
            }
        }
        Event identityMgtEvent = new Event("PRE_ACCOUNT_RECOVERY", properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occurred while validating user account " + user.getUserName() + " for account recovery."));
            }
            String errorMessage = e.getMessage();
            String errorCode = IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_ACCOUNT_RECOVERY_VALIDATION_FAILED.getCode();
            if (RecoveryScenarios.USERNAME_RECOVERY.equals((Object)recoveryScenario)) {
                errorCode = IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USERNAME_RECOVERY_VALIDATION_FAILED.getCode();
            } else if (RecoveryScenarios.NOTIFICATION_BASED_PW_RECOVERY.equals((Object)recoveryScenario) || RecoveryScenarios.QUESTION_BASED_PWD_RECOVERY.equals((Object)recoveryScenario)) {
                errorCode = IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PASSWORD_RECOVERY_VALIDATION_FAILED.getCode();
            }
            throw Utils.handleClientException(errorCode, errorMessage, user.getUserName());
        }
    }

    public String getUsernameByClaims(Map<String, String> claims, String tenantDomain) throws IdentityRecoveryException {
        if (MapUtils.isEmpty(claims)) {
            String errorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_FIELD_FOUND_FOR_USER_RECOVERY.getCode(), "UAR");
            throw Utils.handleClientException(errorCode, IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_FIELD_FOUND_FOR_USER_RECOVERY.getMessage(), null);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        Object[] resultedUserList = ArrayUtils.EMPTY_STRING_ARRAY;
        for (String key : claims.keySet()) {
            Object[] matchedUserList;
            String value = claims.get(key);
            if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
            if (log.isDebugEnabled()) {
                String message = String.format("Searching users by claim : %s for value : %s", key, value);
                log.debug((Object)message);
            }
            if (!ArrayUtils.isEmpty((Object[])(matchedUserList = this.getUserList(tenantId, key, value)))) {
                if (ArrayUtils.isNotEmpty((Object[])resultedUserList)) {
                    if (!ArrayUtils.isEmpty((Object[])(resultedUserList = this.getCommonUserEntries((String[])resultedUserList, (String[])matchedUserList, key, value)))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No user matched for given claims");
                    }
                    return "";
                }
                resultedUserList = matchedUserList;
                continue;
            }
            if (log.isDebugEnabled()) {
                String message = String.format("No users matched for claim : %s for value : %s", key, value);
                log.debug((Object)message);
            }
            return "";
        }
        if (ArrayUtils.isNotEmpty((Object[])resultedUserList) && resultedUserList.length == 1) {
            return resultedUserList[0];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Multiple users matched for given claims set : " + Arrays.toString(resultedUserList)));
        }
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_MULTIPLE_MATCHING_USERS, null);
    }

    private List<NotificationChannel> getExternalNotificationChannelList() {
        NotificationChannel channelDataModel = new NotificationChannel();
        channelDataModel.setType(NotificationChannels.EXTERNAL_CHANNEL.getChannelType());
        ArrayList<NotificationChannel> notificationChannels = new ArrayList<NotificationChannel>();
        notificationChannels.add(channelDataModel);
        return notificationChannels;
    }

    private List<NotificationChannel> getInternalNotificationChannelList(String username, String tenantDomain, RecoveryScenarios recoveryScenarios) throws IdentityRecoveryClientException, IdentityRecoveryException {
        String[] requiredClaims = this.createRequiredChannelClaimsList();
        Map<String, String> claimValues = this.getClaimListOfUser(username, tenantDomain, requiredClaims);
        if (MapUtils.isEmpty(claimValues)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS_FOR_USER, null);
        }
        List<NotificationChannel> notificationChannels = this.getNotificationChannelDetails(username, tenantDomain, claimValues, recoveryScenarios);
        if (notificationChannels.size() == 0) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_VERIFIED_CHANNELS_FOR_USER, null);
        }
        return notificationChannels;
    }

    private RecoveryChannelInfoDTO buildUserRecoveryInformationResponseDTO(String username, String recoveryCode, NotificationChannelDTO[] notificationChannelDTOs) {
        RecoveryChannelInfoDTO recoveryChannelInfoDTO = new RecoveryChannelInfoDTO();
        recoveryChannelInfoDTO.setUsername(username);
        recoveryChannelInfoDTO.setRecoveryCode(recoveryCode);
        recoveryChannelInfoDTO.setNotificationChannelDTOs(notificationChannelDTOs);
        return recoveryChannelInfoDTO;
    }

    private NotificationChannelDTO[] getNotificationChannelsResponseDTOList(String userName, String recoveryID, String tenantDomain, List<NotificationChannel> notificationChannels, RecoveryScenarios recoveryScenario) throws IdentityRecoveryException {
        ArrayList<NotificationChannelDTO> notificationChannelDTOs = new ArrayList<NotificationChannelDTO>();
        int channelId = 1;
        StringBuilder recoveryChannels = new StringBuilder();
        for (NotificationChannel channel : notificationChannels) {
            NotificationChannelDTO dto = this.buildNotificationChannelsResponseDTO(channelId, channel.getType(), channel.getChannelValue(), channel.isPreferredStatus(), tenantDomain);
            notificationChannelDTOs.add(dto);
            String channelEntry = channel.getType() + ":" + channel.getChannelValue();
            recoveryChannels.append(channelEntry).append(",");
            ++channelId;
        }
        this.addRecoveryDataObject(userName, tenantDomain, recoveryID, recoveryScenario, recoveryChannels.toString());
        return notificationChannelDTOs.toArray(new NotificationChannelDTO[0]);
    }

    private NotificationChannelDTO buildNotificationChannelsResponseDTO(int channelId, String channelType, String value, boolean preference, String tenantDomain) throws IdentityRecoveryServerException {
        NotificationChannelDTO notificationChannelDTO = new NotificationChannelDTO();
        notificationChannelDTO.setId(channelId);
        notificationChannelDTO.setType(channelType);
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(channelType)) {
            notificationChannelDTO.setValue(this.maskEmailAddress(value, tenantDomain));
        } else if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(channelType)) {
            notificationChannelDTO.setValue(this.maskMobileNumber(value));
        } else {
            notificationChannelDTO.setValue(value);
        }
        notificationChannelDTO.setPreferred(preference);
        return notificationChannelDTO;
    }

    private String maskMobileNumber(String mobile) {
        if (StringUtils.isNotEmpty((String)mobile)) {
            mobile = mobile.replaceAll(".(?=.{4})", "*");
        }
        return mobile;
    }

    private String maskEmailAddress(String email, String tenantDomain) throws IdentityRecoveryServerException {
        String emailMaskingRegex;
        String claimURI = "http://wso2.org/claims/emailaddress";
        try {
            emailMaskingRegex = IdentityRecoveryServiceDataHolder.getInstance().getClaimMetadataManagementService().getMaskingRegexForLocalClaim(claimURI, tenantDomain);
        }
        catch (ClaimMetadataException e) {
            throw new IdentityRecoveryServerException(String.format("Error while retrieving masking regex pattern for claim URI: %s in tenant domain: %s", claimURI, tenantDomain), e);
        }
        if (StringUtils.isBlank((String)emailMaskingRegex)) {
            emailMaskingRegex = "(?<=.)[^@](?=[^@]*?@)|(?:(?<=@.)|(?!^)\\G(?=[^@]*$)).(?=.*[^@]\\.)";
        }
        if (StringUtils.isNotEmpty((String)email)) {
            email = email.replaceAll(emailMaskingRegex, "*");
        }
        return email;
    }

    private String[] getUserList(int tenantId, String claimUri, String claimValue) throws IdentityRecoveryServerException {
        String[] userList = new String[]{};
        UserStoreManager userStoreManager = this.getUserStoreManager(tenantId);
        try {
            if (userStoreManager != null) {
                String extractedDomain;
                UserStoreManager secondaryUserStoreManager;
                if (StringUtils.isNotBlank((String)claimValue) && claimValue.contains(FORWARD_SLASH) && (secondaryUserStoreManager = userStoreManager.getSecondaryUserStoreManager(extractedDomain = IdentityUtil.extractDomainFromName((String)claimValue))) == null) {
                    claimValue = FORWARD_SLASH + claimValue;
                }
                userList = userStoreManager.getUserList(claimUri, claimValue, null);
            }
            return userList;
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                String error = String.format("Unable to retrieve the claim : %1$s for the given tenant : %2$s", claimUri, tenantId);
                log.debug((Object)error, (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_USER_CLAIM, claimUri, e);
        }
    }

    private UserStoreManager getUserStoreManager(int tenantId) throws IdentityRecoveryServerException {
        UserStoreManager userStoreManager;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            if (realmService.getTenantUserRealm(tenantId) == null) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER, null);
            }
            userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                String error = String.format("Error retrieving the user store manager for the tenant : %s", tenantId);
                log.debug((Object)error, (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER, null, e);
        }
        return userStoreManager;
    }

    private UserStoreManager getUserStoreManager(User user) throws IdentityRecoveryException {
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            UserRealm tenantUserRealm = realmService.getTenantUserRealm(IdentityTenantUtil.getTenantId((String)user.getTenantDomain()));
            if (IdentityUtil.getPrimaryDomainName().equals(user.getUserStoreDomain())) {
                return (UserStoreManager)tenantUserRealm.getUserStoreManager();
            }
            return ((UserStoreManager)tenantUserRealm.getUserStoreManager()).getSecondaryUserStoreManager(user.getUserStoreDomain());
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                String error = String.format("Error retrieving the user store manager for the user : %s", user.getUserName());
                log.debug((Object)error, (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER, null, e);
        }
    }

    private String[] getCommonUserEntries(String[] resultedUserList, String[] matchedUserList, String claim, String value) {
        ArrayList<String> matchedUsers = new ArrayList<String>(Arrays.asList(matchedUserList));
        ArrayList<String> resultedUsers = new ArrayList<String>(Arrays.asList(resultedUserList));
        resultedUsers.retainAll(matchedUsers);
        if (resultedUsers.size() > 0) {
            resultedUserList = resultedUsers.toArray(new String[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current matching temporary user list :" + Arrays.toString(resultedUserList)));
            }
            return resultedUserList;
        }
        if (log.isDebugEnabled()) {
            String message = String.format("There are no common users for claim : %1$s with the value : %2$s with the previously filtered user list", claim, value);
            log.debug((Object)message);
        }
        return new String[0];
    }

    private Map<String, String> getClaimListOfUser(String username, String tenantDomain, String[] requiredClaimURLs) throws IdentityRecoveryException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        UserStoreManager userStoreManager = this.getUserStoreManager(tenantId);
        Map claimValues = null;
        try {
            if (userStoreManager != null) {
                claimValues = userStoreManager.getUserClaimValues(username, requiredClaimURLs, null);
            }
        }
        catch (UserStoreException e) {
            String error = String.format("Error getting claims of user : %1$s in tenant domain : %2$s", username, tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)error, (Throwable)e);
            }
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_LOADING_USER_CLAIMS, null);
        }
        return claimValues;
    }

    private String[] createRequiredChannelClaimsList() {
        ArrayList<String> requiredClaims = new ArrayList<String>();
        for (NotificationChannels channel : notificationChannels) {
            requiredClaims.add(channel.getClaimUri());
            requiredClaims.add(channel.getVerifiedClaimUrl());
        }
        requiredClaims.add("http://wso2.org/claims/identity/preferredChannel");
        requiredClaims.add("http://wso2.org/claims/role");
        return requiredClaims.toArray(new String[0]);
    }

    private List<NotificationChannel> getNotificationChannelDetails(String username, String tenantDomain, Map<String, String> claimValues, RecoveryScenarios recoveryScenarios) throws IdentityRecoveryServerException {
        boolean isSelfRegisteredUser = this.isSelfSignUpUser(claimValues.get("http://wso2.org/claims/role"));
        String preferredChannel = claimValues.get("http://wso2.org/claims/identity/preferredChannel");
        ArrayList<NotificationChannel> verifiedChannels = new ArrayList<NotificationChannel>();
        for (NotificationChannels channel : notificationChannels) {
            String channelValue = claimValues.get(channel.getClaimUri());
            boolean channelVerified = Boolean.parseBoolean(claimValues.get(channel.getVerifiedClaimUrl()));
            boolean isFunctionalityLocked = this.isFunctionalityLocked(username, tenantDomain, channel.getChannelType(), recoveryScenarios);
            NotificationChannel channelDataModel = new NotificationChannel();
            if (!isFunctionalityLocked && isSelfRegisteredUser && channelVerified && StringUtils.isNotEmpty((String)channelValue)) {
                channelDataModel.setType(channel.getChannelType());
                channelDataModel.setChannelValue(channelValue);
                if (StringUtils.isNotEmpty((String)preferredChannel) && channel.getChannelType().equals(preferredChannel)) {
                    channelDataModel.setPreferredStatus(true);
                }
                verifiedChannels.add(channelDataModel);
                continue;
            }
            if (isFunctionalityLocked || !StringUtils.isNotEmpty((String)channelValue)) continue;
            channelDataModel.setType(channel.getChannelType());
            channelDataModel.setChannelValue(channelValue);
            if (StringUtils.isNotEmpty((String)preferredChannel) && channel.getChannelType().equals(preferredChannel)) {
                channelDataModel.setPreferredStatus(true);
            }
            verifiedChannels.add(channelDataModel);
        }
        return verifiedChannels;
    }

    private boolean isFunctionalityLocked(String username, String tenantDomain, String channelType, RecoveryScenarios recoveryScenarios) throws IdentityRecoveryServerException {
        String functionalityType;
        if (PER_USER_FUNCTIONALITY_LOCKING_ENABLED && IdentityRecoveryConstants.FunctionalityTypes.getFunctionality(functionalityType = FUNCTIONALITY_PREFIX + recoveryScenarios.name() + "_" + channelType) != null) {
            String functionalityIdentifier = IdentityRecoveryConstants.FunctionalityTypes.getFunctionality(functionalityType).getFunctionalityIdentifier();
            FunctionalityLockStatus functionalityLockStatus = this.getFunctionalityStatusOfUser(username, tenantDomain, functionalityIdentifier);
            return functionalityLockStatus.getLockStatus();
        }
        return false;
    }

    private FunctionalityLockStatus getFunctionalityStatusOfUser(String userName, String tenantDomain, String functionalityIdentifier) throws IdentityRecoveryServerException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        String userId = Utils.getUserId(userName, tenantId);
        UserFunctionalityManager userFunctionalityManager = IdentityRecoveryServiceDataHolder.getInstance().getUserFunctionalityManagerService();
        try {
            return userFunctionalityManager.getLockStatus(userId, tenantId, functionalityIdentifier);
        }
        catch (UserFunctionalityManagementException e) {
            String mappedErrorCode = Utils.prependOperationScenarioToErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getCode(), "PWR");
            String message = IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_GET_LOCK_STATUS_FOR_FUNCTIONALITY.getMessage();
            throw Utils.handleServerException(mappedErrorCode, message, null);
        }
    }

    private boolean isSelfSignUpUser(String rolesList) {
        List<String> roles = Arrays.asList(rolesList.split(","));
        return roles.contains("Internal/selfsignup");
    }

    public UserRecoveryData getUserRecoveryData(String code, RecoverySteps step) throws IdentityRecoveryException {
        UserRecoveryData recoveryData;
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            recoveryData = userRecoveryDataStore.load(code);
        }
        catch (IdentityRecoveryException e) {
            if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CODE.getCode().equals(e.getErrorCode())) {
                e.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RECOVERY_CODE.getCode());
            } else if (IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_CODE.getCode().equals(e.getErrorCode())) {
                e.setErrorCode(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_EXPIRED_RECOVERY_CODE.getCode());
            } else {
                e.setErrorCode(Utils.prependOperationScenarioToErrorCode(e.getErrorCode(), "UAR"));
            }
            throw e;
        }
        if (recoveryData == null) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_ACCOUNT_RECOVERY_DATA, code);
        }
        if (!step.equals(recoveryData.getRecoveryStep())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RECOVERY_CODE, code);
        }
        return recoveryData;
    }

    private void addRecoveryDataObject(String username, String tenantDomain, String secretKey, RecoveryScenarios scenario, String recoveryData) throws IdentityRecoveryServerException {
        User user = Utils.buildUser(username, tenantDomain);
        UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, scenario, RecoverySteps.SEND_RECOVERY_INFORMATION);
        recoveryDataDO.setRemainingSetIds(recoveryData);
        try {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.invalidate(user);
            userRecoveryDataStore.store(recoveryDataDO);
        }
        catch (IdentityRecoveryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_STORING_RECOVERY_DATA, "Error Storing Recovery Data", (Throwable)((Object)e));
        }
    }
}

