/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthenticationHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.consent.mgt.services.ConsentUtilityService;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.handler.event.account.lock.service.AccountLockService;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.confirmation.ResendConfirmationManager;
import org.wso2.carbon.identity.recovery.connector.AdminForcedPasswordResetConfigImpl;
import org.wso2.carbon.identity.recovery.connector.LiteRegistrationConfigImpl;
import org.wso2.carbon.identity.recovery.connector.RecoveryConfigImpl;
import org.wso2.carbon.identity.recovery.connector.SelfRegistrationConfigImpl;
import org.wso2.carbon.identity.recovery.connector.UserClaimUpdateConfigImpl;
import org.wso2.carbon.identity.recovery.connector.UserEmailVerificationConfigImpl;
import org.wso2.carbon.identity.recovery.handler.AccountConfirmationValidationHandler;
import org.wso2.carbon.identity.recovery.handler.AdminForcedPasswordResetHandler;
import org.wso2.carbon.identity.recovery.handler.ChallengeAnswerValidationHandler;
import org.wso2.carbon.identity.recovery.handler.CodeInvalidationHandler;
import org.wso2.carbon.identity.recovery.handler.IdentityUserMetadataMgtHandler;
import org.wso2.carbon.identity.recovery.handler.LiteUserRegistrationHandler;
import org.wso2.carbon.identity.recovery.handler.MobileNumberVerificationHandler;
import org.wso2.carbon.identity.recovery.handler.TenantRegistrationVerificationHandler;
import org.wso2.carbon.identity.recovery.handler.UserEmailVerificationHandler;
import org.wso2.carbon.identity.recovery.handler.UserSelfRegistrationHandler;
import org.wso2.carbon.identity.recovery.handler.request.PostAuthnMissingChallengeQuestionsHandler;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.internal.service.impl.password.PasswordRecoveryManagerImpl;
import org.wso2.carbon.identity.recovery.internal.service.impl.username.UsernameRecoveryManagerImpl;
import org.wso2.carbon.identity.recovery.listener.TenantManagementListener;
import org.wso2.carbon.identity.recovery.password.NotificationPasswordRecoveryManager;
import org.wso2.carbon.identity.recovery.password.SecurityQuestionPasswordRecoveryManager;
import org.wso2.carbon.identity.recovery.services.password.PasswordRecoveryManager;
import org.wso2.carbon.identity.recovery.services.username.UsernameRecoveryManager;
import org.wso2.carbon.identity.recovery.signup.UserSelfRegistrationManager;
import org.wso2.carbon.identity.recovery.username.NotificationUsernameRecoveryManager;
import org.wso2.carbon.identity.user.functionality.mgt.UserFunctionalityManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceComponent", immediate=true)
public class IdentityRecoveryServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityRecoveryServiceComponent.class);
    private IdentityRecoveryServiceDataHolder dataHolder = IdentityRecoveryServiceDataHolder.getInstance();

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(NotificationPasswordRecoveryManager.class.getName(), (Object)NotificationPasswordRecoveryManager.getInstance(), null);
            bundleContext.registerService(SecurityQuestionPasswordRecoveryManager.class.getName(), (Object)SecurityQuestionPasswordRecoveryManager.getInstance(), null);
            bundleContext.registerService(NotificationUsernameRecoveryManager.class.getName(), (Object)NotificationUsernameRecoveryManager.getInstance(), null);
            bundleContext.registerService(UserSelfRegistrationManager.class.getName(), (Object)UserSelfRegistrationManager.getInstance(), null);
            bundleContext.registerService(ChallengeQuestionManager.class.getName(), (Object)ChallengeQuestionManager.getInstance(), null);
            bundleContext.registerService(ResendConfirmationManager.class.getName(), (Object)ResendConfirmationManager.getInstance(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new AccountConfirmationValidationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new UserSelfRegistrationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new LiteUserRegistrationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new UserEmailVerificationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new MobileNumberVerificationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new AdminForcedPasswordResetHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new TenantRegistrationVerificationHandler(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new IdentityUserMetadataMgtHandler(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new RecoveryConfigImpl(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new SelfRegistrationConfigImpl(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new LiteRegistrationConfigImpl(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new UserEmailVerificationConfigImpl(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new UserClaimUpdateConfigImpl(), null);
            bundleContext.registerService(IdentityConnectorConfig.class.getName(), (Object)new AdminForcedPasswordResetConfigImpl(), null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new CodeInvalidationHandler(), null);
            UsernameRecoveryManagerImpl usernameRecoveryManager = new UsernameRecoveryManagerImpl();
            bundleContext.registerService(UsernameRecoveryManager.class.getName(), (Object)usernameRecoveryManager, null);
            PasswordRecoveryManagerImpl passwordRecoveryManager = new PasswordRecoveryManagerImpl();
            bundleContext.registerService(PasswordRecoveryManager.class.getName(), (Object)passwordRecoveryManager, null);
            PostAuthnMissingChallengeQuestionsHandler postAuthnMissingChallengeQuestions = PostAuthnMissingChallengeQuestionsHandler.getInstance();
            bundleContext.registerService(PostAuthenticationHandler.class.getName(), (Object)postAuthnMissingChallengeQuestions, null);
            bundleContext.registerService(AbstractEventHandler.class.getName(), (Object)new ChallengeAnswerValidationHandler(), null);
        }
        catch (Exception e) {
            log.error((Object)"Error while activating identity governance component.", (Throwable)e);
        }
        TenantManagementListener tenantMgtListener = new TenantManagementListener();
        context.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)tenantMgtListener, null);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading default challenge questions for super tenant.");
            }
            this.loadDefaultChallengeQuestions();
        }
        catch (IdentityRecoveryException e) {
            log.error((Object)"Error persisting challenge question for super tenant.", (Throwable)((Object)e));
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management bundle is de-activated");
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        this.dataHolder.setRealmService(realmService);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRealmService(RealmService realmService) {
        log.debug((Object)"UnSetting the Realm Service");
        this.dataHolder.setRealmService(null);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        log.debug((Object)"UnSetting the Registry Service");
        this.dataHolder.setRegistryService(null);
    }

    protected void unsetIdentityEventService(IdentityEventService identityEventService) {
        IdentityRecoveryServiceDataHolder.getInstance().setIdentityEventService(null);
    }

    @Reference(name="IdentityEventService", service=IdentityEventService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityEventService")
    protected void setIdentityEventService(IdentityEventService identityEventService) {
        IdentityRecoveryServiceDataHolder.getInstance().setIdentityEventService(identityEventService);
    }

    protected void unsetIdentityGovernanceService(IdentityGovernanceService idpManager) {
        this.dataHolder.setIdentityGovernanceService(null);
    }

    @Reference(name="IdentityGovernanceService", service=IdentityGovernanceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceService")
    protected void setIdentityGovernanceService(IdentityGovernanceService idpManager) {
        this.dataHolder.setIdentityGovernanceService(idpManager);
    }

    protected void unsetResourceMgtService(RegistryResourceMgtService registryResourceMgtService) {
        this.dataHolder.setResourceMgtService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Identity Resource Mgt service.");
        }
    }

    @Reference(name="RegistryResourceMgtService", service=RegistryResourceMgtService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetResourceMgtService")
    protected void setResourceMgtService(RegistryResourceMgtService registryResourceMgtService) {
        this.dataHolder.setResourceMgtService(registryResourceMgtService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting Identity Resource Mgt service.");
        }
    }

    @Reference(name="AccountLockService", service=AccountLockService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAccountLockService")
    protected void setAccountLockService(AccountLockService accountLockService) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setAccountLockService(accountLockService);
    }

    protected void unsetAccountLockService(AccountLockService accountLockService) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setAccountLockService(null);
    }

    @Reference(name="ConsentManager", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentMgtService")
    protected void setConsentMgtService(ConsentManager consentManager) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setConsentManager(consentManager);
    }

    protected void unsetConsentMgtService(ConsentManager consentManager) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setConsentManager(null);
    }

    @Reference(name="ConsentUtilityService", service=ConsentUtilityService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentUtilityService")
    protected void setConsentUtilityService(ConsentUtilityService utilityService) {
        this.dataHolder.setConsentUtilityService(utilityService);
    }

    protected void unsetConsentUtilityService(ConsentUtilityService utilityService) {
        this.dataHolder.setConsentUtilityService(null);
    }

    @Reference(name="UserFunctionalityManager", service=UserFunctionalityManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserFunctionalityMgtService")
    protected void setUserFunctionalityManagerService(UserFunctionalityManager userFunctionalityManager) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setUserFunctionalityManagerService(userFunctionalityManager);
    }

    protected void unsetUserFunctionalityMgtService(UserFunctionalityManager userFunctionalityManager) {
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setUserFunctionalityManagerService(null);
    }

    @Reference(name="claim.meta.mgt.service", service=ClaimMetadataManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimMetaMgtService")
    protected void setClaimMetaMgtService(ClaimMetadataManagementService claimMetaMgtService) {
        IdentityRecoveryServiceDataHolder.getInstance().setClaimMetadataManagementService(claimMetaMgtService);
    }

    protected void unsetClaimMetaMgtService(ClaimMetadataManagementService claimMetaMgtService) {
        IdentityRecoveryServiceDataHolder.getInstance().setClaimMetadataManagementService(null);
    }

    private void loadDefaultChallengeQuestions() throws IdentityRecoveryException {
        String tenantDomain = "carbon.super";
        ChallengeQuestionManager.getInstance().setDefaultChallengeQuestions(tenantDomain);
    }

    @Reference(name="carbon.configuration.mgt.component", service=ConfigurationManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationManager")
    protected void setConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Manager service is set in the Template Manager component.");
        }
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setConfigurationManager(configurationManager);
    }

    protected void unsetConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Manager service is unset in the Template Manager component.");
        }
        IdentityRecoveryServiceComponent identityRecoveryServiceComponent = this;
        identityRecoveryServiceComponent.dataHolder.getInstance().setConfigurationManager(null);
    }
}

