/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.mgt.util.Utils;
import org.wso2.carbon.identity.recovery.ChallengeQuestionManager;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.model.UserChallengeAnswer;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class PostAuthnMissingChallengeQuestionsHandler
extends AbstractPostAuthnHandler {
    private static final String CHALLENGE_QUESTIONS_REQUESTED = "challengeQuestionsRequested";
    private static final String SELECTED_CHALLENGE_QUESTION_PREFIX = "Q-";
    private static final String CHALLENGE_QUESTION_ANSWER_PREFIX = "A-";
    private static final Log log = LogFactory.getLog(PostAuthnMissingChallengeQuestionsHandler.class);
    private static volatile PostAuthnMissingChallengeQuestionsHandler instance = new PostAuthnMissingChallengeQuestionsHandler();

    public static PostAuthnMissingChallengeQuestionsHandler getInstance() {
        return instance;
    }

    private PostAuthnMissingChallengeQuestionsHandler() {
    }

    public PostAuthnHandlerFlowStatus handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationContext authenticationContext) throws PostAuthenticationFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Post authentication handling for missing security questions has started");
        }
        if (authenticationContext == null || authenticationContext.getSequenceConfig() == null || authenticationContext.getSequenceConfig().getAuthenticatedUser() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication context or sequence config or authenticated user is null.");
            }
            return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
        }
        String forceChallengeQuestionConfig = this.getResidentIdpProperty(authenticationContext.getTenantDomain(), "Recovery.Question.Password.Forced.Enable");
        String minimumForcedChallengeQuestionsAnswered = this.getResidentIdpProperty(authenticationContext.getTenantDomain(), "Recovery.Question.MinQuestionsToAnswer");
        if (StringUtils.isBlank((String)forceChallengeQuestionConfig)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resident IdP value not found for Recovery.Question.Password.Forced.Enable hence exiting from PostAuthnMissingChallengeQuestionsHandler");
            }
            return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
        }
        if (Boolean.parseBoolean(forceChallengeQuestionConfig)) {
            AuthenticatedUser user = this.getAuthenticatedUser(authenticationContext);
            if (user == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No authenticated user found. Hence returning without handling missing security questions");
                }
                return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
            }
            if (user.isFederatedUser()) {
                return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
            }
            if (this.isChallengeQuestionsProvided(user, minimumForcedChallengeQuestionsAnswered)) {
                return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
            }
            boolean challengeQuestionsRequested = this.isChallengeQuestionRequested(authenticationContext);
            if (challengeQuestionsRequested) {
                return this.handleMissingChallengeQuestionResponse(httpServletRequest, user);
            }
            return this.handleMissingChallengeQuestionRequest(httpServletResponse, authenticationContext, user);
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private AuthenticatedUser getAuthenticatedUser(AuthenticationContext authenticationContext) {
        return authenticationContext.getSequenceConfig().getAuthenticatedUser();
    }

    private boolean isChallengeQuestionRequested(AuthenticationContext authenticationContext) {
        return authenticationContext.getParameter((Object)CHALLENGE_QUESTIONS_REQUESTED) == Boolean.TRUE;
    }

    private void setChallengeQuestionRequestedState(AuthenticationContext authenticationContext) {
        authenticationContext.addParameter((Object)CHALLENGE_QUESTIONS_REQUESTED, (Object)true);
    }

    public String getName() {
        return "PostAuthnMissingChallengeQuestionsHandler";
    }

    private String getResidentIdpProperty(String tenantDomain, String key) {
        try {
            IdentityProviderProperty[] idpProps;
            IdentityProvider residentIdp = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
            for (IdentityProviderProperty property : idpProps = residentIdp.getIdpProperties()) {
                if (!StringUtils.equals((String)property.getName(), (String)key)) continue;
                return property.getValue();
            }
            return "";
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Resident IdP value not found. Error while retrieving resident IdP property for force challenge question ", (Throwable)e);
            return "";
        }
    }

    private boolean isChallengeQuestionsProvided(AuthenticatedUser user, String minimumForcedChallengeQuestionsAnswered) {
        int questionsAnswered = this.getUserAnsweredChallengeSetUris(user).size();
        int challengeQuestionSets = this.getChallengeSetUris(user).size();
        if (StringUtils.isEmpty((String)minimumForcedChallengeQuestionsAnswered)) {
            return questionsAnswered > 0;
        }
        return Integer.parseInt(minimumForcedChallengeQuestionsAnswered) <= questionsAnswered || questionsAnswered == challengeQuestionSets;
    }

    private List<ChallengeQuestion> getChallengeQuestions(AuthenticatedUser user) {
        String tenantDomain = user.getTenantDomain();
        try {
            return ChallengeQuestionManager.getInstance().getAllChallengeQuestions(tenantDomain);
        }
        catch (IdentityRecoveryServerException e) {
            log.error((Object)("Identity recovery server error occurred for user:" + user.getUserName()), (Throwable)((Object)e));
            return null;
        }
    }

    private List<String> getChallengeSetUris(AuthenticatedUser user) {
        List<ChallengeQuestion> challengeQuestions = this.getChallengeQuestions(user);
        HashSet<String> questionSetNames = new HashSet<String>();
        if (CollectionUtils.isEmpty(challengeQuestions)) {
            return new ArrayList<String>();
        }
        for (ChallengeQuestion question : challengeQuestions) {
            if (!StringUtils.isNotBlank((String)question.getQuestionSetId())) continue;
            questionSetNames.add(question.getQuestionSetId());
        }
        ArrayList<String> challengeSetUriList = new ArrayList<String>(questionSetNames);
        Collections.sort(challengeSetUriList);
        return challengeSetUriList;
    }

    private List<String> getUserAnsweredChallengeSetUris(AuthenticatedUser user) {
        List<String> questionSetsAnswered = new ArrayList<String>();
        String userName = UserCoreUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain());
        try {
            int tenantId = Utils.getTenantId((String)user.getTenantDomain());
            UserStoreManager userStoreManager = this.getUserStoreManager(tenantId);
            if (userStoreManager != null) {
                Map claimsMap = userStoreManager.getUserClaimValues(userName, new String[]{"http://wso2.org/claims/challengeQuestionUris"}, "default");
                String claimValue = (String)claimsMap.get("http://wso2.org/claims/challengeQuestionUris");
                if (StringUtils.isBlank((String)claimValue)) {
                    return questionSetsAnswered;
                }
                questionSetsAnswered = Arrays.asList(claimValue.split("!"));
            }
        }
        catch (IdentityException | UserStoreException e) {
            log.error((Object)("Exception occurred while retrieving tenant ID for the user :" + userName), e);
        }
        return questionSetsAnswered;
    }

    private UserStoreManager getUserStoreManager(int tenantId) throws IdentityRecoveryServerException {
        UserStoreManager userStoreManager;
        RealmService realmService = IdentityRecoveryServiceDataHolder.getInstance().getRealmService();
        try {
            if (realmService.getTenantUserRealm(tenantId) == null) {
                throw org.wso2.carbon.identity.recovery.util.Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER, null);
            }
            userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                String error = String.format("Error retrieving the user store manager for the tenant : %s", tenantId);
                log.debug((Object)error, (Throwable)e);
            }
            throw org.wso2.carbon.identity.recovery.util.Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_GETTING_USERSTORE_MANAGER, null, e);
        }
        return userStoreManager;
    }

    private void setChallengeQuestionAnswers(User user, UserChallengeAnswer[] userChallengeAnswers) {
        try {
            ChallengeQuestionManager.getInstance().setChallengesOfUser(user, userChallengeAnswers);
        }
        catch (IdentityRecoveryException e) {
            log.error((Object)("Unable to save challenge question answers for user : " + user.getUserName()), (Throwable)((Object)e));
        }
    }

    private UserChallengeAnswer[] retrieveChallengeQuestionAnswers(HttpServletRequest servletRequest, List<ChallengeQuestion> challengeQuestionsList) {
        HashMap<String, String> questionsMap = new HashMap<String, String>();
        HashMap<String, String> answersMap = new HashMap<String, String>();
        ArrayList<UserChallengeAnswer> questionsAndAnswers = new ArrayList<UserChallengeAnswer>();
        Enumeration paramNames = servletRequest.getParameterNames();
        ArrayList<String> paramNamesList = Collections.list(paramNames);
        for (String requestParam : paramNamesList) {
            if (requestParam.contains(SELECTED_CHALLENGE_QUESTION_PREFIX)) {
                String question = servletRequest.getParameter(requestParam);
                String questionSetID = requestParam.replace(SELECTED_CHALLENGE_QUESTION_PREFIX, "");
                questionsMap.put(questionSetID, question);
                continue;
            }
            if (!requestParam.contains(CHALLENGE_QUESTION_ANSWER_PREFIX)) continue;
            String answer = servletRequest.getParameter(requestParam);
            String answerSetID = requestParam.replace(CHALLENGE_QUESTION_ANSWER_PREFIX, "");
            answersMap.put(answerSetID, answer);
        }
        for (String questionKey : questionsMap.keySet()) {
            String challengeQuestion = (String)questionsMap.get(questionKey);
            for (ChallengeQuestion question : challengeQuestionsList) {
                if (!StringUtils.equals((String)question.getQuestionSetId(), (String)questionKey) || !StringUtils.equals((String)question.getQuestion(), (String)challengeQuestion)) continue;
                UserChallengeAnswer questionAndAnswer = new UserChallengeAnswer();
                questionAndAnswer.setQuestion(question);
                if (StringUtils.isEmpty((String)((String)answersMap.get(questionKey)))) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Answer not found for challenge question " + question + ", hence not adding challenge question"));
                    continue;
                }
                questionAndAnswer.setAnswer((String)answersMap.get(questionKey));
                questionsAndAnswers.add(questionAndAnswer);
            }
        }
        return questionsAndAnswers.toArray(new UserChallengeAnswer[questionsAndAnswers.size()]);
    }

    private String getUrlEncodedChallengeQuestionsString(AuthenticatedUser user) throws UnsupportedEncodingException {
        StringBuilder challengeQuestionData = new StringBuilder();
        List<ChallengeQuestion> challengeQuestionList = this.getChallengeQuestions(user);
        if (CollectionUtils.isEmpty(challengeQuestionList)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Challenge questions not found for the user: " + user.getUserName() + " in tenant domain: " + user.getTenantDomain()));
            }
            return null;
        }
        for (ChallengeQuestion question : challengeQuestionList) {
            String setId = question.getQuestionSetId();
            String questionId = question.getQuestionId();
            String questionString = question.getQuestion();
            String questionLocale = question.getLocale();
            challengeQuestionData.append(setId).append("|").append(questionId).append("|").append(questionString).append("|").append(questionLocale).append("&");
        }
        return URLEncoder.encode(challengeQuestionData.toString(), StandardCharsets.UTF_8.name());
    }

    private PostAuthnHandlerFlowStatus handleMissingChallengeQuestionRequest(HttpServletResponse httpServletResponse, AuthenticationContext authenticationContext, AuthenticatedUser user) {
        String encodedData = null;
        try {
            encodedData = this.getUrlEncodedChallengeQuestionsString(user);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Error occurred while URL-encoding the challenge question data", (Throwable)e);
        }
        if (StringUtils.isBlank((String)encodedData)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to get challenge questions for user : " + user.getUserName() + " for tenant domain : " + authenticationContext.getTenantDomain()));
            }
            return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
        }
        try {
            httpServletResponse.sendRedirect(ConfigurationFacade.getInstance().getAuthenticationEndpointURL().replace("/login.do", "") + "/add-security-questions.jsp?sessionDataKey=" + authenticationContext.getContextIdentifier() + "&data=" + encodedData + "&sp=" + authenticationContext.getServiceProviderName());
            this.setChallengeQuestionRequestedState(authenticationContext);
            return PostAuthnHandlerFlowStatus.INCOMPLETE;
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while redirecting to challenge questions page", (Throwable)e);
            return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
        }
    }

    private PostAuthnHandlerFlowStatus handleMissingChallengeQuestionResponse(HttpServletRequest httpServletRequest, AuthenticatedUser user) {
        List<ChallengeQuestion> challengeQuestionList = this.getChallengeQuestions(user);
        UserChallengeAnswer[] answersForChallengeQuestions = this.retrieveChallengeQuestionAnswers(httpServletRequest, challengeQuestionList);
        this.setChallengeQuestionAnswers((User)user, answersForChallengeQuestions);
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }
}

