/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserEmailVerificationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(UserEmailVerificationHandler.class);

    public String getName() {
        return "userEmailVerification";
    }

    public String getFriendlyName() {
        return "User Email Verification";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        List<String> roles;
        Map eventProperties = event.getEventProperties();
        String eventName = event.getEventName();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        User user = this.getUser(eventProperties, userStoreManager);
        Map claims = (Map)eventProperties.get("USER_CLAIMS");
        boolean enable = false;
        if ("PRE_ADD_USER".equals(eventName) || "POST_ADD_USER".equals(eventName)) {
            enable = Boolean.parseBoolean(Utils.getConnectorConfig("EmailVerification.Enable", user.getTenantDomain()));
        } else if (("PRE_SET_USER_CLAIMS".equals(eventName) || "POST_SET_USER_CLAIMS".equals(eventName)) && !(enable = Boolean.parseBoolean(Utils.getConnectorConfig("UserClaimUpdate.Email.EnableVerification", user.getTenantDomain())))) {
            if (claims.containsKey("http://wso2.org/claims/emailaddress")) {
                this.invalidatePendingEmailVerification(user, userStoreManager, claims);
            }
            claims.remove("http://wso2.org/claims/identity/verifyEmail");
        }
        if (!enable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Email verification Handler is disabled in tenant: " + user.getTenantDomain() + "for event: " + eventName));
            }
            return;
        }
        String[] roleList = (String[])eventProperties.get("ROLE_LIST");
        if (roleList != null && (roles = Arrays.asList(roleList)).contains("Internal/selfsignup")) {
            return;
        }
        if ("PRE_ADD_USER".equals(eventName)) {
            Claim claim;
            Utils.clearEmailVerifyTemporaryClaim();
            if (claims == null || claims.isEmpty()) {
                return;
            }
            if (claims.containsKey("http://wso2.org/claims/identity/verifyEmail") && Boolean.parseBoolean((String)claims.get("http://wso2.org/claims/identity/verifyEmail"))) {
                claim = new Claim();
                claim.setClaimUri("http://wso2.org/claims/identity/verifyEmail");
                claim.setValue((String)claims.get("http://wso2.org/claims/identity/verifyEmail"));
                Utils.setEmailVerifyTemporaryClaim(claim);
                claims.remove("http://wso2.org/claims/identity/verifyEmail");
            } else if (claims.containsKey("http://wso2.org/claims/identity/askPassword") && Boolean.parseBoolean((String)claims.get("http://wso2.org/claims/identity/askPassword"))) {
                claim = new Claim();
                claim.setClaimUri("http://wso2.org/claims/identity/askPassword");
                claim.setValue((String)claims.get("http://wso2.org/claims/identity/askPassword"));
                Utils.setEmailVerifyTemporaryClaim(claim);
                claims.remove("http://wso2.org/claims/identity/askPassword");
            } else {
                return;
            }
        }
        if ("POST_ADD_USER".equals(eventName)) {
            boolean isAccountLockOnCreation = Boolean.parseBoolean(Utils.getConnectorConfig("EmailVerification.LockOnCreation", user.getTenantDomain()));
            boolean isNotificationInternallyManage = Boolean.parseBoolean(Utils.getConnectorConfig("EmailVerification.Notification.InternallyManage", user.getTenantDomain()));
            Claim claim = Utils.getEmailVerifyTemporaryClaim();
            boolean isAccountClaimExist = Utils.isAccountStateClaimExisting(user.getTenantDomain());
            if (claim == null) {
                return;
            }
            if ("http://wso2.org/claims/identity/verifyEmail".equals(claim.getClaimUri())) {
                if (isNotificationInternallyManage) {
                    if (isAccountClaimExist) {
                        this.setUserClaim("http://wso2.org/claims/identity/accountState", "PENDING_EV", userStoreManager, user);
                    }
                    this.initNotification(user, RecoveryScenarios.SELF_SIGN_UP, RecoverySteps.CONFIRM_SIGN_UP, "emailconfirm".toString());
                }
                if (isAccountLockOnCreation) {
                    this.lockAccount(user, userStoreManager);
                }
            } else if ("http://wso2.org/claims/identity/askPassword".equals(claim.getClaimUri()) && isNotificationInternallyManage) {
                if (isAccountClaimExist) {
                    this.setUserClaim("http://wso2.org/claims/identity/accountState", "PENDING_AP", userStoreManager, user);
                }
                this.initNotification(user, RecoveryScenarios.ASK_PASSWORD, RecoverySteps.UPDATE_PASSWORD, "askPassword".toString());
            }
        }
        if ("PRE_SET_USER_CLAIMS".equals(eventName)) {
            this.preSetUserClaimsOnEmailUpdate(claims, userStoreManager, user);
            claims.remove("http://wso2.org/claims/identity/verifyEmail");
        }
        if ("POST_SET_USER_CLAIMS".equals(eventName)) {
            this.postSetUserClaimsOnEmailUpdate(user, userStoreManager);
            claims.remove("http://wso2.org/claims/identity/verifyEmail");
        }
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        return 65;
    }

    public void lockAccount(User user, UserStoreManager userStoreManager) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Locking user account:" + user.getUserName()));
        }
        this.setUserClaim("http://wso2.org/claims/identity/accountLocked", Boolean.TRUE.toString(), userStoreManager, user);
    }

    protected void initNotification(User user, Enum recoveryScenario, Enum recoveryStep, String notificationType) throws IdentityEventException {
        String secretKey = UUIDGenerator.generateUUID();
        this.initNotification(user, recoveryScenario, recoveryStep, notificationType, secretKey);
    }

    protected void initNotification(User user, Enum recoveryScenario, Enum recoveryStep, String notificationType, String secretKey) throws IdentityEventException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            userRecoveryDataStore.invalidate(user);
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, recoveryScenario, recoveryStep);
            userRecoveryDataStore.store(recoveryDataDO);
            this.triggerNotification(user, notificationType, secretKey, Utils.getArbitraryProperties());
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while sending  notification ", (Throwable)((Object)e));
        }
    }

    private void initNotificationForEmailVerificationOnUpdate(String verificationPendingEmailAddress, User user) throws IdentityEventException {
        String secretKey = UUIDGenerator.generateUUID();
        this.initNotificationForEmailVerificationOnUpdate(user, secretKey, verificationPendingEmailAddress);
    }

    private void initNotificationForEmailVerificationOnUpdate(User user, String secretKey, String verificationPendingEmailAddress) throws IdentityEventException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            userRecoveryDataStore.invalidate(user, RecoveryScenarios.EMAIL_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_EMAIL);
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.EMAIL_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_EMAIL);
            recoveryDataDO.setRemainingSetIds(verificationPendingEmailAddress);
            userRecoveryDataStore.store(recoveryDataDO);
            this.triggerNotification(user, "verifyEmailOnUpdate", secretKey, Utils.getArbitraryProperties(), verificationPendingEmailAddress);
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while sending notification for user: " + user.toFullQualifiedUsername(), (Throwable)((Object)e));
        }
    }

    protected void setRecoveryData(User user, Enum recoveryScenario, Enum recoveryStep, String secretKey) throws IdentityEventException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            userRecoveryDataStore.invalidate(user);
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, recoveryScenario, recoveryStep);
            userRecoveryDataStore.store(recoveryDataDO);
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while setting recovery data for user ", (Throwable)((Object)e));
        }
    }

    protected UserRecoveryData getRecoveryData(User user) throws IdentityEventException {
        UserRecoveryData recoveryData;
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            recoveryData = userRecoveryDataStore.loadWithoutCodeExpiryValidation(user);
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while loading recovery data for user ", (Throwable)((Object)e));
        }
        return recoveryData;
    }

    protected void setUserClaim(String claimName, String claimValue, UserStoreManager userStoreManager, User user) throws IdentityEventException {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put(claimName, claimValue);
        try {
            userStoreManager.setUserClaimValues(user.getUserName(), userClaims, null);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error while setting user claim value :" + user.getUserName(), (Throwable)e);
        }
    }

    protected void triggerNotification(User user, String type, String code, Property[] props) throws IdentityRecoveryException {
        this.triggerNotification(user, type, code, props, null);
    }

    private void triggerNotification(User user, String type, String code, Property[] props, String verificationPendingEmailAddress) throws IdentityRecoveryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending : " + type + " notification to user : " + user.toString()));
        }
        String eventName = "TRIGGER_NOTIFICATION";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        if (StringUtils.isNotBlank((String)verificationPendingEmailAddress)) {
            properties.put("send-to", verificationPendingEmailAddress);
        }
        if (props != null && props.length > 0) {
            for (Property prop : props) {
                properties.put(prop.getKey(), prop.getValue());
            }
        }
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        properties.put("TEMPLATE_TYPE", type);
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    protected User getUser(Map eventProperties, UserStoreManager userStoreManager) {
        String userName = (String)eventProperties.get("user-name");
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        User user = new User();
        user.setUserName(userName);
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(domainName);
        return user;
    }

    private void preSetUserClaimsOnEmailUpdate(Map<String, String> claims, UserStoreManager userStoreManager, User user) throws IdentityEventException {
        if (IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString().equals(Utils.getThreadLocalToSkipSendingEmailVerificationOnUpdate())) {
            return;
        }
        if (Utils.getThreadLocalToSkipSendingEmailVerificationOnUpdate() != null) {
            Utils.unsetThreadLocalToSkipSendingEmailVerificationOnUpdate();
        }
        if (MapUtils.isEmpty(claims)) {
            Utils.setThreadLocalToSkipSendingEmailVerificationOnUpdate(IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
            return;
        }
        String emailAddress = claims.get("http://wso2.org/claims/emailaddress");
        if (StringUtils.isNotBlank((String)emailAddress)) {
            String existingEmail;
            String username = user.getUserName();
            try {
                existingEmail = userStoreManager.getUserClaimValue(username, "http://wso2.org/claims/emailaddress", null);
            }
            catch (UserStoreException e) {
                String error = String.format("Error occurred while retrieving existing email address for user: %s in domain : %s", username, user.getTenantDomain());
                throw new IdentityEventException(error, (Throwable)e);
            }
            if (emailAddress.equals(existingEmail)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("The email address to be updated: %s is same as the existing email address for user: %s in domain %s. Hence an email verification will not be triggered.", emailAddress, username, user.getTenantDomain()));
                }
                Utils.setThreadLocalToSkipSendingEmailVerificationOnUpdate(IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_EXISTING_EMAIL.toString());
                this.invalidatePendingEmailVerification(user, userStoreManager, claims);
                return;
            }
            if (Utils.isUseVerifyClaimEnabled() && !this.isVerifyEmailClaimAvailable(claims)) {
                Utils.setThreadLocalToSkipSendingEmailVerificationOnUpdate(IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
                this.invalidatePendingEmailVerification(user, userStoreManager, claims);
                return;
            }
            claims.put("http://wso2.org/claims/identity/emailaddress.pendingValue", emailAddress);
            claims.remove("http://wso2.org/claims/emailaddress");
        } else {
            Utils.setThreadLocalToSkipSendingEmailVerificationOnUpdate(IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postSetUserClaimsOnEmailUpdate(User user, UserStoreManager userStoreManager) throws IdentityEventException {
        try {
            String pendingVerificationEmailClaimValue;
            String skipEmailVerificationOnUpdateState = Utils.getThreadLocalToSkipSendingEmailVerificationOnUpdate();
            if (!IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString().equals(skipEmailVerificationOnUpdateState) && !IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_EXISTING_EMAIL.toString().equals(skipEmailVerificationOnUpdateState) && !IdentityRecoveryConstants.SkipEmailVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString().equals(skipEmailVerificationOnUpdateState) && StringUtils.isNotBlank((String)(pendingVerificationEmailClaimValue = this.getPendingVerificationEmailValue(userStoreManager, user)))) {
                this.initNotificationForEmailVerificationOnUpdate(pendingVerificationEmailClaimValue, user);
            }
        }
        finally {
            Utils.unsetThreadLocalToSkipSendingEmailVerificationOnUpdate();
        }
    }

    private String getPendingVerificationEmailValue(UserStoreManager userStoreManager, User user) throws IdentityEventException {
        Map verificationPendingEmailClaimMap;
        try {
            verificationPendingEmailClaimMap = userStoreManager.getUserClaimValues(user.getUserName(), new String[]{"http://wso2.org/claims/identity/emailaddress.pendingValue"}, null);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error while retrieving verification pending email claim value for user: " + user.toFullQualifiedUsername(), (Throwable)e);
        }
        if (MapUtils.isEmpty((Map)verificationPendingEmailClaimMap)) {
            return null;
        }
        for (Map.Entry entry : verificationPendingEmailClaimMap.entrySet()) {
            String pendingVerificationEmailClaimURI = (String)entry.getKey();
            if (!pendingVerificationEmailClaimURI.equals("http://wso2.org/claims/identity/emailaddress.pendingValue")) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private void invalidatePendingEmailVerification(User user, UserStoreManager userStoreManager, Map<String, String> claims) throws IdentityEventException {
        if (StringUtils.isNotBlank((String)this.getPendingVerificationEmailValue(userStoreManager, user))) {
            claims.put("http://wso2.org/claims/identity/emailaddress.pendingValue", "");
            try {
                UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
                userRecoveryDataStore.invalidate(user, RecoveryScenarios.EMAIL_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_EMAIL);
            }
            catch (IdentityRecoveryException e) {
                throw new IdentityEventException("Error while invalidating previous email verification data from recovery store for user: " + user.toFullQualifiedUsername(), (Throwable)((Object)e));
            }
        }
    }

    private boolean isVerifyEmailClaimAvailable(Map<String, String> claims) {
        return claims.containsKey("http://wso2.org/claims/identity/verifyEmail") && Boolean.parseBoolean(claims.get("http://wso2.org/claims/identity/verifyEmail"));
    }
}

