/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.handler.UserEmailVerificationHandler;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserStoreManager;

public class TenantRegistrationVerificationHandler
extends UserEmailVerificationHandler {
    private static final Log log = LogFactory.getLog(TenantRegistrationVerificationHandler.class);

    @Override
    public String getName() {
        return "tenantRegistrationVerificationHandler";
    }

    @Override
    public String getFriendlyName() {
        return "Tenant registration Email Verification";
    }

    @Override
    public void handleEvent(Event event) throws IdentityEventException {
        String eventName = event.getEventName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling event : " + eventName));
        }
        Map eventProperties = event.getEventProperties();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        Map claims = (Map)eventProperties.get("USER_CLAIMS");
        if (this.isTenantRegistrationRequest(claims, eventName)) {
            this.handleClaimUpdate(eventProperties, userStoreManager, claims);
        }
    }

    private boolean isTenantRegistrationRequest(Map<String, String> claims, String eventName) throws IdentityEventException {
        return "PRE_SET_USER_CLAIMS".equals(eventName) && Boolean.valueOf(claims.get("http://wso2.org/claims/identity/tenantAdminAskPassword")) != false;
    }

    @Override
    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    @Override
    public int getPriority(MessageContext messageContext) {
        return 26;
    }

    protected void handleClaimUpdate(Map<String, Object> eventProperties, UserStoreManager userStoreManager, Map<String, String> claims) throws IdentityEventException {
        User user = this.getUser(eventProperties, userStoreManager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PreSetUserClaim - TenantRegistrationVerificationHandler for : " + user.toString() + ". This is an update request for the claim:  " + "http://wso2.org/claims/identity/tenantAdminAskPassword"));
        }
        claims.remove("http://wso2.org/claims/identity/tenantAdminAskPassword");
        String uuid = UUIDGenerator.generateUUID();
        String notificationType = "tenantRegistrationConfirmation";
        if (claims.containsKey("http://wso2.org/claims/identity/accountLocked")) {
            claims.remove("http://wso2.org/claims/identity/accountLocked");
        }
        this.setRecoveryData(user, RecoveryScenarios.TENANT_ADMIN_ASK_PASSWORD, RecoverySteps.UPDATE_PASSWORD, uuid);
        this.lockAccount(user, userStoreManager);
        try {
            this.triggerNotification(user, notificationType, uuid, Utils.getArbitraryProperties());
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while sending  notification.", (Throwable)((Object)e));
        }
    }
}

