/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class MobileNumberVerificationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(MobileNumberVerificationHandler.class);

    public String getName() {
        return "userMobileVerification";
    }

    public String getFriendlyName() {
        return "User Mobile Number Verification";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        Map eventProperties = event.getEventProperties();
        String eventName = event.getEventName();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        User user = this.getUser((String)eventProperties.get("user-name"), (String)eventProperties.get("tenant-domain"), userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName"));
        Map claims = (Map)eventProperties.get("USER_CLAIMS");
        boolean enable = this.isMobileVerificationOnUpdateEnabled(user.getTenantDomain());
        if (!enable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mobile number verification handler is disabled in tenant: " + user.getTenantDomain() + " for event: " + eventName));
            }
            if (claims.containsKey("http://wso2.org/claims/mobile")) {
                this.invalidatePendingMobileVerification(user, userStoreManager, claims);
            }
            claims.remove("http://wso2.org/claims/identity/verifyMobile");
            return;
        }
        if ("PRE_SET_USER_CLAIMS".equals(eventName)) {
            this.preSetUserClaimOnMobileNumberUpdate(claims, userStoreManager, user);
            claims.remove("http://wso2.org/claims/identity/verifyMobile");
        }
        if ("POST_SET_USER_CLAIMS".equals(eventName)) {
            this.postSetUserClaimOnMobileNumberUpdate(user, userStoreManager);
            claims.remove("http://wso2.org/claims/identity/verifyMobile");
        }
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        int priority = super.getPriority(messageContext);
        if (priority == -1) {
            return 50;
        }
        return priority;
    }

    private void initNotificationForMobileNumberVerificationOnUpdate(User user, String verificationPendingMobileNumber) throws IdentityEventException {
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        try {
            userRecoveryDataStore.invalidate(user, RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_MOBILE_NUMBER);
            String secretKey = Utils.generateSecretKey(NotificationChannels.SMS_CHANNEL.getChannelType(), user.getTenantDomain(), String.valueOf((Object)RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE));
            UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_MOBILE_NUMBER);
            recoveryDataDO.setRemainingSetIds(verificationPendingMobileNumber);
            userRecoveryDataStore.store(recoveryDataDO);
            this.triggerNotification(user, secretKey, Utils.getArbitraryProperties(), verificationPendingMobileNumber);
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error while sending notification to user: " + user.toFullQualifiedUsername() + " for mobile verification on update.", (Throwable)((Object)e));
        }
    }

    private void triggerNotification(User user, String code, Property[] props, String verificationPendingMobileNumber) throws IdentityRecoveryException {
        String notificationType = "verifyMobileOnUpdate";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending: " + notificationType + " notification to user: " + user.toFullQualifiedUsername()));
        }
        String eventName = "TRIGGER_SMS_NOTIFICATION";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("notification-channel", NotificationChannels.SMS_CHANNEL.getChannelType());
        properties.put("TEMPLATE_TYPE", notificationType);
        if (StringUtils.isNotBlank((String)verificationPendingMobileNumber)) {
            properties.put("send-to", verificationPendingMobileNumber);
        }
        if (props != null && props.length > 0) {
            for (Property prop : props) {
                properties.put(prop.getKey(), prop.getValue());
            }
        }
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.toFullQualifiedUsername(), e);
        }
    }

    private User getUser(String userName, String tenantDomain, String userStoreDomain) {
        User user = new User();
        user.setUserName(userName);
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(userStoreDomain);
        return user;
    }

    private void preSetUserClaimOnMobileNumberUpdate(Map<String, String> claims, UserStoreManager userStoreManager, User user) throws IdentityEventException {
        if (IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString().equals(Utils.getThreadLocalToSkipSendingSmsOtpVerificationOnUpdate())) {
            return;
        }
        if (Utils.getThreadLocalToSkipSendingSmsOtpVerificationOnUpdate() != null) {
            Utils.unsetThreadLocalToSkipSendingSmsOtpVerificationOnUpdate();
        }
        if (MapUtils.isEmpty(claims)) {
            Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
            return;
        }
        String mobileNumber = claims.get("http://wso2.org/claims/mobile");
        if (StringUtils.isNotBlank((String)mobileNumber)) {
            String existingMobileNumber;
            String username = user.getUserName();
            try {
                existingMobileNumber = userStoreManager.getUserClaimValue(username, "http://wso2.org/claims/mobile", null);
            }
            catch (UserStoreException e) {
                String error = String.format("Error occurred while retrieving existing mobile number for user: %s in domain: %s and user store: %s", username, user.getTenantDomain(), user.getUserStoreDomain());
                throw new IdentityEventException(error, (Throwable)e);
            }
            if (StringUtils.equals((String)mobileNumber, (String)existingMobileNumber)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("The mobile number to be updated: %s is same as the existing mobile number for user: %s in domain: %s and user store: %s. Hence an SMS OTP verification will not be triggered.", mobileNumber, username, user.getTenantDomain(), user.getUserStoreDomain()));
                }
                Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_EXISTING_MOBILE_NUM.toString());
                this.invalidatePendingMobileVerification(user, userStoreManager, claims);
                return;
            }
            if (Utils.isUseVerifyClaimEnabled() && !this.isVerifyMobileClaimAvailable(claims)) {
                Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
                this.invalidatePendingMobileVerification(user, userStoreManager, claims);
                return;
            }
            if (!this.isInvokedByUser(user)) {
                Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
                return;
            }
            claims.put("http://wso2.org/claims/identity/mobileNumber.pendingValue", mobileNumber);
            claims.remove("http://wso2.org/claims/mobile");
        } else {
            Utils.setThreadLocalToSkipSendingSmsOtpVerificationOnUpdate(IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString());
        }
    }

    private boolean isInvokedByUser(User user) throws IdentityEventException {
        String usernameFromContext = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        String tenantDomainFromContext = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (StringUtils.isNotBlank((String)usernameFromContext)) {
            String userDomain = UserCoreUtil.extractDomainFromName((String)usernameFromContext);
            User invokingUser = this.getUser(UserCoreUtil.removeDomainFromName((String)usernameFromContext), tenantDomainFromContext, userDomain);
            return user.equals((Object)invokingUser);
        }
        throw new IdentityEventException("Error while retrieving the username from CarbonContext during the mobile verification on update flow.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postSetUserClaimOnMobileNumberUpdate(User user, UserStoreManager userStoreManager) throws IdentityEventException {
        try {
            String verificationPendingMobileNumClaim;
            String skipMobileNumVerificationOnUpdateState = Utils.getThreadLocalToSkipSendingSmsOtpVerificationOnUpdate();
            if (!IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_CONFIRM.toString().equals(skipMobileNumVerificationOnUpdateState) && !IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_EXISTING_MOBILE_NUM.toString().equals(skipMobileNumVerificationOnUpdateState) && !IdentityRecoveryConstants.SkipMobileNumberVerificationOnUpdateStates.SKIP_ON_INAPPLICABLE_CLAIMS.toString().equals(skipMobileNumVerificationOnUpdateState) && StringUtils.isNotBlank((String)(verificationPendingMobileNumClaim = this.getVerificationPendingMobileNumValue(userStoreManager, user)))) {
                this.initNotificationForMobileNumberVerificationOnUpdate(user, verificationPendingMobileNumClaim);
            }
        }
        finally {
            Utils.unsetThreadLocalToSkipSendingSmsOtpVerificationOnUpdate();
        }
    }

    private String getVerificationPendingMobileNumValue(UserStoreManager userStoreManager, User user) throws IdentityEventException {
        Map verificationPendingMobileNumClaimMap;
        try {
            verificationPendingMobileNumClaimMap = userStoreManager.getUserClaimValues(user.getUserName(), new String[]{"http://wso2.org/claims/identity/mobileNumber.pendingValue"}, null);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error while retrieving verification pending mobile number claim value for user: " + user.toFullQualifiedUsername(), (Throwable)e);
        }
        if (MapUtils.isEmpty((Map)verificationPendingMobileNumClaimMap)) {
            return null;
        }
        for (Map.Entry entry : verificationPendingMobileNumClaimMap.entrySet()) {
            String pendingVerificationMobileNumClaimURI = (String)entry.getKey();
            if (!"http://wso2.org/claims/identity/mobileNumber.pendingValue".equals(pendingVerificationMobileNumClaimURI)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private boolean isMobileVerificationOnUpdateEnabled(String userTenantDomain) throws IdentityEventException {
        return Boolean.parseBoolean(Utils.getConnectorConfig("UserClaimUpdate.MobileNumber.EnableVerification", userTenantDomain));
    }

    private void invalidatePendingMobileVerification(User user, UserStoreManager userStoreManager, Map<String, String> claims) throws IdentityEventException {
        if (StringUtils.isNotBlank((String)this.getVerificationPendingMobileNumValue(userStoreManager, user))) {
            claims.put("http://wso2.org/claims/identity/mobileNumber.pendingValue", "");
            try {
                UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
                userRecoveryDataStore.invalidate(user, RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE, RecoverySteps.VERIFY_MOBILE_NUMBER);
            }
            catch (IdentityRecoveryException e) {
                throw new IdentityEventException("Error while invalidating previous mobile verification data from recovery store for user: " + user.toFullQualifiedUsername(), (Throwable)((Object)e));
            }
        }
    }

    private boolean isVerifyMobileClaimAvailable(Map<String, String> claims) {
        return claims.containsKey("http://wso2.org/claims/identity/verifyMobile") && Boolean.parseBoolean(claims.get("http://wso2.org/claims/identity/verifyMobile"));
    }
}

