/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.IdentityMgtConstants;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerClientException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannelManager;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class LiteUserRegistrationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(LiteUserRegistrationHandler.class);

    public String getName() {
        return "liteUserRegistration";
    }

    public String getFriendlyName() {
        return "Lite User Registration";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        boolean isLiteSignUp = Utils.isLiteSignUp(Utils.getArbitraryProperties());
        if (!isLiteSignUp) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not lite sign up flow for the user.");
            }
            return;
        }
        User user = new User();
        user.setUserName(userName);
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(domainName);
        boolean enable = Boolean.parseBoolean(Utils.getConnectorConfig("LiteRegistration.Enable", user.getTenantDomain()));
        if (!enable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lite sign up feature is disabled in tenant: " + tenantDomain));
            }
            return;
        }
        boolean isAccountLockOnCreation = Boolean.parseBoolean(Utils.getConnectorConfig("LiteRegistration.LockOnCreation", user.getTenantDomain()));
        boolean isNotificationInternallyManage = Boolean.parseBoolean(Utils.getConnectorConfig("LiteRegistration.Notification.InternallyManage", user.getTenantDomain()));
        if ("POST_ADD_USER".equals(event.getEventName())) {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            try {
                String preferredChannel = this.resolveNotificationChannel(eventProperties, userName, tenantDomain, domainName);
                boolean notificationChannelVerified = this.isNotificationChannelVerified(userName, tenantDomain, preferredChannel, eventProperties);
                if (notificationChannelVerified) {
                    return;
                }
                if (isNotificationInternallyManage && isAccountLockOnCreation) {
                    userRecoveryDataStore.invalidate(user);
                    String secretKey = this.generateSecretKey(preferredChannel);
                    String eventName = this.resolveEventName(preferredChannel, userName, domainName, tenantDomain);
                    UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.LITE_SIGN_UP, RecoverySteps.CONFIRM_LITE_SIGN_UP);
                    recoveryDataDO.setRemainingSetIds(preferredChannel);
                    userRecoveryDataStore.store(recoveryDataDO);
                    this.triggerNotification(user, preferredChannel, secretKey, Utils.getArbitraryProperties(), eventName);
                }
            }
            catch (IdentityRecoveryException e) {
                throw new IdentityEventException("Error while sending lite sign up notification ", (Throwable)((Object)e));
            }
            if (isAccountLockOnCreation) {
                HashMap<String, String> userClaims = new HashMap<String, String>();
                userClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.TRUE.toString());
                if (Utils.isAccountStateClaimExisting(tenantDomain)) {
                    userClaims.put("http://wso2.org/claims/identity/accountState", "PENDING_LR");
                }
                try {
                    userStoreManager.setUserClaimValues(user.getUserName(), userClaims, null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Locked user account: " + user.getUserName()));
                    }
                }
                catch (UserStoreException e) {
                    throw new IdentityEventException("Error while lock user account :" + user.getUserName(), (Throwable)e);
                }
            }
        }
    }

    private String resolveEventName(String preferredChannel, String userName, String domainName, String tenantDomain) {
        String eventName = NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(preferredChannel) ? "TRIGGER_NOTIFICATION" : "TRIGGER_" + preferredChannel + "_NOTIFICATION";
        if (log.isDebugEnabled()) {
            String message = String.format("For user : %1$s in domain : %2$s, notifications were sent from the event : %3$s", domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain, eventName);
            log.debug((Object)message);
        }
        return eventName;
    }

    private String resolveNotificationChannel(Map<String, Object> eventProperties, String userName, String tenantDomain, String domainName) throws IdentityEventException {
        if (!Boolean.parseBoolean(IdentityUtil.getProperty((String)"Notification.ResolveNotificationChannels.Enable"))) {
            return IdentityGovernanceUtil.getDefaultNotificationChannel();
        }
        String preferredChannel = (String)eventProperties.get("http://wso2.org/claims/identity/preferredChannel");
        if (StringUtils.isEmpty((String)preferredChannel)) {
            NotificationChannelManager notificationChannelManager = Utils.getNotificationChannelManager();
            try {
                preferredChannel = notificationChannelManager.resolveCommunicationChannel(userName, tenantDomain, domainName);
            }
            catch (NotificationChannelManagerException e) {
                this.handledNotificationChannelManagerException(e, userName, domainName, tenantDomain);
            }
        }
        if (log.isDebugEnabled()) {
            String message = String.format("Notification channel : %1$s for the user : %2$s in domain : %3$s.", preferredChannel, domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain);
            log.debug((Object)message);
        }
        return preferredChannel;
    }

    private void handledNotificationChannelManagerException(NotificationChannelManagerException e, String userName, String domainName, String tenantDomain) throws IdentityEventException {
        if (StringUtils.isNotEmpty((String)e.getErrorCode()) && StringUtils.isNotEmpty((String)e.getMessage())) {
            if (IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS.getCode().equals(e.getErrorCode())) {
                if (log.isDebugEnabled()) {
                    String error = String.format("No communication channel for user : %1$s in domain: %2$s", domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain);
                    log.debug((Object)error, (Throwable)e);
                }
            } else if (log.isDebugEnabled()) {
                String error = String.format("Error getting claim values for user : %1$s in domain: %2$s", domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain);
                log.debug((Object)error, (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            String error = String.format("Error getting claim values for user : %1$s in domain: %2$s", domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain);
            log.debug((Object)error, (Throwable)e);
        }
        throw new IdentityEventException(e.getErrorCode(), e.getMessage());
    }

    private boolean isNotificationChannelVerified(String username, String tenantDomain, String notificationChannel, Map<String, Object> eventProperties) throws IdentityRecoveryClientException {
        boolean isEnableAccountLockForVerifiedPreferredChannelEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"SelfRegistration.EnableAccountLockForVerifiedPreferredChannel"));
        if (!isEnableAccountLockForVerifiedPreferredChannelEnabled) {
            NotificationChannels channel;
            String verifiedClaimUri;
            boolean notificationChannelVerified;
            if (log.isDebugEnabled()) {
                String message = String.format("SkipAccountLockOnVerifiedPreferredChannel is enabled for user : %s in domain : %s. Checking whether the user is already verified", username, tenantDomain);
                log.debug((Object)message);
            }
            if ((notificationChannelVerified = Boolean.parseBoolean((String)eventProperties.get(verifiedClaimUri = (channel = this.getNotificationChannel(username, notificationChannel)).getVerifiedClaimUrl()))) && log.isDebugEnabled()) {
                String message = String.format("Preferred Notification channel : %1$s is verified for the user : %2$s in domain : %3$s. Therefore, no notifications will be sent.", notificationChannel, username, tenantDomain);
                log.debug((Object)message);
            }
            return notificationChannelVerified;
        }
        return false;
    }

    private NotificationChannels getNotificationChannel(String username, String notificationChannel) throws IdentityRecoveryClientException {
        NotificationChannels channel;
        try {
            channel = NotificationChannels.getNotificationChannel((String)notificationChannel);
        }
        catch (NotificationChannelManagerClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported channel type : " + notificationChannel));
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNELS, username, e);
        }
        return channel;
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        return 60;
    }

    private void triggerNotification(User user, String notificationChannel, String code, Property[] props, String eventName) throws IdentityRecoveryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending lite user registration notification user: " + user.getUserName()));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        properties.put("notification-channel", notificationChannel);
        if (props != null && props.length > 0) {
            for (Property prop : props) {
                properties.put(prop.getKey(), prop.getValue());
            }
        }
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        properties.put("TEMPLATE_TYPE", "liteUserEmailConfirmation");
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private String generateSMSOTP() {
        char[] chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(chars[rnd.nextInt(chars.length)]);
        }
        return sb.toString();
    }

    private String generateSecretKey(String channel) {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(channel)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OTP was generated for the user for channel : " + channel));
            }
            return this.generateSMSOTP();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("UUID was generated for the user for channel : " + channel));
        }
        return UUIDGenerator.generateUUID();
    }
}

