/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class IdentityUserMetadataMgtHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(IdentityUserMetadataMgtHandler.class);
    private static final String POST_AUTHENTICATION = "post_authentication";
    private static final String POST_CREDENTIAL_UPDATE = "post_credential_update";
    private static final String ENABLE_IDENTITY_USER_METADATA_MGT_HANDLER = "identityUserMetadataMgtHandler.enable";

    public void handleEvent(Event event) throws IdentityEventException {
        Map eventProperties = event.getEventProperties();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        boolean enable = Boolean.parseBoolean(this.configs.getModuleProperties().getProperty(ENABLE_IDENTITY_USER_METADATA_MGT_HANDLER));
        if (!enable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity User Metadata Management handler is not enabled.");
            }
            return;
        }
        if ("POST_AUTHENTICATION".equals(event.getEventName())) {
            this.handlePostAuthenticate(eventProperties, userStoreManager);
        } else if ("POST_UPDATE_CREDENTIAL".equals(event.getEventName()) || "POST_UPDATE_CREDENTIAL_BY_ADMIN".equals(event.getEventName())) {
            this.handleCredentialUpdate(eventProperties, userStoreManager);
        }
    }

    private void handlePostAuthenticate(Map<String, Object> eventProperties, UserStoreManager userStoreManager) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start handling post authentication event.");
        }
        if (((Boolean)eventProperties.get("OPERATION_STATUS")).booleanValue()) {
            String lastLoginTime = Long.toString(System.currentTimeMillis());
            this.setUserClaim(userStoreManager, eventProperties, "http://wso2.org/claims/identity/lastLogonTime", lastLoginTime, POST_AUTHENTICATION);
        }
    }

    private void handleCredentialUpdate(Map<String, Object> eventProperties, UserStoreManager userStoreManager) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start handling post credential update event.");
        }
        String lastPasswordUpdateTime = Long.toString(System.currentTimeMillis());
        this.setUserClaim(userStoreManager, eventProperties, "http://wso2.org/claims/identity/lastPasswordUpdateTime", lastPasswordUpdateTime, POST_CREDENTIAL_UPDATE);
    }

    private void setUserClaim(UserStoreManager userStoreManager, Map<String, Object> eventProperties, String claimURI, String claimValue, String eventName) throws IdentityEventException {
        String username = (String)eventProperties.get("user-name");
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put(claimURI, claimValue);
        try {
            userStoreManager.setUserClaimValues(username, userClaims, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully updated the user claims related to %s event.", eventName));
            }
        }
        catch (UserStoreException e) {
            throw new IdentityEventException(String.format("Error occurred while updating user claims related to %s event.", eventName), (Throwable)e);
        }
    }

    public String getName() {
        return "identityUserMetadataMgtHandler";
    }

    public int getPriority(MessageContext messageContext) {
        return 50;
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public String getFriendlyName() {
        return "Identity User Metadata Management Handler";
    }
}

