/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementClientException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.handler.function.ResourceToProperties;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.util.Utils;

public class ConfigStoreFunctionalityLockPropertyHandler {
    private static final Log log = LogFactory.getLog(ConfigStoreFunctionalityLockPropertyHandler.class);
    private static final boolean isDetailedErrorMessagesEnabled = Utils.isDetailedErrorResponseEnabled();
    private static ConfigStoreFunctionalityLockPropertyHandler instance = new ConfigStoreFunctionalityLockPropertyHandler();

    private ConfigStoreFunctionalityLockPropertyHandler() {
    }

    public static ConfigStoreFunctionalityLockPropertyHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfigStoreProperties(String tenantDomain, String functionalityIdentifier) throws IdentityRecoveryClientException {
        Map<String, String> properties;
        try {
            FrameworkUtils.startTenantFlow((String)tenantDomain);
            try {
                if (!this.isFunctionalityLockResourceTypeExists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User Functionality properties are not configured. Resorting to default values.");
                    }
                    Map<String, String> resource = this.getDefaultConfigurationPropertiesMap();
                    return resource;
                }
                Resource resource = IdentityRecoveryServiceDataHolder.getInstance().getConfigurationManager().getResource("functionalityLock", functionalityIdentifier);
                properties = new ResourceToProperties().apply(resource);
            }
            catch (ConfigurationManagementException e) {
                StringBuilder message = new StringBuilder(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_FETCH_RESOURCE_FROM_CONFIG_STORE.getMessage());
                if (isDetailedErrorMessagesEnabled) {
                    message.append("\nresource type: ").append("functionalityLock");
                    message.append("\nresource: ").append(functionalityIdentifier);
                }
                throw (IdentityRecoveryClientException)IdentityException.error(IdentityRecoveryClientException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_FETCH_RESOURCE_FROM_CONFIG_STORE.getCode(), (String)message.toString());
            }
        }
        finally {
            FrameworkUtils.endTenantFlow();
        }
        return properties;
    }

    private Map<String, String> getDefaultConfigurationPropertiesMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("MaxAttempts", "5");
        properties.put("LockoutTime", "5");
        properties.put("TimeoutRatio", "2");
        return properties;
    }

    private boolean isFunctionalityLockResourceTypeExists() throws ConfigurationManagementException {
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getConfigurationManager().getResourceType("functionalityLock");
        }
        catch (ConfigurationManagementClientException e) {
            if (ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_DOES_NOT_EXISTS.getCode().equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
        return true;
    }
}

