/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.bean.IdentityEventMessageContext;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.user.core.UserStoreManager;

public class CodeInvalidationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(CodeInvalidationHandler.class);

    public String getName() {
        return "confirmationCodesInvalidate";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        String eventName = event.getEventName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling event : " + eventName));
        }
        if ("POST_DELETE_USER".equals(event.getEventName())) {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            Map eventProperties = event.getEventProperties();
            String userName = (String)eventProperties.get("user-name");
            UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
            String tenantDomain = (String)eventProperties.get("tenant-domain");
            String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
            User user = new User();
            user.setUserName(userName);
            user.setTenantDomain(tenantDomain);
            user.setUserStoreDomain(domainName);
            try {
                userRecoveryDataStore.invalidate(user);
            }
            catch (IdentityRecoveryException e) {
                throw new IdentityEventException("Error while invalidating codes.", (Throwable)((Object)e));
            }
        }
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        int priority = super.getPriority(messageContext);
        if (priority == -1) {
            priority = 70;
        }
        return priority;
    }

    public boolean canHandle(MessageContext messageContext) throws IdentityRuntimeException {
        Event event = ((IdentityEventMessageContext)messageContext).getEvent();
        String eventName = event.getEventName();
        return "POST_DELETE_USER".equals(eventName);
    }

    public boolean isAssociationAsync(String eventName) throws IdentityEventException {
        return false;
    }
}

